/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ApplicationType;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class RegisteredServer
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=432");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=433");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=434");
    private final String serverUri;
    private final String productUri;
    private final LocalizedText[] serverNames;
    private final ApplicationType serverType;
    private final String gatewayServerUri;
    private final String[] discoveryUrls;
    private final String semaphoreFilePath;
    private final Boolean isOnline;

    public RegisteredServer(String serverUri, String productUri, LocalizedText[] serverNames, ApplicationType serverType, String gatewayServerUri, String[] discoveryUrls, String semaphoreFilePath, Boolean isOnline) {
        this.serverUri = serverUri;
        this.productUri = productUri;
        this.serverNames = serverNames;
        this.serverType = serverType;
        this.gatewayServerUri = gatewayServerUri;
        this.discoveryUrls = discoveryUrls;
        this.semaphoreFilePath = semaphoreFilePath;
        this.isOnline = isOnline;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public String getServerUri() {
        return this.serverUri;
    }

    public String getProductUri() {
        return this.productUri;
    }

    public LocalizedText[] getServerNames() {
        return this.serverNames;
    }

    public ApplicationType getServerType() {
        return this.serverType;
    }

    public String getGatewayServerUri() {
        return this.gatewayServerUri;
    }

    public String[] getDiscoveryUrls() {
        return this.discoveryUrls;
    }

    public String getSemaphoreFilePath() {
        return this.semaphoreFilePath;
    }

    public Boolean getIsOnline() {
        return this.isOnline;
    }

    protected RegisteredServer(RegisteredServerBuilder<?, ?> b) {
        super(b);
        this.serverUri = ((RegisteredServerBuilder)b).serverUri;
        this.productUri = ((RegisteredServerBuilder)b).productUri;
        this.serverNames = ((RegisteredServerBuilder)b).serverNames;
        this.serverType = ((RegisteredServerBuilder)b).serverType;
        this.gatewayServerUri = ((RegisteredServerBuilder)b).gatewayServerUri;
        this.discoveryUrls = ((RegisteredServerBuilder)b).discoveryUrls;
        this.semaphoreFilePath = ((RegisteredServerBuilder)b).semaphoreFilePath;
        this.isOnline = ((RegisteredServerBuilder)b).isOnline;
    }

    public static RegisteredServerBuilder<?, ?> builder() {
        return new RegisteredServerBuilderImpl();
    }

    public RegisteredServerBuilder<?, ?> toBuilder() {
        return new RegisteredServerBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegisteredServer)) {
            return false;
        }
        RegisteredServer other = (RegisteredServer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isOnline = this.getIsOnline();
        Boolean other$isOnline = other.getIsOnline();
        if (this$isOnline == null ? other$isOnline != null : !((Object)this$isOnline).equals(other$isOnline)) {
            return false;
        }
        String this$serverUri = this.getServerUri();
        String other$serverUri = other.getServerUri();
        if (this$serverUri == null ? other$serverUri != null : !this$serverUri.equals(other$serverUri)) {
            return false;
        }
        String this$productUri = this.getProductUri();
        String other$productUri = other.getProductUri();
        if (this$productUri == null ? other$productUri != null : !this$productUri.equals(other$productUri)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getServerNames(), other.getServerNames())) {
            return false;
        }
        ApplicationType this$serverType = this.getServerType();
        ApplicationType other$serverType = other.getServerType();
        if (this$serverType == null ? other$serverType != null : !this$serverType.equals(other$serverType)) {
            return false;
        }
        String this$gatewayServerUri = this.getGatewayServerUri();
        String other$gatewayServerUri = other.getGatewayServerUri();
        if (this$gatewayServerUri == null ? other$gatewayServerUri != null : !this$gatewayServerUri.equals(other$gatewayServerUri)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getDiscoveryUrls(), other.getDiscoveryUrls())) {
            return false;
        }
        String this$semaphoreFilePath = this.getSemaphoreFilePath();
        String other$semaphoreFilePath = other.getSemaphoreFilePath();
        return !(this$semaphoreFilePath == null ? other$semaphoreFilePath != null : !this$semaphoreFilePath.equals(other$semaphoreFilePath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegisteredServer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isOnline = this.getIsOnline();
        result = result * 59 + ($isOnline == null ? 43 : ((Object)$isOnline).hashCode());
        String $serverUri = this.getServerUri();
        result = result * 59 + ($serverUri == null ? 43 : $serverUri.hashCode());
        String $productUri = this.getProductUri();
        result = result * 59 + ($productUri == null ? 43 : $productUri.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getServerNames());
        ApplicationType $serverType = this.getServerType();
        result = result * 59 + ($serverType == null ? 43 : $serverType.hashCode());
        String $gatewayServerUri = this.getGatewayServerUri();
        result = result * 59 + ($gatewayServerUri == null ? 43 : $gatewayServerUri.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getDiscoveryUrls());
        String $semaphoreFilePath = this.getSemaphoreFilePath();
        result = result * 59 + ($semaphoreFilePath == null ? 43 : $semaphoreFilePath.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "RegisteredServer(serverUri=" + this.getServerUri() + ", productUri=" + this.getProductUri() + ", serverNames=" + Arrays.deepToString(this.getServerNames()) + ", serverType=" + this.getServerType() + ", gatewayServerUri=" + this.getGatewayServerUri() + ", discoveryUrls=" + Arrays.deepToString(this.getDiscoveryUrls()) + ", semaphoreFilePath=" + this.getSemaphoreFilePath() + ", isOnline=" + this.getIsOnline() + ")";
    }

    private static final class RegisteredServerBuilderImpl
    extends RegisteredServerBuilder<RegisteredServer, RegisteredServerBuilderImpl> {
        private RegisteredServerBuilderImpl() {
        }

        @Override
        protected RegisteredServerBuilderImpl self() {
            return this;
        }

        @Override
        public RegisteredServer build() {
            return new RegisteredServer(this);
        }
    }

    public static abstract class RegisteredServerBuilder<C extends RegisteredServer, B extends RegisteredServerBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private String serverUri;
        private String productUri;
        private LocalizedText[] serverNames;
        private ApplicationType serverType;
        private String gatewayServerUri;
        private String[] discoveryUrls;
        private String semaphoreFilePath;
        private Boolean isOnline;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            RegisteredServerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(RegisteredServer instance, RegisteredServerBuilder<?, ?> b) {
            b.serverUri(instance.serverUri);
            b.productUri(instance.productUri);
            b.serverNames(instance.serverNames);
            b.serverType(instance.serverType);
            b.gatewayServerUri(instance.gatewayServerUri);
            b.discoveryUrls(instance.discoveryUrls);
            b.semaphoreFilePath(instance.semaphoreFilePath);
            b.isOnline(instance.isOnline);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B serverUri(String serverUri) {
            this.serverUri = serverUri;
            return (B)this.self();
        }

        public B productUri(String productUri) {
            this.productUri = productUri;
            return (B)this.self();
        }

        public B serverNames(LocalizedText[] serverNames) {
            this.serverNames = serverNames;
            return (B)this.self();
        }

        public B serverType(ApplicationType serverType) {
            this.serverType = serverType;
            return (B)this.self();
        }

        public B gatewayServerUri(String gatewayServerUri) {
            this.gatewayServerUri = gatewayServerUri;
            return (B)this.self();
        }

        public B discoveryUrls(String[] discoveryUrls) {
            this.discoveryUrls = discoveryUrls;
            return (B)this.self();
        }

        public B semaphoreFilePath(String semaphoreFilePath) {
            this.semaphoreFilePath = semaphoreFilePath;
            return (B)this.self();
        }

        public B isOnline(Boolean isOnline) {
            this.isOnline = isOnline;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "RegisteredServer.RegisteredServerBuilder(super=" + super.toString() + ", serverUri=" + this.serverUri + ", productUri=" + this.productUri + ", serverNames=" + Arrays.deepToString(this.serverNames) + ", serverType=" + this.serverType + ", gatewayServerUri=" + this.gatewayServerUri + ", discoveryUrls=" + Arrays.deepToString(this.discoveryUrls) + ", semaphoreFilePath=" + this.semaphoreFilePath + ", isOnline=" + this.isOnline + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<RegisteredServer> {
        @Override
        public Class<RegisteredServer> getType() {
            return RegisteredServer.class;
        }

        @Override
        public RegisteredServer decode(SerializationContext context, UaDecoder decoder) {
            String serverUri = decoder.readString("ServerUri");
            String productUri = decoder.readString("ProductUri");
            LocalizedText[] serverNames = decoder.readLocalizedTextArray("ServerNames");
            ApplicationType serverType = decoder.readEnum("ServerType", ApplicationType.class);
            String gatewayServerUri = decoder.readString("GatewayServerUri");
            String[] discoveryUrls = decoder.readStringArray("DiscoveryUrls");
            String semaphoreFilePath = decoder.readString("SemaphoreFilePath");
            Boolean isOnline = decoder.readBoolean("IsOnline");
            return new RegisteredServer(serverUri, productUri, serverNames, serverType, gatewayServerUri, discoveryUrls, semaphoreFilePath, isOnline);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, RegisteredServer value) {
            encoder.writeString("ServerUri", value.getServerUri());
            encoder.writeString("ProductUri", value.getProductUri());
            encoder.writeLocalizedTextArray("ServerNames", value.getServerNames());
            encoder.writeEnum("ServerType", value.getServerType());
            encoder.writeString("GatewayServerUri", value.getGatewayServerUri());
            encoder.writeStringArray("DiscoveryUrls", value.getDiscoveryUrls());
            encoder.writeString("SemaphoreFilePath", value.getSemaphoreFilePath());
            encoder.writeBoolean("IsOnline", value.getIsOnline());
        }
    }
}

