/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.NotificationData;

public class StatusChangeNotification
extends NotificationData
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=818");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=820");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=819");
    private final StatusCode status;
    private final DiagnosticInfo diagnosticInfo;

    public StatusChangeNotification(StatusCode status, DiagnosticInfo diagnosticInfo) {
        this.status = status;
        this.diagnosticInfo = diagnosticInfo;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public StatusCode getStatus() {
        return this.status;
    }

    public DiagnosticInfo getDiagnosticInfo() {
        return this.diagnosticInfo;
    }

    protected StatusChangeNotification(StatusChangeNotificationBuilder<?, ?> b) {
        super((NotificationData.NotificationDataBuilder<?, ?>)b);
        this.status = ((StatusChangeNotificationBuilder)b).status;
        this.diagnosticInfo = ((StatusChangeNotificationBuilder)b).diagnosticInfo;
    }

    public static StatusChangeNotificationBuilder<?, ?> builder() {
        return new StatusChangeNotificationBuilderImpl();
    }

    public StatusChangeNotificationBuilder<?, ?> toBuilder() {
        return new StatusChangeNotificationBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatusChangeNotification)) {
            return false;
        }
        StatusChangeNotification other = (StatusChangeNotification)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatusCode this$status = this.getStatus();
        StatusCode other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        DiagnosticInfo this$diagnosticInfo = this.getDiagnosticInfo();
        DiagnosticInfo other$diagnosticInfo = other.getDiagnosticInfo();
        return !(this$diagnosticInfo == null ? other$diagnosticInfo != null : !((Object)this$diagnosticInfo).equals(other$diagnosticInfo));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StatusChangeNotification;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        StatusCode $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        DiagnosticInfo $diagnosticInfo = this.getDiagnosticInfo();
        result = result * 59 + ($diagnosticInfo == null ? 43 : ((Object)$diagnosticInfo).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "StatusChangeNotification(status=" + this.getStatus() + ", diagnosticInfo=" + this.getDiagnosticInfo() + ")";
    }

    private static final class StatusChangeNotificationBuilderImpl
    extends StatusChangeNotificationBuilder<StatusChangeNotification, StatusChangeNotificationBuilderImpl> {
        private StatusChangeNotificationBuilderImpl() {
        }

        @Override
        protected StatusChangeNotificationBuilderImpl self() {
            return this;
        }

        @Override
        public StatusChangeNotification build() {
            return new StatusChangeNotification(this);
        }
    }

    public static abstract class StatusChangeNotificationBuilder<C extends StatusChangeNotification, B extends StatusChangeNotificationBuilder<C, B>>
    extends NotificationData.NotificationDataBuilder<C, B> {
        private StatusCode status;
        private DiagnosticInfo diagnosticInfo;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            StatusChangeNotificationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(StatusChangeNotification instance, StatusChangeNotificationBuilder<?, ?> b) {
            b.status(instance.status);
            b.diagnosticInfo(instance.diagnosticInfo);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B status(StatusCode status) {
            this.status = status;
            return (B)this.self();
        }

        public B diagnosticInfo(DiagnosticInfo diagnosticInfo) {
            this.diagnosticInfo = diagnosticInfo;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "StatusChangeNotification.StatusChangeNotificationBuilder(super=" + super.toString() + ", status=" + this.status + ", diagnosticInfo=" + this.diagnosticInfo + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<StatusChangeNotification> {
        @Override
        public Class<StatusChangeNotification> getType() {
            return StatusChangeNotification.class;
        }

        @Override
        public StatusChangeNotification decode(SerializationContext context, UaDecoder decoder) {
            StatusCode status = decoder.readStatusCode("Status");
            DiagnosticInfo diagnosticInfo = decoder.readDiagnosticInfo("DiagnosticInfo");
            return new StatusChangeNotification(status, diagnosticInfo);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, StatusChangeNotification value) {
            encoder.writeStatusCode("Status", value.getStatus());
            encoder.writeDiagnosticInfo("DiagnosticInfo", value.getDiagnosticInfo());
        }
    }
}

