/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestUtil {
    private static final Logger logger = LoggerFactory.getLogger(ManifestUtil.class);
    private static final Map<String, String> ATTRIBUTES = ManifestUtil.readAttributes();

    public static Optional<String> read(String name) {
        return Optional.ofNullable(ATTRIBUTES.get(name));
    }

    public static boolean exists(String name) {
        return ATTRIBUTES.containsKey(name);
    }

    private static Map<String, String> readAttributes() {
        ConcurrentMap attributes = Maps.newConcurrentMap();
        try {
            Enumeration<URL> resources = ManifestUtil.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                attributes.putAll(ManifestUtil.readAttributes(url));
            }
        }
        catch (Throwable t) {
            logger.error("readAttributes() failed", t);
        }
        return attributes;
    }

    private static Map<String, String> readAttributes(URL url) {
        HashMap<String, String> props = new HashMap<String, String>();
        try (InputStream stream = url.openStream();){
            Manifest manifest = new Manifest(stream);
            Attributes attributes = manifest.getMainAttributes();
            for (Object key : attributes.keySet()) {
                String value = attributes.getValue((Attributes.Name)key);
                props.put(key.toString(), value);
            }
        }
        catch (Throwable t) {
            logger.error("readAttributes(): '{}' failed", (Object)url, (Object)t);
        }
        return props;
    }
}

