/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.binaryallocator.autoreleaser;

import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Releaser
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Releaser.class);
    private Future<?> future;
    protected final String name;
    private final Duration shutdownTimeoutDuration;
    private ExecutorService executor;

    public Releaser(String name, Duration shutdownTimeoutDuration) {
        this.name = name;
        this.shutdownTimeoutDuration = shutdownTimeoutDuration;
    }

    void cancel() {
        this.future.cancel(false);
    }

    @Override
    public abstract void run();

    void setFuture(Future<?> future) {
        this.future = future;
    }

    public String toString() {
        return this.getClass().getName() + " [future=" + this.future + "]";
    }

    public void start() {
        if (null == this.executor) {
            this.executor = IoTDBThreadPoolFactory.newSingleThreadExecutor(this.name);
        }
        Future<?> future = this.executor.submit(this);
        this.setFuture(future);
    }

    public void stop() {
        if (this.executor == null) {
            return;
        }
        LOGGER.info("Stopping {}", (Object)this.name);
        this.cancel();
        this.executor.shutdown();
        try {
            boolean result = this.executor.awaitTermination(this.shutdownTimeoutDuration.toMillis(), TimeUnit.MILLISECONDS);
            if (!result) {
                LOGGER.info("unable to stop auto releaser after {} ms", (Object)this.shutdownTimeoutDuration.toMillis());
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        this.executor = null;
    }
}

