/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.agent.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TPipeHeartbeatResp;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeCriticalException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeSinkCriticalException;
import org.apache.iotdb.commons.pipe.agent.task.PipeTask;
import org.apache.iotdb.commons.pipe.agent.task.PipeTaskManager;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeMetaKeeper;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeRuntimeMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStatus;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTemporaryMetaInAgent;
import org.apache.iotdb.commons.pipe.agent.task.progress.CommitterKey;
import org.apache.iotdb.commons.pipe.agent.task.progress.PipeEventCommitManager;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.sink.limiter.PipeEndPointRateLimiter;
import org.apache.iotdb.commons.subscription.config.SubscriptionConfig;
import org.apache.iotdb.mpp.rpc.thrift.TPipeHeartbeatReq;
import org.apache.iotdb.mpp.rpc.thrift.TPushPipeMetaRespExceptionMessage;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.thrift.TException;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipeTaskAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTaskAgent.class);
    public static final String MESSAGE_PIPE_NOT_ENOUGH_MEMORY = "Not enough memory for pipe.";
    protected static final String MESSAGE_UNKNOWN_PIPE_STATUS = "Unknown pipe status %s for pipe %s";
    protected static final String MESSAGE_UNEXPECTED_PIPE_STATUS = "Unexpected pipe status %s: ";
    protected final PipeMetaKeeper pipeMetaKeeper = new PipeMetaKeeper();
    protected final PipeTaskManager pipeTaskManager = new PipeTaskManager();

    protected PipeTaskAgent() {
        PipeEndPointRateLimiter.setTaskAgent(this);
        PipeEventCommitManager.getInstance().setTaskAgent(this);
    }

    protected void acquireReadLock() {
        this.pipeMetaKeeper.acquireReadLock();
    }

    protected boolean tryReadLockWithTimeOut(long timeOutInSeconds) {
        try {
            return this.pipeMetaKeeper.tryReadLock(timeOutInSeconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("Interruption during requiring pipeMetaKeeper read lock.", (Throwable)e);
            return false;
        }
    }

    protected void releaseReadLock() {
        this.pipeMetaKeeper.releaseReadLock();
    }

    protected void acquireWriteLock() {
        this.pipeMetaKeeper.acquireWriteLock();
    }

    protected boolean tryWriteLockWithTimeOut(long timeOutInSeconds) {
        try {
            return this.pipeMetaKeeper.tryWriteLock(timeOutInSeconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.warn("Interruption during requiring pipeMetaKeeper write lock.", (Throwable)e);
            return false;
        }
    }

    protected void releaseWriteLock() {
        this.pipeMetaKeeper.releaseWriteLock();
    }

    public TPushPipeMetaRespExceptionMessage handleSinglePipeMetaChanges(PipeMeta pipeMetaFromCoordinator) {
        this.acquireWriteLock();
        try {
            TPushPipeMetaRespExceptionMessage tPushPipeMetaRespExceptionMessage = this.handleSinglePipeMetaChangesInternal(pipeMetaFromCoordinator);
            return tPushPipeMetaRespExceptionMessage;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    protected TPushPipeMetaRespExceptionMessage handleSinglePipeMetaChangesInternal(PipeMeta pipeMetaFromCoordinator) {
        if (this.isShutdown()) {
            return null;
        }
        try {
            this.executeSinglePipeMetaChanges(pipeMetaFromCoordinator);
            return null;
        }
        catch (Exception e) {
            String pipeName = pipeMetaFromCoordinator.getStaticMeta().getPipeName();
            String errorMessage = String.format("Failed to handle single pipe meta changes for %s, because %s", pipeName, e.getMessage());
            LOGGER.warn("Failed to handle single pipe meta changes for {}", (Object)pipeName, (Object)e);
            return new TPushPipeMetaRespExceptionMessage(pipeName, errorMessage, System.currentTimeMillis());
        }
    }

    protected abstract boolean isShutdown();

    private void executeSinglePipeMetaChanges(PipeMeta metaFromCoordinator) throws IllegalPathException {
        PipeStaticMeta staticMetaFromCoordinator;
        String pipeName = metaFromCoordinator.getStaticMeta().getPipeName();
        if (PipeStaticMeta.isSubscriptionPipe(pipeName) && !SubscriptionConfig.getInstance().getSubscriptionEnabled()) {
            return;
        }
        PipeMeta metaInAgent = this.pipeMetaKeeper.getPipeMeta(pipeName);
        if (metaInAgent == null) {
            if (this.createPipe(metaFromCoordinator)) {
                this.startPipe(pipeName, metaFromCoordinator.getStaticMeta().getCreationTime());
            }
            return;
        }
        PipeStaticMeta staticMetaInAgent = metaInAgent.getStaticMeta();
        if (!staticMetaInAgent.equals(staticMetaFromCoordinator = metaFromCoordinator.getStaticMeta())) {
            this.dropPipe(pipeName);
            if (this.createPipe(metaFromCoordinator)) {
                this.startPipe(pipeName, metaFromCoordinator.getStaticMeta().getCreationTime());
            }
            return;
        }
        PipeRuntimeMeta runtimeMetaInAgent = metaInAgent.getRuntimeMeta();
        PipeRuntimeMeta runtimeMetaFromCoordinator = metaFromCoordinator.getRuntimeMeta();
        this.executeSinglePipeRuntimeMetaChanges(staticMetaFromCoordinator, runtimeMetaFromCoordinator, runtimeMetaInAgent);
    }

    private void executeSinglePipeRuntimeMetaChanges(PipeStaticMeta pipeStaticMeta, PipeRuntimeMeta runtimeMetaFromCoordinator, PipeRuntimeMeta runtimeMetaInAgent) throws IllegalPathException {
        PipeStatus statusInAgent;
        PipeTaskMeta taskMetaFromCoordinator;
        ConcurrentMap<Integer, PipeTaskMeta> consensusGroupIdToTaskMetaMapFromCoordinator = runtimeMetaFromCoordinator.getConsensusGroupId2TaskMetaMap();
        ConcurrentMap<Integer, PipeTaskMeta> consensusGroupIdToTaskMetaMapInAgent = runtimeMetaInAgent.getConsensusGroupId2TaskMetaMap();
        for (Map.Entry entryFromCoordinator : consensusGroupIdToTaskMetaMapFromCoordinator.entrySet()) {
            int nodeIdInAgent;
            int consensusGroupIdFromCoordinator = (Integer)entryFromCoordinator.getKey();
            taskMetaFromCoordinator = (PipeTaskMeta)entryFromCoordinator.getValue();
            PipeTaskMeta taskMetaInAgent = (PipeTaskMeta)consensusGroupIdToTaskMetaMapInAgent.get(consensusGroupIdFromCoordinator);
            if (taskMetaInAgent == null) {
                this.createPipeTask(consensusGroupIdFromCoordinator, pipeStaticMeta, taskMetaFromCoordinator);
                if (runtimeMetaInAgent.getStatus().get() != PipeStatus.RUNNING) continue;
                this.startPipeTask(consensusGroupIdFromCoordinator, pipeStaticMeta);
                continue;
            }
            int nodeIdFromCoordinator = taskMetaFromCoordinator.getLeaderNodeId();
            if (nodeIdFromCoordinator == (nodeIdInAgent = taskMetaInAgent.getLeaderNodeId())) continue;
            this.dropPipeTask(consensusGroupIdFromCoordinator, pipeStaticMeta);
            this.createPipeTask(consensusGroupIdFromCoordinator, pipeStaticMeta, taskMetaFromCoordinator);
            if (runtimeMetaInAgent.getStatus().get() != PipeStatus.RUNNING) continue;
            this.startPipeTask(consensusGroupIdFromCoordinator, pipeStaticMeta);
        }
        for (Map.Entry entryInAgent : consensusGroupIdToTaskMetaMapInAgent.entrySet()) {
            int consensusGroupIdInAgent = (Integer)entryInAgent.getKey();
            taskMetaFromCoordinator = (PipeTaskMeta)consensusGroupIdToTaskMetaMapFromCoordinator.get(consensusGroupIdInAgent);
            if (taskMetaFromCoordinator != null) continue;
            this.dropPipeTask(consensusGroupIdInAgent, pipeStaticMeta);
        }
        PipeStatus statusFromCoordinator = runtimeMetaFromCoordinator.getStatus().get();
        if (statusFromCoordinator == (statusInAgent = runtimeMetaInAgent.getStatus().get())) {
            return;
        }
        switch (statusFromCoordinator) {
            case RUNNING: {
                if (Objects.requireNonNull(statusInAgent) == PipeStatus.STOPPED) {
                    this.startPipe(pipeStaticMeta.getPipeName(), pipeStaticMeta.getCreationTime());
                    break;
                }
                throw new IllegalStateException(String.format(MESSAGE_UNKNOWN_PIPE_STATUS, new Object[]{statusInAgent, pipeStaticMeta.getPipeName()}));
            }
            case STOPPED: {
                if (Objects.requireNonNull(statusInAgent) == PipeStatus.RUNNING) {
                    this.freezeRate(pipeStaticMeta.getPipeName(), pipeStaticMeta.getCreationTime());
                    this.stopPipe(pipeStaticMeta.getPipeName(), pipeStaticMeta.getCreationTime());
                    break;
                }
                throw new IllegalStateException(String.format(MESSAGE_UNKNOWN_PIPE_STATUS, new Object[]{statusInAgent, pipeStaticMeta.getPipeName()}));
            }
            case DROPPED: {
                this.dropPipe(pipeStaticMeta.getPipeName(), pipeStaticMeta.getCreationTime());
                break;
            }
            default: {
                throw new IllegalStateException(String.format(MESSAGE_UNKNOWN_PIPE_STATUS, new Object[]{statusFromCoordinator, pipeStaticMeta.getPipeName()}));
            }
        }
    }

    protected abstract void thawRate(String var1, long var2);

    protected abstract void freezeRate(String var1, long var2);

    public TPushPipeMetaRespExceptionMessage handleDropPipe(String pipeName) {
        this.acquireWriteLock();
        try {
            TPushPipeMetaRespExceptionMessage tPushPipeMetaRespExceptionMessage = this.handleDropPipeInternal(pipeName);
            return tPushPipeMetaRespExceptionMessage;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    protected TPushPipeMetaRespExceptionMessage handleDropPipeInternal(String pipeName) {
        if (this.isShutdown()) {
            return null;
        }
        try {
            this.dropPipe(pipeName);
            return null;
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to drop pipe %s, because %s", pipeName, e.getMessage());
            LOGGER.warn("Failed to drop pipe {}", (Object)pipeName, (Object)e);
            return new TPushPipeMetaRespExceptionMessage(pipeName, errorMessage, System.currentTimeMillis());
        }
    }

    public List<TPushPipeMetaRespExceptionMessage> handlePipeMetaChanges(List<PipeMeta> pipeMetaListFromCoordinator) {
        if (!this.tryWriteLockWithTimeOut((long)CommonDescriptor.getInstance().getConfig().getDnConnectionTimeoutInMS() * 2L / 3L)) {
            return null;
        }
        try {
            List<TPushPipeMetaRespExceptionMessage> list = this.handlePipeMetaChangesInternal(pipeMetaListFromCoordinator);
            return list;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    protected List<TPushPipeMetaRespExceptionMessage> handlePipeMetaChangesInternal(List<PipeMeta> pipeMetaListFromCoordinator) {
        String errorMessage;
        if (this.isShutdown()) {
            return Collections.emptyList();
        }
        ArrayList<TPushPipeMetaRespExceptionMessage> exceptionMessages = new ArrayList<TPushPipeMetaRespExceptionMessage>();
        LinkedList<PipeMeta> copyPipeMetaListFromCoordinator = new LinkedList<PipeMeta>(pipeMetaListFromCoordinator);
        while (!copyPipeMetaListFromCoordinator.isEmpty()) {
            exceptionMessages.clear();
            Iterator pipeMetas = copyPipeMetaListFromCoordinator.iterator();
            int successfulPipeCount = 0;
            while (pipeMetas.hasNext()) {
                PipeMeta metaFromCoordinator = (PipeMeta)pipeMetas.next();
                try {
                    this.executeSinglePipeMetaChanges(metaFromCoordinator);
                    pipeMetas.remove();
                    ++successfulPipeCount;
                }
                catch (Error | Exception e) {
                    String pipeName = metaFromCoordinator.getStaticMeta().getPipeName();
                    errorMessage = String.format("Failed to handle pipe meta changes for %s, because %s", pipeName, e.getMessage());
                    LOGGER.warn("Failed to handle pipe meta changes for {}", (Object)pipeName, (Object)e);
                    exceptionMessages.add(new TPushPipeMetaRespExceptionMessage(pipeName, errorMessage, System.currentTimeMillis()));
                }
            }
            if (successfulPipeCount != 0) continue;
            break;
        }
        Set pipeNamesFromCoordinator = pipeMetaListFromCoordinator.stream().map(meta -> meta.getStaticMeta().getPipeName()).collect(Collectors.toSet());
        for (PipeMeta metaInAgent : this.pipeMetaKeeper.getPipeMetaList()) {
            String pipeName = metaInAgent.getStaticMeta().getPipeName();
            try {
                if (pipeNamesFromCoordinator.contains(pipeName)) continue;
                this.dropPipe(metaInAgent.getStaticMeta().getPipeName());
            }
            catch (Exception e) {
                errorMessage = String.format("Failed to handle pipe meta changes for %s, because %s", pipeName, e.getMessage());
                LOGGER.warn("Failed to handle pipe meta changes for {}", (Object)pipeName, (Object)e);
                exceptionMessages.add(new TPushPipeMetaRespExceptionMessage(pipeName, errorMessage, System.currentTimeMillis()));
            }
        }
        return exceptionMessages;
    }

    public void dropAllPipeTasks() {
        if (!this.tryWriteLockWithTimeOut(TimeUnit.MILLISECONDS.toSeconds(PipeConfig.getInstance().getPipeMaxWaitFinishTime()))) {
            LOGGER.info("Failed to acquire lock when dropping all pipe tasks, will skip dropping");
            return;
        }
        try {
            this.dropAllPipeTasksInternal();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void dropAllPipeTasksInternal() {
        for (PipeMeta pipeMeta : this.pipeMetaKeeper.getPipeMetaList()) {
            try {
                this.dropPipe(pipeMeta.getStaticMeta().getPipeName(), pipeMeta.getStaticMeta().getCreationTime());
            }
            catch (Exception e) {
                LOGGER.warn("Failed to drop pipe {} with creation time {}", new Object[]{pipeMeta.getStaticMeta().getPipeName(), pipeMeta.getStaticMeta().getCreationTime(), e});
            }
        }
    }

    protected boolean createPipe(PipeMeta pipeMetaFromCoordinator) throws IllegalPathException {
        String pipeName = pipeMetaFromCoordinator.getStaticMeta().getPipeName();
        long creationTime = pipeMetaFromCoordinator.getStaticMeta().getCreationTime();
        this.calculateMemoryUsage(pipeMetaFromCoordinator.getStaticMeta(), pipeMetaFromCoordinator.getStaticMeta().getExtractorParameters(), pipeMetaFromCoordinator.getStaticMeta().getProcessorParameters(), pipeMetaFromCoordinator.getStaticMeta().getConnectorParameters());
        PipeMeta existedPipeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName);
        if (existedPipeMeta != null) {
            if (!this.checkBeforeCreatePipe(existedPipeMeta, pipeName, creationTime)) {
                return false;
            }
            this.dropPipe(pipeName, existedPipeMeta.getStaticMeta().getCreationTime());
        }
        Map<Integer, PipeTask> pipeTasks = this.buildPipeTasks(pipeMetaFromCoordinator);
        long startTime = System.currentTimeMillis();
        this.runPipeTasks(pipeTasks.values(), PipeTask::create);
        LOGGER.info("Create all pipe tasks on Pipe {} successfully within {} ms", (Object)pipeName, (Object)(System.currentTimeMillis() - startTime));
        this.pipeTaskManager.addPipeTasks(pipeMetaFromCoordinator.getStaticMeta(), pipeTasks);
        AtomicReference<PipeStatus> pipeStatusFromCoordinator = pipeMetaFromCoordinator.getRuntimeMeta().getStatus();
        boolean needToStartPipe = pipeStatusFromCoordinator.get() == PipeStatus.RUNNING;
        pipeStatusFromCoordinator.set(PipeStatus.STOPPED);
        this.pipeMetaKeeper.addPipeMeta(pipeMetaFromCoordinator);
        return needToStartPipe;
    }

    protected void calculateMemoryUsage(PipeStaticMeta staticMeta, PipeParameters extractorParameters, PipeParameters processorParameters, PipeParameters connectorParameters) {
    }

    protected abstract Map<Integer, PipeTask> buildPipeTasks(PipeMeta var1) throws IllegalPathException;

    protected boolean dropPipe(String pipeName, long creationTime) {
        PipeMeta existedPipeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName);
        if (!this.checkBeforeDropPipe(existedPipeMeta, pipeName, creationTime)) {
            return false;
        }
        existedPipeMeta.getRuntimeMeta().getStatus().set(PipeStatus.DROPPED);
        Map<Integer, PipeTask> pipeTasks = this.pipeTaskManager.removePipeTasks(existedPipeMeta.getStaticMeta());
        if (pipeTasks == null) {
            LOGGER.info("Pipe {} (creation time = {}) has already been dropped or has not been created. Skip dropping.", (Object)pipeName, (Object)creationTime);
            return false;
        }
        long startTime = System.currentTimeMillis();
        this.runPipeTasks(pipeTasks.values(), PipeTask::drop);
        LOGGER.info("Drop all pipe tasks on Pipe {} successfully within {} ms", (Object)pipeName, (Object)(System.currentTimeMillis() - startTime));
        this.pipeMetaKeeper.removePipeMeta(pipeName);
        return true;
    }

    protected boolean dropPipe(String pipeName) {
        PipeMeta existedPipeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName);
        if (!this.checkBeforeDropPipe(existedPipeMeta, pipeName)) {
            return false;
        }
        existedPipeMeta.getRuntimeMeta().getStatus().set(PipeStatus.DROPPED);
        Map<Integer, PipeTask> pipeTasks = this.pipeTaskManager.removePipeTasks(existedPipeMeta.getStaticMeta());
        if (pipeTasks == null) {
            LOGGER.info("Pipe {} has already been dropped or has not been created. Skip dropping.", (Object)pipeName);
            return false;
        }
        long startTime = System.currentTimeMillis();
        this.runPipeTasks(pipeTasks.values(), PipeTask::drop);
        LOGGER.info("Drop all pipe tasks on Pipe {} successfully within {} ms", (Object)pipeName, (Object)(System.currentTimeMillis() - startTime));
        this.pipeMetaKeeper.removePipeMeta(pipeName);
        return true;
    }

    protected void startPipe(String pipeName, long creationTime) {
        PipeMeta existedPipeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName);
        if (!this.checkBeforeStartPipe(existedPipeMeta, pipeName, creationTime)) {
            return;
        }
        Map<Integer, PipeTask> pipeTasks = this.pipeTaskManager.getPipeTasks(existedPipeMeta.getStaticMeta());
        if (pipeTasks == null) {
            LOGGER.info("Pipe {} (creation time = {}) has already been dropped or has not been created. Skip starting.", (Object)pipeName, (Object)creationTime);
            return;
        }
        long startTime = System.currentTimeMillis();
        this.runPipeTasks(pipeTasks.values(), PipeTask::start);
        LOGGER.info("Start all pipe tasks on Pipe {} successfully within {} ms", (Object)pipeName, (Object)(System.currentTimeMillis() - startTime));
        existedPipeMeta.getRuntimeMeta().getStatus().set(PipeStatus.RUNNING);
        existedPipeMeta.getRuntimeMeta().getConsensusGroupId2TaskMetaMap().values().forEach(PipeTaskMeta::clearExceptionMessages);
        this.thawRate(pipeName, creationTime);
    }

    private void stopPipe(String pipeName, long creationTime) {
        PipeMeta existedPipeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName);
        if (!this.checkBeforeStopPipe(existedPipeMeta, pipeName, creationTime)) {
            return;
        }
        Map<Integer, PipeTask> pipeTasks = this.pipeTaskManager.getPipeTasks(existedPipeMeta.getStaticMeta());
        if (pipeTasks == null) {
            LOGGER.info("Pipe {} (creation time = {}) has already been dropped or has not been created. Skip stopping.", (Object)pipeName, (Object)creationTime);
            return;
        }
        long startTime = System.currentTimeMillis();
        this.runPipeTasks(pipeTasks.values(), PipeTask::stop);
        LOGGER.info("Stop all pipe tasks on Pipe {} successfully within {} ms", (Object)pipeName, (Object)(System.currentTimeMillis() - startTime));
        existedPipeMeta.getRuntimeMeta().getStatus().set(PipeStatus.STOPPED);
    }

    protected boolean checkBeforeCreatePipe(PipeMeta existedPipeMeta, String pipeName, long creationTime) throws IllegalStateException {
        if (!Objects.equals(TSFileDescriptor.getInstance().getConfig().getEncryptType(), "UNENCRYPTED") && !Objects.equals(TSFileDescriptor.getInstance().getConfig().getEncryptType(), "org.apache.tsfile.encrypt.UNENCRYPTED")) {
            throw new PipeException(String.format("Failed to create Pipe %s because TSFile is configured with encryption, which prohibits the use of Pipe", pipeName));
        }
        if (existedPipeMeta.getStaticMeta().getCreationTime() == creationTime) {
            PipeStatus status = existedPipeMeta.getRuntimeMeta().getStatus().get();
            switch (status) {
                case RUNNING: 
                case STOPPED: {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Pipe {} (creation time = {}) has already been created. Current status = {}. Skip creating.", new Object[]{pipeName, creationTime, status.name()});
                    }
                    return false;
                }
                case DROPPED: {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Pipe {} (creation time = {}) has already been dropped, but the pipe task meta has not been cleaned up. Current status = {}. Try dropping the pipe and recreating it.", new Object[]{pipeName, creationTime, status.name()});
                    }
                    return true;
                }
            }
            throw new IllegalStateException(MESSAGE_UNEXPECTED_PIPE_STATUS + existedPipeMeta.getRuntimeMeta().getStatus().get().name());
        }
        return true;
    }

    protected boolean checkBeforeStartPipe(PipeMeta existedPipeMeta, String pipeName, long creationTime) throws IllegalStateException {
        if (existedPipeMeta == null) {
            LOGGER.info("Pipe {} (creation time = {}) has already been dropped or has not been created. Skip starting.", (Object)pipeName, (Object)creationTime);
            return false;
        }
        if (existedPipeMeta.getStaticMeta().getCreationTime() != creationTime) {
            LOGGER.info("Pipe {} (creation time = {}) has been created but does not match the creation time ({}) in startPipe request. Skip starting.", new Object[]{pipeName, existedPipeMeta.getStaticMeta().getCreationTime(), creationTime});
            return false;
        }
        PipeStatus status = existedPipeMeta.getRuntimeMeta().getStatus().get();
        switch (status) {
            case STOPPED: {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Pipe {} (creation time = {}) has been created. Current status = {}. Starting.", new Object[]{pipeName, creationTime, status.name()});
                }
                return true;
            }
            case RUNNING: {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Pipe {} (creation time = {}) has already been started. Current status = {}. Skip starting.", new Object[]{pipeName, creationTime, status.name()});
                }
                return false;
            }
            case DROPPED: {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Pipe {} (creation time = {}) has already been dropped. Current status = {}. Skip starting.", new Object[]{pipeName, creationTime, status.name()});
                }
                return false;
            }
        }
        throw new IllegalStateException(MESSAGE_UNEXPECTED_PIPE_STATUS + existedPipeMeta.getRuntimeMeta().getStatus().get().name());
    }

    protected boolean checkBeforeStopPipe(PipeMeta existedPipeMeta, String pipeName, long creationTime) throws IllegalStateException {
        if (existedPipeMeta == null) {
            LOGGER.info("Pipe {} (creation time = {}) has already been dropped or has not been created. Skip stopping.", (Object)pipeName, (Object)creationTime);
            return false;
        }
        if (existedPipeMeta.getStaticMeta().getCreationTime() != creationTime) {
            LOGGER.info("Pipe {} (creation time = {}) has been created but does not match the creation time ({}) in stopPipe request. Skip stopping.", new Object[]{pipeName, existedPipeMeta.getStaticMeta().getCreationTime(), creationTime});
            return false;
        }
        PipeStatus status = existedPipeMeta.getRuntimeMeta().getStatus().get();
        switch (status) {
            case STOPPED: {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Pipe {} (creation time = {}) has already been stopped. Current status = {}. Skip stopping.", new Object[]{pipeName, creationTime, status.name()});
                }
                return false;
            }
            case RUNNING: {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Pipe {} (creation time = {}) has been started. Current status = {}. Stopping.", new Object[]{pipeName, creationTime, status.name()});
                }
                return true;
            }
            case DROPPED: {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Pipe {} (creation time = {}) has already been dropped. Current status = {}. Skip stopping.", new Object[]{pipeName, creationTime, status.name()});
                }
                return false;
            }
        }
        throw new IllegalStateException(MESSAGE_UNEXPECTED_PIPE_STATUS + status.name());
    }

    protected boolean checkBeforeDropPipe(PipeMeta existedPipeMeta, String pipeName, long creationTime) {
        if (existedPipeMeta == null) {
            LOGGER.info("Pipe {} (creation time = {}) has already been dropped or has not been created. Skip dropping.", (Object)pipeName, (Object)creationTime);
            return false;
        }
        if (existedPipeMeta.getStaticMeta().getCreationTime() != creationTime) {
            LOGGER.info("Pipe {} (creation time = {}) has been created but does not match the creation time ({}) in dropPipe request. Skip dropping.", new Object[]{pipeName, existedPipeMeta.getStaticMeta().getCreationTime(), creationTime});
            return false;
        }
        return true;
    }

    protected boolean checkBeforeDropPipe(PipeMeta existedPipeMeta, String pipeName) {
        if (existedPipeMeta == null) {
            LOGGER.info("Pipe {} has already been dropped or has not been created. Skip dropping.", (Object)pipeName);
            return false;
        }
        return true;
    }

    protected abstract void createPipeTask(int var1, PipeStaticMeta var2, PipeTaskMeta var3) throws IllegalPathException;

    private void dropPipeTask(int consensusGroupId, PipeStaticMeta pipeStaticMeta) {
        this.pipeMetaKeeper.getPipeMeta(pipeStaticMeta.getPipeName()).getRuntimeMeta().getConsensusGroupId2TaskMetaMap().remove(consensusGroupId);
        PipeTask pipeTask = this.pipeTaskManager.removePipeTask(pipeStaticMeta, consensusGroupId);
        if (pipeTask != null) {
            pipeTask.drop();
        }
    }

    private void startPipeTask(int consensusGroupId, PipeStaticMeta pipeStaticMeta) {
        PipeTask pipeTask = this.pipeTaskManager.getPipeTask(pipeStaticMeta, consensusGroupId);
        if (pipeTask != null) {
            pipeTask.start();
            this.thawRate(pipeStaticMeta.getPipeName(), pipeStaticMeta.getCreationTime());
        }
    }

    protected void stopAllPipesWithCriticalException(int currentNodeId) {
        CompletableFuture.runAsync(() -> {
            try {
                int retryCount = 0;
                while (true) {
                    if (this.tryWriteLockWithTimeOut(5L)) {
                        try {
                            this.stopAllPipesWithCriticalExceptionInternal(currentNodeId);
                            LOGGER.info("Stopped all pipes with critical exception.");
                            return;
                        }
                        finally {
                            this.releaseWriteLock();
                        }
                    }
                    Thread.sleep(1000L);
                    LOGGER.warn("Failed to stop all pipes with critical exception, retry count: {}.", (Object)(++retryCount));
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupted when trying to stop all pipes with critical exception, exception message: {}", (Object)e.getMessage(), (Object)e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.error("Failed to stop all pipes with critical exception, exception message: {}", (Object)e.getMessage(), (Object)e);
            }
        });
    }

    private void stopAllPipesWithCriticalExceptionInternal(int currentNodeId) {
        HashMap reusedConnectorParameters2ExceptionMap = new HashMap();
        this.pipeMetaKeeper.getPipeMetaList().forEach(pipeMeta -> {
            PipeStaticMeta staticMeta = pipeMeta.getStaticMeta();
            PipeRuntimeMeta runtimeMeta = pipeMeta.getRuntimeMeta();
            runtimeMeta.getConsensusGroupId2TaskMetaMap().values().forEach(pipeTaskMeta -> {
                if (pipeTaskMeta.getLeaderNodeId() != currentNodeId) {
                    return;
                }
                for (PipeRuntimeException e : pipeTaskMeta.getExceptionMessages()) {
                    if (!(e instanceof PipeRuntimeSinkCriticalException)) continue;
                    reusedConnectorParameters2ExceptionMap.putIfAbsent(staticMeta.getConnectorParameters(), (PipeRuntimeSinkCriticalException)e);
                }
            });
        });
        this.pipeMetaKeeper.getPipeMetaList().forEach(pipeMeta -> {
            PipeStaticMeta staticMeta = pipeMeta.getStaticMeta();
            PipeRuntimeMeta runtimeMeta = pipeMeta.getRuntimeMeta();
            runtimeMeta.getConsensusGroupId2TaskMetaMap().values().forEach(pipeTaskMeta -> {
                if (pipeTaskMeta.getLeaderNodeId() == currentNodeId && reusedConnectorParameters2ExceptionMap.containsKey(staticMeta.getConnectorParameters()) && !pipeTaskMeta.containsExceptionMessage((PipeRuntimeException)((Object)((Object)((Object)reusedConnectorParameters2ExceptionMap.get(staticMeta.getConnectorParameters())))))) {
                    PipeRuntimeSinkCriticalException exception = (PipeRuntimeSinkCriticalException)((Object)((Object)((Object)reusedConnectorParameters2ExceptionMap.get(staticMeta.getConnectorParameters()))));
                    pipeTaskMeta.trackExceptionMessage(exception);
                    LOGGER.warn("Pipe {} (creation time = {}) will be stopped because of critical exception (occurred time {}) in connector {}.", new Object[]{staticMeta.getPipeName(), staticMeta.getCreationTime(), exception.getTimeStamp(), staticMeta.getConnectorParameters()});
                }
            });
        });
        this.pipeMetaKeeper.getPipeMetaList().forEach(pipeMeta -> {
            PipeStaticMeta staticMeta = pipeMeta.getStaticMeta();
            PipeRuntimeMeta runtimeMeta = pipeMeta.getRuntimeMeta();
            if (runtimeMeta.getStatus().get() == PipeStatus.RUNNING) {
                runtimeMeta.getConsensusGroupId2TaskMetaMap().values().forEach(pipeTaskMeta -> {
                    for (PipeRuntimeException e : pipeTaskMeta.getExceptionMessages()) {
                        if (!(e instanceof PipeRuntimeCriticalException)) continue;
                        this.stopPipe(staticMeta.getPipeName(), staticMeta.getCreationTime());
                        LOGGER.warn("Pipe {} (creation time = {}) was stopped because of critical exception (occurred time {}).", new Object[]{staticMeta.getPipeName(), staticMeta.getCreationTime(), e.getTimeStamp()});
                        return;
                    }
                });
            }
        });
    }

    public void collectPipeMetaList(TPipeHeartbeatReq req, TPipeHeartbeatResp resp) throws TException {
        if (!this.tryReadLockWithTimeOut((long)CommonDescriptor.getInstance().getConfig().getDnConnectionTimeoutInMS() * 2L / 3L)) {
            return;
        }
        try {
            this.collectPipeMetaListInternal(req, resp);
        }
        finally {
            this.releaseReadLock();
        }
    }

    protected abstract void collectPipeMetaListInternal(TPipeHeartbeatReq var1, TPipeHeartbeatResp var2) throws TException;

    public abstract void runPipeTasks(Collection<PipeTask> var1, Consumer<PipeTask> var2);

    public long getPipeCreationTime(String pipeName) {
        PipeMeta pipeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName);
        return pipeMeta == null ? 0L : pipeMeta.getStaticMeta().getCreationTime();
    }

    public String getPipeNameWithCreationTime(String pipeName, long creationTime) {
        PipeMeta pipeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName);
        return pipeMeta == null ? pipeName + "_" + creationTime : ((PipeTemporaryMetaInAgent)pipeMeta.getTemporaryMeta()).getPipeNameWithCreationTime();
    }

    public CommitterKey getCommitterKey(String pipeName, long creationTime, int regionId, int restartTime) {
        PipeMeta pipeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName);
        return pipeMeta == null ? new CommitterKey(pipeName, creationTime, regionId, restartTime) : ((PipeTemporaryMetaInAgent)pipeMeta.getTemporaryMeta()).getCommitterKey(pipeName, creationTime, regionId, restartTime);
    }

    public long getAllFloatingMemoryUsageInByte() {
        AtomicLong bytes = new AtomicLong(0L);
        this.pipeMetaKeeper.getPipeMetaList().forEach(pipeMeta -> bytes.addAndGet(((PipeTemporaryMetaInAgent)pipeMeta.getTemporaryMeta()).getFloatingMemoryUsageInByte()));
        return bytes.get();
    }

    public long getFloatingMemoryUsageInByte(String pipeName) {
        PipeMeta pipeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName);
        return pipeMeta == null ? 0L : ((PipeTemporaryMetaInAgent)pipeMeta.getTemporaryMeta()).getFloatingMemoryUsageInByte();
    }

    public void addFloatingMemoryUsageInByte(String pipeName, long creationTime, long sizeInByte) {
        PipeMeta pipeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName);
        if (Objects.nonNull(pipeMeta) && pipeMeta.getStaticMeta().getCreationTime() == creationTime) {
            ((PipeTemporaryMetaInAgent)pipeMeta.getTemporaryMeta()).addFloatingMemoryUsageInByte(sizeInByte);
        }
    }

    public void decreaseFloatingMemoryUsageInByte(String pipeName, long creationTime, long sizeInByte) {
        PipeMeta pipeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName);
        if (Objects.nonNull(pipeMeta) && pipeMeta.getStaticMeta().getCreationTime() == creationTime) {
            ((PipeTemporaryMetaInAgent)pipeMeta.getTemporaryMeta()).decreaseFloatingMemoryUsageInByte(sizeInByte);
        }
    }

    public int getPipeCount() {
        return this.pipeMetaKeeper.getPipeMetaCount();
    }
}

