/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.datastructure.visibility;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.pipe.datastructure.result.Result;
import org.apache.iotdb.commons.pipe.datastructure.visibility.Visibility;
import org.apache.iotdb.commons.pipe.datastructure.visibility.VisibilityUtils;
import org.apache.iotdb.pipe.api.PipePlugin;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;

public class VisibilityTestUtils {
    public static Result<Void, String> testVisibilityCompatibilityEntry(String prefix) {
        Reflections reflections = new Reflections(prefix, new Scanner[]{new SubTypesScanner(false)});
        Set subTypes = reflections.getSubTypesOf(PipePlugin.class);
        TreeNode root = new TreeNode(PipePlugin.class);
        HashMap<Class, TreeNode> nodeMap = new HashMap<Class, TreeNode>();
        nodeMap.put(PipePlugin.class, root);
        for (Class subType : subTypes) {
            TreeNode node = new TreeNode(subType);
            nodeMap.put(subType, node);
            if (subType.isInterface()) {
                Class<?>[] superInterfaces;
                for (Class<?> superInterface : superInterfaces = subType.getInterfaces()) {
                    while (!nodeMap.containsKey(superInterface) && superInterface != null) {
                        superInterface = VisibilityTestUtils.getSuperInterface(superInterface);
                    }
                    if (superInterface == null) continue;
                    ((TreeNode)nodeMap.get(superInterface)).children.put(subType, node);
                }
                continue;
            }
            Class superClass = subType.getSuperclass();
            if (superClass == Object.class) {
                Class<?>[] interfaces;
                for (Class<?> iface : interfaces = subType.getInterfaces()) {
                    if (!nodeMap.containsKey(iface)) continue;
                    ((TreeNode)nodeMap.get(iface)).children.put(subType, node);
                }
                continue;
            }
            while (!nodeMap.containsKey(superClass) && superClass != null) {
                superClass = superClass.getSuperclass();
            }
            if (superClass == null) continue;
            ((TreeNode)nodeMap.get(superClass)).children.put(subType, node);
        }
        root.visibility = Visibility.BOTH;
        for (TreeNode node : root.children.values()) {
            node.visibility = Visibility.BOTH;
        }
        return VisibilityTestUtils.validateTreeNode(root);
    }

    private static Result<Void, String> validateTreeNode(TreeNode node) {
        for (TreeNode child : node.children.values()) {
            if (!VisibilityUtils.isCompatible(node.visibility, child.visibility)) {
                return Result.err(String.format("Incompatible visibility detected:\nParent class: " + node.clazz.getName() + ", Visibility: " + (Object)((Object)node.visibility) + "\nChild class: " + child.clazz.getName() + ", Visibility: " + (Object)((Object)child.visibility), new Object[0]));
            }
            Result<Void, String> childResult = VisibilityTestUtils.validateTreeNode(child);
            if (!childResult.isErr()) continue;
            return childResult;
        }
        return Result.ok(null);
    }

    private static Class<?> getSuperInterface(Class<?> interfaceClass) {
        Class<?>[] superInterfaces = interfaceClass.getInterfaces();
        return superInterfaces.length > 0 ? superInterfaces[0] : null;
    }

    private static class TreeNode {
        Class<?> clazz;
        Visibility visibility;
        Map<Class<?>, TreeNode> children = new HashMap();

        TreeNode(Class<?> clazz) {
            this.clazz = clazz;
            this.visibility = VisibilityUtils.calculateFromPluginClass(clazz);
        }
    }
}

