/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.sink.client;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ThriftClient;
import org.apache.iotdb.commons.client.property.ThriftClientProperty;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.IoTDBSinkRequestVersion;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.PipeTransferSliceReq;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.rpc.DeepCopyRpcTransportFactory;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.rpc.TimeoutChangeableTransport;
import org.apache.iotdb.service.rpc.thrift.IClientRPCService;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBSyncClient
extends IClientRPCService.Client
implements ThriftClient,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBSyncClient.class);
    private static final AtomicInteger SLICE_ORDER_ID_GENERATOR = new AtomicInteger(0);
    private final String ipAddress;
    private final int port;
    private final TEndPoint endPoint;

    public IoTDBSyncClient(ThriftClientProperty property, String ipAddress, int port, boolean useSSL, String trustStore, String trustStorePwd) throws TTransportException {
        super(property.getProtocolFactory().getProtocol(useSSL ? DeepCopyRpcTransportFactory.INSTANCE.getTransport(ipAddress, port, property.getConnectionTimeoutMs(), trustStore, trustStorePwd) : DeepCopyRpcTransportFactory.INSTANCE.getTransport(ipAddress, port, property.getConnectionTimeoutMs())));
        this.ipAddress = ipAddress;
        this.port = port;
        this.endPoint = new TEndPoint(ipAddress, port);
        TTransport transport = this.getInputProtocol().getTransport();
        if (!transport.isOpen()) {
            transport.open();
        }
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    public TEndPoint getEndPoint() {
        return this.endPoint;
    }

    public void setTimeout(int timeout) {
        ((TimeoutChangeableTransport)this.getInputProtocol().getTransport()).setTimeout(timeout);
    }

    public TPipeTransferResp pipeTransfer(TPipeTransferReq req) throws TException {
        int bodySizeLimit = PipeConfig.getInstance().getPipeConnectorRequestSliceThresholdBytes();
        if (req.getVersion() != IoTDBSinkRequestVersion.VERSION_1.getVersion() || req.body.limit() < bodySizeLimit) {
            return super.pipeTransfer(req);
        }
        LOGGER.warn("The body size of the request is too large. The request will be sliced. Origin req: {}-{}. Request body size: {}, threshold: {}", new Object[]{req.getVersion(), req.getType(), req.body.limit(), bodySizeLimit});
        try {
            int sliceOrderId = SLICE_ORDER_ID_GENERATOR.getAndIncrement();
            int sliceCount = req.body.limit() / bodySizeLimit + (req.body.limit() % bodySizeLimit == 0 ? 0 : 1);
            for (int i = 0; i < sliceCount; ++i) {
                int startIndexInBody = i * bodySizeLimit;
                int endIndexInBody = Math.min((i + 1) * bodySizeLimit, req.body.limit());
                TPipeTransferResp sliceResp = super.pipeTransfer((TPipeTransferReq)PipeTransferSliceReq.toTPipeTransferReq(sliceOrderId, req.getType(), i, sliceCount, req.body.duplicate(), startIndexInBody, endIndexInBody));
                if (i == sliceCount - 1) {
                    return sliceResp;
                }
                if (sliceResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                throw new PipeConnectionException(String.format("Failed to transfer slice. Origin req: %s-%s, slice index: %d, slice count: %d. Reason: %s", req.getVersion(), req.getType(), i, sliceCount, sliceResp.getStatus()));
            }
            return super.pipeTransfer(req);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to transfer slice. Origin req: {}-{}. Retry the whole transfer.", new Object[]{req.getVersion(), req.getType(), e});
            return super.pipeTransfer(req);
        }
    }

    @Override
    public void close() throws Exception {
        this.invalidate();
    }

    @Override
    public void invalidate() {
        if (this.getInputProtocol().getTransport().isOpen()) {
            this.getInputProtocol().getTransport().close();
        }
    }

    @Override
    public void invalidateAll() {
        this.invalidate();
    }

    @Override
    public boolean printLogWhenEncounterException() {
        return true;
    }
}

