/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.filter.impl.singlechild;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.SchemaFilterType;
import org.apache.iotdb.commons.schema.filter.SchemaFilterVisitor;
import org.apache.iotdb.commons.schema.filter.impl.singlechild.AbstractSingleChildFilter;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class AttributeFilter
extends AbstractSingleChildFilter {
    private final String key;

    public AttributeFilter(SchemaFilter child, String key) {
        super(child);
        this.key = key;
    }

    public AttributeFilter(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.key = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public <C> Boolean accept(SchemaFilterVisitor<C> visitor, C node) {
        return visitor.visitAttributeFilter(this, node);
    }

    @Override
    public SchemaFilterType getSchemaFilterType() {
        return SchemaFilterType.ATTRIBUTE;
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        super.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.key, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.key, (OutputStream)stream);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeFilter that = (AttributeFilter)o;
        return super.equals(o) && Objects.equals(this.key, that.key);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key, super.hashCode());
    }
}

