/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.table.column;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class TimeColumnSchema
extends TsTableColumnSchema {
    public TimeColumnSchema(String columnName, TSDataType dataType) {
        super(columnName, dataType);
    }

    public TimeColumnSchema(String columnName, TSDataType dataType, Map<String, String> props) {
        super(columnName, dataType, props);
    }

    @Override
    public TsTableColumnCategory getColumnCategory() {
        return TsTableColumnCategory.TIME;
    }

    static TimeColumnSchema deserialize(InputStream stream) throws IOException {
        String columnName = ReadWriteIOUtils.readString((InputStream)stream);
        TSDataType dataType = ReadWriteIOUtils.readDataType((InputStream)stream);
        Map props = ReadWriteIOUtils.readMap((InputStream)stream);
        return new TimeColumnSchema(columnName, dataType, props);
    }

    static TimeColumnSchema deserialize(ByteBuffer buffer) {
        String columnName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        TSDataType dataType = ReadWriteIOUtils.readDataType((ByteBuffer)buffer);
        Map props = ReadWriteIOUtils.readMap((ByteBuffer)buffer);
        return new TimeColumnSchema(columnName, dataType, props);
    }
}

