/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.utils;

import java.util.Arrays;
import java.util.Objects;

public class BitMap {
    private static final byte[] BIT_UTIL = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};
    private static final byte[] UNMARK_BIT_UTIL = new byte[]{-2, -3, -5, -9, -17, -33, -65, 127};
    private byte[] bits;
    private int size;

    public BitMap(int size) {
        this.size = size;
        this.bits = new byte[BitMap.getSizeOfBytes(size)];
        Arrays.fill(this.bits, (byte)0);
    }

    public BitMap(int size, byte[] bits) {
        this.size = size;
        this.bits = bits;
    }

    public byte[] getByteArray() {
        return this.bits;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isMarked(int position) {
        return (this.bits[position / 8] & BIT_UTIL[position % 8]) != 0;
    }

    public void markAll() {
        Arrays.fill(this.bits, (byte)-1);
    }

    public void mark(int position) {
        int n = position / 8;
        this.bits[n] = (byte)(this.bits[n] | BIT_UTIL[position % 8]);
    }

    public void reset() {
        Arrays.fill(this.bits, (byte)0);
    }

    public void unmark(int position) {
        int n = position / 8;
        this.bits[n] = (byte)(this.bits[n] & UNMARK_BIT_UTIL[position % 8]);
    }

    public boolean isAllUnmarked() {
        int j;
        for (j = 0; j < this.size / 8; ++j) {
            if (this.bits[j] == 0) continue;
            return false;
        }
        for (j = 0; j < this.size % 8; ++j) {
            if ((this.bits[this.size / 8] & BIT_UTIL[j]) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isAllUnmarked(int rangeSize) {
        byte mask;
        for (int j = 0; j < rangeSize / 8; ++j) {
            if (this.bits[j] == 0) continue;
            return false;
        }
        int remainingBits = rangeSize % 8;
        return remainingBits <= 0 || (this.bits[rangeSize / 8] & (mask = (byte)(255 >> 8 - remainingBits))) == 0;
    }

    public boolean isAllMarked() {
        int j;
        for (j = 0; j < this.size / 8; ++j) {
            if (this.bits[j] == -1) continue;
            return false;
        }
        for (j = 0; j < this.size % 8; ++j) {
            if ((this.bits[this.size / 8] & BIT_UTIL[j]) != 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            res.append(this.isMarked(i) ? 1 : 0);
        }
        return res.toString();
    }

    public int hashCode() {
        int result = Objects.hash(this.size);
        result = 31 * result + Arrays.hashCode(this.bits);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BitMap)) {
            return false;
        }
        BitMap other = (BitMap)obj;
        return this.size == other.size && Arrays.equals(this.bits, other.bits);
    }

    public boolean equalsInRange(Object obj, int rangeSize) {
        byte mask;
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BitMap)) {
            return false;
        }
        BitMap other = (BitMap)obj;
        if (rangeSize > this.size || rangeSize > other.size) {
            throw new IllegalArgumentException("range size " + rangeSize + " should <= the minimal bitmap size " + Math.min(this.size, other.size));
        }
        int byteSize = rangeSize / 8;
        for (int i = 0; i < byteSize; ++i) {
            if (this.bits[i] == other.bits[i]) continue;
            return false;
        }
        int remainingBits = rangeSize % 8;
        return remainingBits <= 0 || (this.bits[byteSize] & (mask = (byte)(255 >> 8 - remainingBits))) == (other.bits[byteSize] & mask);
    }

    public BitMap clone() {
        byte[] cloneBytes = new byte[this.bits.length];
        System.arraycopy(this.bits, 0, cloneBytes, 0, this.bits.length);
        return new BitMap(this.size, cloneBytes);
    }

    public static void copyOfRange(BitMap src, int srcPos, BitMap dest, int destPos, int length) {
        if (srcPos + length > src.size) {
            throw new IndexOutOfBoundsException(srcPos + length - 1 + " is out of src range " + src.size);
        }
        if (destPos + length > dest.size) {
            throw new IndexOutOfBoundsException(destPos + length - 1 + " is out of dest range " + dest.size);
        }
        for (int i = 0; i < length; ++i) {
            if (src.isMarked(srcPos + i)) {
                dest.mark(destPos + i);
                continue;
            }
            dest.unmark(destPos + i);
        }
    }

    public BitMap getRegion(int positionOffset, int length) {
        BitMap newBitMap = new BitMap(length);
        BitMap.copyOfRange(this, positionOffset, newBitMap, 0, length);
        return newBitMap;
    }

    public static int getSizeOfBytes(int size) {
        return size / 8 + 1;
    }

    public byte[] getTruncatedByteArray(int size) {
        return Arrays.copyOf(this.bits, BitMap.getSizeOfBytes(size));
    }

    public void append(BitMap another, int position, int length) {
        for (int i = 0; i < length; ++i) {
            if (another.isMarked(i)) {
                this.mark(position + i);
                continue;
            }
            this.unmark(position + i);
        }
    }

    public void extend(int newSize) {
        if (this.size >= newSize) {
            return;
        }
        this.bits = Arrays.copyOf(this.bits, BitMap.getSizeOfBytes(newSize));
        this.size = newSize;
    }
}

