/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.HashMap;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SearchScope
implements Serializable {
    public static final int BASE_INT_VALUE = 0;
    @NotNull
    public static final SearchScope BASE = new SearchScope("BASE", 0);
    public static final int ONE_INT_VALUE = 1;
    @NotNull
    public static final SearchScope ONE = new SearchScope("ONE", 1);
    public static final int SUB_INT_VALUE = 2;
    @NotNull
    public static final SearchScope SUB = new SearchScope("SUB", 2);
    public static final int SUBORDINATE_SUBTREE_INT_VALUE = 3;
    @NotNull
    public static final SearchScope SUBORDINATE_SUBTREE = new SearchScope("SUBORDINATE_SUBTREE", 3);
    @NotNull
    private static final HashMap<Integer, SearchScope> UNDEFINED_SCOPES = new HashMap(StaticUtils.computeMapCapacity(5));
    private static final long serialVersionUID = 5381929718445793181L;
    private final int intValue;
    @NotNull
    private final String name;

    private SearchScope(int intValue) {
        this.intValue = intValue;
        this.name = String.valueOf(intValue);
    }

    private SearchScope(@NotNull String name, int intValue) {
        this.name = name;
        this.intValue = intValue;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public int intValue() {
        return this.intValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static SearchScope valueOf(int intValue) {
        switch (intValue) {
            case 0: {
                return BASE;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return SUB;
            }
            case 3: {
                return SUBORDINATE_SUBTREE;
            }
        }
        HashMap<Integer, SearchScope> hashMap = UNDEFINED_SCOPES;
        synchronized (hashMap) {
            SearchScope s = UNDEFINED_SCOPES.get(intValue);
            if (s == null) {
                s = new SearchScope(intValue);
                UNDEFINED_SCOPES.put(intValue, s);
            }
            return s;
        }
    }

    @Nullable
    public static SearchScope definedValueOf(int intValue) {
        switch (intValue) {
            case 0: {
                return BASE;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return SUB;
            }
            case 3: {
                return SUBORDINATE_SUBTREE;
            }
        }
        return null;
    }

    @NotNull
    public static SearchScope[] values() {
        return new SearchScope[]{BASE, ONE, SUB, SUBORDINATE_SUBTREE};
    }

    public int hashCode() {
        return this.intValue;
    }

    public boolean equals(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof SearchScope) {
            return this.intValue == ((SearchScope)o).intValue;
        }
        return false;
    }

    @NotNull
    public String toString() {
        return this.name;
    }
}

