/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerAware;
import org.apache.camel.util.ObjectHelper;

public final class ExpressionToPredicateAdapter
implements Predicate,
CamelContextAware,
PropertyConfigurerAware {
    private final Expression expression;

    public ExpressionToPredicateAdapter(Expression expression) {
        this.expression = expression;
    }

    public boolean matches(Exchange exchange) {
        if (this.expression instanceof Predicate) {
            return ((Predicate)this.expression).matches(exchange);
        }
        Object value = this.expression.evaluate(exchange, Object.class);
        return ObjectHelper.evaluateValuePredicate((Object)value);
    }

    public String toString() {
        return this.expression.toString();
    }

    public static Predicate toPredicate(Expression expression) {
        if (expression instanceof Predicate) {
            return (Predicate)expression;
        }
        return new ExpressionToPredicateAdapter(expression);
    }

    public void init(CamelContext context) {
        this.expression.init(context);
    }

    public void setCamelContext(CamelContext camelContext) {
        if (this.expression instanceof CamelContextAware) {
            ((CamelContextAware)this.expression).setCamelContext(camelContext);
        }
    }

    public CamelContext getCamelContext() {
        if (this.expression instanceof CamelContextAware) {
            return ((CamelContextAware)this.expression).getCamelContext();
        }
        return null;
    }

    public PropertyConfigurer getPropertyConfigurer(Object instance) {
        if (this.expression instanceof PropertyConfigurer) {
            return (PropertyConfigurer)this.expression;
        }
        if (this.expression instanceof PropertyConfigurerAware) {
            return ((PropertyConfigurerAware)this.expression).getPropertyConfigurer((Object)this.expression);
        }
        return null;
    }
}

