/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.utils;

import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.platform.Constants;
import com.github.sommeri.less4j.utils.RelativeFilenameUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public class URIUtils {
    public static final String URI_FILE_SEPARATOR = "/";

    public static URL toParentURL(URL url) {
        URL parentUrl;
        try {
            URL rootParentUrl = new URL(url, "");
            String query = url.getQuery();
            parentUrl = query == null || query.isEmpty() ? new URL(rootParentUrl.toString()) : new URL(rootParentUrl.toString() + query);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        return parentUrl;
    }

    public static String relativize(File from, File to) {
        URI fromURI = from.toURI();
        URI toURI = to.toURI();
        String relative = URIUtils.getRelativePath(fromURI.toString(), toURI.toString(), URI_FILE_SEPARATOR);
        relative = URIUtils.convertUriToPlatformSeparator(relative);
        return relative;
    }

    public static String relativizeSourceURIs(LessSource from, LessSource to) {
        if (to == null) {
            return null;
        }
        URI toURI = to.getURI();
        if (toURI == null) {
            return to.getName();
        }
        String toURIAsString = toURI.toString();
        if (from == null) {
            return toURIAsString;
        }
        URI fromURI = from.getURI();
        if (fromURI == null) {
            return toURIAsString;
        }
        String fromURIAsString = fromURI.toString();
        return URIUtils.getRelativePath(fromURIAsString, toURIAsString, URI_FILE_SEPARATOR);
    }

    public static String convertUriToPlatformSeparator(String relative) {
        return relative.replace(URI_FILE_SEPARATOR, Constants.FILE_SEPARATOR);
    }

    public static String convertPlatformSeparatorToUri(String relative) {
        return relative.replace(Constants.FILE_SEPARATOR, URI_FILE_SEPARATOR);
    }

    public static String getRelativePath(String basePath, String targetPath, String pathSeparator) {
        int commonIndex;
        String normalizedTargetPath = URIUtils.normalizeNoEndSeparator(targetPath, pathSeparator);
        String normalizedBasePath = URIUtils.normalizeNoEndSeparator(basePath, pathSeparator);
        if (normalizedTargetPath == null) {
            return "";
        }
        if (normalizedBasePath == null) {
            return targetPath;
        }
        String[] base = normalizedBasePath.split(Pattern.quote(pathSeparator));
        String[] target = normalizedTargetPath.split(Pattern.quote(pathSeparator));
        StringBuilder common = new StringBuilder();
        for (commonIndex = 0; commonIndex < target.length && commonIndex < base.length && target[commonIndex].equals(base[commonIndex]); ++commonIndex) {
            common.append(target[commonIndex] + pathSeparator);
        }
        if (commonIndex == 0) {
            return normalizedTargetPath;
        }
        boolean baseIsFile = true;
        File baseResource = new File(normalizedBasePath);
        if (baseResource.exists()) {
            baseIsFile = baseResource.isFile();
        } else if (basePath.endsWith(pathSeparator)) {
            baseIsFile = false;
        }
        StringBuilder relative = new StringBuilder();
        if (base.length != commonIndex) {
            int numDirsUp = baseIsFile ? base.length - commonIndex - 1 : base.length - commonIndex;
            for (int i = 0; i < numDirsUp; ++i) {
                relative.append(".." + pathSeparator);
            }
        }
        relative.append(URIUtils.safeSubstring(normalizedTargetPath, common.length()));
        return relative.toString();
    }

    public static String normalizeNoEndSeparator(String path, String separator) {
        String result = RelativeFilenameUtils.normalizeNoEndSeparator(path);
        if (URI_FILE_SEPARATOR.equals(separator)) {
            result = FilenameUtils.separatorsToUnix((String)result);
        } else if ("\\".equals(separator)) {
            result = FilenameUtils.separatorsToWindows((String)result);
        } else {
            throw new IllegalArgumentException("Unrecognised dir separator '" + separator + "'");
        }
        return result;
    }

    private static String safeSubstring(String string, int beginIndex) {
        if (beginIndex > string.length()) {
            return "";
        }
        return string.substring(beginIndex);
    }

    public static String addPLatformSlashIfNeeded(String directory) {
        if (directory.endsWith(Constants.FILE_SEPARATOR)) {
            return directory;
        }
        return directory + Constants.FILE_SEPARATOR;
    }

    public static URI changeSuffix(URI uri, String dottedSuffix) {
        URI newUri;
        if (uri == null) {
            return null;
        }
        try {
            String uriAsString = uri.toString();
            int lastIndexOfDot = uriAsString.lastIndexOf(46);
            newUri = lastIndexOfDot > -1 ? new URI(uriAsString.substring(0, lastIndexOfDot + 1) + dottedSuffix) : new URI(uriAsString + dottedSuffix);
        }
        catch (URISyntaxException exception) {
            throw new IllegalStateException(exception);
        }
        return newUri;
    }

    public static String changeSuffix(String filename, String dottedSuffix) {
        if (filename == null) {
            return null;
        }
        int lastIndexOf = filename.lastIndexOf(46);
        if (lastIndexOf == -1) {
            return filename + dottedSuffix;
        }
        return filename.substring(0, lastIndexOf) + dottedSuffix;
    }

    public static String addSuffix(String filename, String dottedSuffix) {
        if (filename == null) {
            return null;
        }
        return filename + dottedSuffix;
    }

    public static File changeSuffix(File file, String dottedSuffix) {
        if (file == null) {
            return null;
        }
        String filename = URIUtils.changeSuffix(file.toString(), dottedSuffix);
        return new File(filename);
    }

    public static LessSource.FileSource changeSuffix(LessSource.FileSource source, String dottedSuffix) {
        if (source == null) {
            return null;
        }
        return new LessSource.FileSource(URIUtils.changeSuffix(source.getInputFile(), dottedSuffix));
    }

    public static boolean isQuotedUrl(String url) {
        char last;
        int length = url.length();
        if (length < 2) {
            return false;
        }
        char first = url.charAt(0);
        if (first != (last = url.charAt(length - 1))) {
            return false;
        }
        return first == '\'' || first == '\"';
    }
}

