/*
 * Decompiled with CFR 0.152.
 */
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.RootDoc;
import java.io.IOException;

public class UmlGraph {
    private static Options opt = new Options();

    public static boolean start(RootDoc rootDoc) throws IOException {
        opt.setOptions(rootDoc.options());
        opt.openFile();
        opt.setOptions(rootDoc.classNamed("UMLOptions"));
        UmlGraph.prologue();
        ClassDoc[] classDocArray = rootDoc.classes();
        ClassGraph classGraph = new ClassGraph(rootDoc.specifiedPackages(), UmlGraph.opt.apiDocRoot, UmlGraph.opt.apiDocMapFileName);
        for (int i = 0; i < classDocArray.length; ++i) {
            classGraph.print(opt, classDocArray[i]);
        }
        classGraph.printExtraClasses();
        UmlGraph.epilogue();
        return true;
    }

    public static int optionLength(String string) {
        if (string.equals("-qualify") || string.equals("-horizontal") || string.equals("-attributes") || string.equals("-operations") || string.equals("-constructors") || string.equals("-visibility") || string.equals("-types") || string.equals("-all") || string.equals("-noguillemot")) {
            return 1;
        }
        if (string.equals("-nodefillcolor") || string.equals("-nodefontcolor") || string.equals("-nodefontsize") || string.equals("-nodefontname") || string.equals("-nodefontabstractname") || string.equals("-edgefontcolor") || string.equals("-edgecolor") || string.equals("-edgefontsize") || string.equals("-edgefontname") || string.equals("-output") || string.equals("-outputencoding") || string.equals("-bgcolor") || string.equals("-hide") || string.equals("-apidocroot") || string.equals("-apidocmap")) {
            return 2;
        }
        return 0;
    }

    private static void prologue() {
        UmlGraph.opt.w.println("#!/usr/local/bin/dot\n#\n# Class diagram \n# Generated by $Id: UmlGraph.java 1.42 2004/11/19 15:57:44 dds Exp $\n#\n\ndigraph G {\n\tedge [fontname=\"" + UmlGraph.opt.edgeFontName + "\",fontsize=10,labelfontname=\"" + UmlGraph.opt.edgeFontName + "\",labelfontsize=10];\n" + "\tnode [fontname=\"" + UmlGraph.opt.nodeFontName + "\",fontsize=10,shape=record];");
        if (UmlGraph.opt.horizontal) {
            UmlGraph.opt.w.println("\trankdir=LR;\n\tranksep=1;");
        }
        if (UmlGraph.opt.bgColor != null) {
            UmlGraph.opt.w.println("\tbgcolor=\"" + UmlGraph.opt.bgColor + "\";\n");
        }
    }

    private static void epilogue() {
        UmlGraph.opt.w.println("}\n");
        UmlGraph.opt.w.flush();
    }
}

