/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.filters;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.integration.file.filters.FileListFilter;

public abstract class AbstractMarkerFilePresentFileListFilter<F>
implements FileListFilter<F> {
    private final Map<FileListFilter<F>, Function<String, String>> filtersAndFunctions = new HashMap<FileListFilter<F>, Function<String, String>>();

    public AbstractMarkerFilePresentFileListFilter(FileListFilter<F> filter) {
        this(filter, AbstractMarkerFilePresentFileListFilter.defaultFileNameFunction(".complete"));
    }

    public AbstractMarkerFilePresentFileListFilter(FileListFilter<F> filter, String suffix) {
        this(filter, AbstractMarkerFilePresentFileListFilter.defaultFileNameFunction(suffix));
    }

    public AbstractMarkerFilePresentFileListFilter(FileListFilter<F> filter, Function<String, String> function) {
        this(Collections.singletonMap(filter, function));
    }

    public AbstractMarkerFilePresentFileListFilter(Map<FileListFilter<F>, Function<String, String>> filtersAndFunctions) {
        this.filtersAndFunctions.putAll(filtersAndFunctions);
    }

    public static Function<String, String> defaultFileNameFunction(String suffix) {
        return s -> s + suffix;
    }

    @Override
    public List<F> filterFiles(F[] files) {
        if (files.length < 2) {
            return Collections.emptyList();
        }
        Set candidates = Arrays.stream(files).map(this::getFilename).collect(Collectors.toSet());
        ArrayList<F> results = new ArrayList<F>();
        for (F file : files) {
            boolean anyMatch = this.filtersAndFunctions.entrySet().stream().anyMatch(entry -> {
                Object[] fileToCheck = (Object[])Array.newInstance(file.getClass(), 1);
                fileToCheck[0] = file;
                if (((FileListFilter)entry.getKey()).filterFiles(fileToCheck).size() > 0) {
                    String markerName = (String)((Function)entry.getValue()).apply(this.getFilename(file));
                    return markerName != null && candidates.contains(markerName);
                }
                return false;
            });
            if (!anyMatch) continue;
            results.add(file);
        }
        return results;
    }

    protected abstract String getFilename(F var1);
}

