/*
 * Decompiled with CFR 0.152.
 */
package org.c02e.jpgpj;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bouncycastle.openpgp.PGPException;
import org.c02e.jpgpj.Ring;
import org.c02e.jpgpj.Subkey;
import org.c02e.jpgpj.util.Util;

public class Key
implements Cloneable {
    public static String NO_PASSPHRASE = "JPGPJ_NO_PASSPHRASE";
    protected String signingUid;
    protected List<Subkey> subkeys;

    public Key() {
        this(new ArrayList<Subkey>());
    }

    public Key(List<Subkey> subkeys) {
        this.setSubkeys(subkeys);
    }

    public Key(String armor) throws IOException, PGPException {
        this();
        this.load(armor);
    }

    public Key(String armor, char[] passphraseChars) throws IOException, PGPException {
        this(armor);
        this.setPassphraseChars(passphraseChars);
    }

    public Key(String armor, String passphrase) throws IOException, PGPException {
        this(armor);
        this.setPassphrase(passphrase);
    }

    public Key(File file) throws IOException, PGPException {
        this();
        this.load(file);
    }

    public Key(File file, char[] passphraseChars) throws IOException, PGPException {
        this(file);
        this.setPassphraseChars(passphraseChars);
    }

    public Key(File file, String passphrase) throws IOException, PGPException {
        this(file);
        this.setPassphrase(passphrase);
    }

    public Key(InputStream stream) throws IOException, PGPException {
        this();
        this.load(stream);
    }

    public Key(InputStream stream, char[] passphraseChars) throws IOException, PGPException {
        this(stream);
        this.setPassphraseChars(passphraseChars);
    }

    public Key(InputStream stream, String passphrase) throws IOException, PGPException {
        this(stream);
        this.setPassphrase(passphrase);
    }

    public Key toPublicKey() throws PGPException {
        Key copy = new Key();
        for (Subkey subkey : this.subkeys) {
            Subkey subcopy = new Subkey();
            subcopy.setPublicKey(subkey.getPublicKey());
            copy.subkeys.add(subcopy);
        }
        return copy;
    }

    public String toString() {
        if (Util.isEmpty(this.subkeys)) {
            return "key empty";
        }
        StringBuilder b = new StringBuilder();
        int count = 0;
        for (Subkey subkey : this.subkeys) {
            if (count++ > 0) {
                b.append('\n');
            }
            b.append(subkey.toString());
        }
        return b.toString();
    }

    public Key clone() {
        try {
            Key other = (Key)this.getClass().cast(super.clone());
            List<Subkey> thisSubkeys = this.getSubkeys();
            other.setSubkeys(thisSubkeys == null ? null : thisSubkeys.stream().map(Subkey::clone).collect(Collectors.toList()));
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException("Unexpected clone failure for " + this);
        }
    }

    public void setPassphraseChars(char[] x) {
        for (Subkey subkey : this.subkeys) {
            subkey.setPassphraseChars(x);
        }
    }

    public void setPassphrase(String x) {
        for (Subkey subkey : this.subkeys) {
            subkey.setPassphrase(x);
        }
    }

    public void setNoPassphrase(boolean x) {
        for (Subkey subkey : this.subkeys) {
            subkey.setNoPassphrase(x);
        }
    }

    public List<String> getUids() {
        Subkey master = this.getMaster();
        if (master == null) {
            return Collections.emptyList();
        }
        return master.getUids();
    }

    public String getSigningUid() {
        if (this.signingUid == null) {
            this.signingUid = "";
            List<String> uids = this.getUids();
            if (!uids.isEmpty()) {
                this.signingUid = uids.get(0);
            }
        }
        return this.signingUid;
    }

    public void setSigningUid(String x) {
        this.signingUid = x;
    }

    public boolean isForSigning() {
        return this.getSigning() != null;
    }

    public boolean isForVerification() {
        return this.getVerification() != null;
    }

    public boolean isForEncryption() {
        return this.getEncryption() != null;
    }

    public boolean isForDecryption() {
        return this.getDecryption() != null;
    }

    public Subkey getMaster() {
        return !Util.isEmpty(this.subkeys) ? this.subkeys.get(0) : null;
    }

    public Subkey getSigning() {
        for (int i = this.subkeys.size() - 1; i >= 0; --i) {
            Subkey subkey = this.subkeys.get(i);
            if (!subkey.isForSigning()) continue;
            return subkey;
        }
        return null;
    }

    public Subkey getVerification() {
        for (int i = this.subkeys.size() - 1; i >= 0; --i) {
            Subkey subkey = this.subkeys.get(i);
            if (!subkey.isForVerification()) continue;
            return subkey;
        }
        return null;
    }

    public Subkey getEncryption() {
        for (int i = this.subkeys.size() - 1; i >= 0; --i) {
            Subkey subkey = this.subkeys.get(i);
            if (!subkey.isForEncryption()) continue;
            return subkey;
        }
        return null;
    }

    public Subkey getDecryption() {
        for (int i = this.subkeys.size() - 1; i >= 0; --i) {
            Subkey subkey = this.subkeys.get(i);
            if (!subkey.isForDecryption()) continue;
            return subkey;
        }
        return null;
    }

    public List<Subkey> getSubkeys() {
        return this.subkeys;
    }

    protected void setSubkeys(List<Subkey> x) {
        this.subkeys = x != null ? x : new ArrayList();
    }

    public Subkey findById(Long id) {
        if (id == null) {
            return null;
        }
        for (Subkey subkey : this.subkeys) {
            if (subkey.publicKey == null || subkey.publicKey.getKeyID() != id.longValue()) continue;
            return subkey;
        }
        return null;
    }

    public List<Subkey> findAll(String id) {
        if (Util.isEmpty(id)) {
            return Collections.emptyList();
        }
        Pattern regex = Pattern.compile(id, 18);
        return this.findAll(regex);
    }

    public List<Subkey> findAll(Pattern id) {
        if (id == null) {
            return Collections.emptyList();
        }
        ArrayList<Subkey> result = new ArrayList<Subkey>();
        for (Subkey subkey : this.subkeys) {
            if (!subkey.matches(id)) continue;
            result.add(subkey);
        }
        return result;
    }

    public boolean matches(String id) {
        return !this.findAll(id).isEmpty();
    }

    public boolean matches(Pattern id) {
        return !this.findAll(id).isEmpty();
    }

    public void clearSecrets() {
        for (Subkey subkey : this.subkeys) {
            subkey.clearSecrets();
        }
    }

    public void load(String armor) throws IOException, PGPException {
        List<Key> keys = this.newRing().load(armor);
        if (Util.isEmpty(keys)) {
            throw new PGPException("no keys found");
        }
        this.setSubkeys(keys.get(0).getSubkeys());
    }

    public void load(File file) throws IOException, PGPException {
        List<Key> keys = this.newRing().load(file);
        if (Util.isEmpty(keys)) {
            throw new PGPException("no keys found");
        }
        this.setSubkeys(keys.get(0).getSubkeys());
    }

    public void load(InputStream stream) throws IOException, PGPException {
        List<Key> keys = this.newRing().load(stream);
        if (Util.isEmpty(keys)) {
            throw new PGPException("no keys found");
        }
        this.setSubkeys(keys.get(0).getSubkeys());
    }

    protected Ring newRing() {
        return new Ring();
    }
}

