/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow;

import jakarta.el.ValueExpression;
import jakarta.faces.context.FacesContext;
import jakarta.faces.flow.SwitchCase;
import jakarta.faces.flow.SwitchNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.myfaces.flow.Freezable;

public class SwitchNodeImpl
extends SwitchNode
implements Freezable {
    private String _defaultOutcome;
    private ValueExpression _defaultOutcomeEL;
    private String _id;
    private List<SwitchCase> _cases;
    private List<SwitchCase> _unmodifiableCases;
    private boolean _initialized;

    public SwitchNodeImpl(String switchNodeId) {
        this._id = switchNodeId;
        this._cases = new ArrayList<SwitchCase>();
        this._unmodifiableCases = Collections.unmodifiableList(this._cases);
    }

    @Override
    public List<SwitchCase> getCases() {
        return this._unmodifiableCases;
    }

    public void addCase(SwitchCase switchCase) {
        this.checkInitialized();
        this._cases.add(switchCase);
    }

    @Override
    public String getDefaultOutcome(FacesContext context) {
        if (this._defaultOutcomeEL != null) {
            return (String)this._defaultOutcomeEL.getValue(context.getELContext());
        }
        return this._defaultOutcome;
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public void freeze() {
        this._initialized = true;
        for (SwitchCase switchCase : this._cases) {
            if (!(switchCase instanceof Freezable)) continue;
            ((Freezable)((Object)switchCase)).freeze();
        }
    }

    private void checkInitialized() throws IllegalStateException {
        if (this._initialized) {
            throw new IllegalStateException("Flow is inmutable once initialized");
        }
    }

    public void setDefaultOutcome(String defaultOutcome) {
        this.checkInitialized();
        this._defaultOutcome = defaultOutcome;
        this._defaultOutcomeEL = null;
    }

    public void setDefaultOutcome(ValueExpression defaultOutcome) {
        this.checkInitialized();
        this._defaultOutcomeEL = defaultOutcome;
        this._defaultOutcome = null;
    }

    public void setId(String id) {
        this.checkInitialized();
        this._id = id;
    }
}

