/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.laf.browser;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.image.ImageConstants;
import org.apache.myfaces.trinidadinternal.image.ImageContext;
import org.apache.myfaces.trinidadinternal.image.ImageType;
import org.apache.myfaces.trinidadinternal.image.ImageTypeManager;
import org.apache.myfaces.trinidadinternal.image.PropertyInstantiator;
import org.apache.myfaces.trinidadinternal.image.cache.CacheKeyFactory;
import org.apache.myfaces.trinidadinternal.image.cache.NameProvider;
import org.apache.myfaces.trinidadinternal.image.cache.PropertiesFilter;
import org.apache.myfaces.trinidadinternal.image.painter.ImmInsets;
import org.apache.myfaces.trinidadinternal.style.ParsedPropertyKey;
import org.apache.myfaces.trinidadinternal.style.PropertyParseException;
import org.apache.myfaces.trinidadinternal.style.Style;
import org.apache.myfaces.trinidadinternal.style.StyleMap;

public class BlafImageUtils
implements ImageConstants {
    static final Color __VERY_DARK_COLOR = new Color(0, 51, 102);
    static final Color __DARK_COLOR = new Color(51, 102, 153);
    static final Color __MEDIUM_COLOR = new Color(102, 153, 204);
    static final Color __LIGHT_COLOR = new Color(153, 204, 255);
    static final Color __VERY_DARK_SHADOW_ACCENT_COLOR = new Color(51, 51, 0);
    static final Color __DARK_SHADOW_ACCENT_COLOR = new Color(102, 102, 51);
    static final Color __VERY_DARK_ACCENT_COLOR = new Color(153, 153, 102);
    static final Color __DARK_ACCENT_COLOR = new Color(204, 204, 153);
    static final Color __MEDIUM_ACCENT_COLOR = new Color(255, 255, 204);
    static final Color __LIGHT_ACCENT_COLOR = new Color(247, 247, 231);
    static final Color __TEXT_FOREGROUND_COLOR = new Color(0, 0, 0);
    static final Color __TEXT_BACKGROUND_COLOR = new Color(255, 255, 255);
    private static final String _STYLE_ERROR = "BlafImageUtils: Could not get Style for style class: ";
    private static ImmInsets _sDialogPadding;
    private static final TrinidadLogger _LOG;

    public static void registerImageTypes(ImageTypeManager manager) {
        BlafImageUtils._registerDefaultType(manager, "colorizedIcon", false, false);
        BlafImageUtils._registerDefaultType(manager, "flippedIcon", false, false);
        BlafImageUtils._registerDefaultType(manager, "compositeButton", true, true);
    }

    private static void _registerDefaultType(ImageTypeManager manager, String name, boolean isLocalized, boolean hasPropertiesFilter) {
        BlafImageUtils._registerDefaultType(manager, name, isLocalized, hasPropertiesFilter, false);
    }

    private static void _registerDefaultType(ImageTypeManager manager, String name, boolean isLocalized, boolean hasPropertiesFilter, boolean checkSource) {
        ImageType type = manager.registerImageType("http://myfaces.apache.org/uix/image", name, null);
        char initialCap = Character.toUpperCase(name.charAt(0));
        String baseName = initialCap + name.substring(1);
        String rendererName = "org.apache.myfaces.trinidadinternal.image.laf.browser." + baseName + "ImageRenderer";
        type.setProperty(ImageType.IMAGE_RENDERER_NAME_PROPERTY, rendererName);
        type.setProperty(ImageType.IMAGE_RENDERER_PROPERTY, new PropertyInstantiator(rendererName));
        type.setProperty(ImageType.XML_ENCODER_PROPERTY, new PropertyInstantiator("org.apache.myfaces.trinidadinternal.image.xml.encode." + baseName + "Encoder"));
        type.setProperty(CacheKeyFactory.CACHE_KEY_FACTORY_PROPERTY, new PropertyInstantiator("org.apache.myfaces.trinidadinternal.image.cache." + baseName + "KeyFactory"));
        type.setProperty(NameProvider.NAME_PROVIDER_PROPERTY, new PropertyInstantiator("org.apache.myfaces.trinidadinternal.image.cache." + baseName + "NameProvider"));
        if (hasPropertiesFilter) {
            type.setProperty(PropertiesFilter.PROPERTIES_FILTER_PROPERTY, new PropertyInstantiator("org.apache.myfaces.trinidadinternal.image.cache." + baseName + "PropertiesFilter"));
        }
        type.setProperty(ImageType.LOCALIZED_PROPERTY, isLocalized ? Boolean.TRUE : Boolean.FALSE);
        type.setProperty(ImageType.CHECK_SOURCE_PROPERTY, checkSource ? Boolean.TRUE : Boolean.FALSE);
    }

    static Color __getForeground(ImageContext context, String styleClass) {
        return BlafImageUtils._getColor(context, styleClass, Style.FOREGROUND_KEY, false);
    }

    static Color __getBackground(ImageContext context, String styleClass) {
        return BlafImageUtils._getColor(context, styleClass, Style.BACKGROUND_KEY, false);
    }

    static Color __getNamedForeground(ImageContext context, String styleName) {
        return BlafImageUtils._getColor(context, styleName, Style.FOREGROUND_KEY, true);
    }

    static Color __getNamedBackground(ImageContext context, String styleName) {
        return BlafImageUtils._getColor(context, styleName, Style.BACKGROUND_KEY, true);
    }

    static int __getMnemonicIndex(String text, char accessChar) {
        if (text == null) {
            return -1;
        }
        char flippedChar = Character.isLowerCase(accessChar) ? Character.toUpperCase(accessChar) : Character.toLowerCase(accessChar);
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c != accessChar && c != flippedChar) continue;
            return i;
        }
        return -1;
    }

    static Color __getDarkerColor(Color color) {
        return new Color(BlafImageUtils._getDarkerColorComponent(color.getRed()), BlafImageUtils._getDarkerColorComponent(color.getGreen()), BlafImageUtils._getDarkerColorComponent(color.getBlue()));
    }

    static Color __getLighterColor(Color color) {
        return new Color(BlafImageUtils._getLighterColorComponent(color.getRed()), BlafImageUtils._getLighterColorComponent(color.getGreen()), BlafImageUtils._getLighterColorComponent(color.getBlue()));
    }

    static Color __getDerivedColor(Color color, int offsetRed, int offsetGreen, int offsetBlue) {
        return new Color(BlafImageUtils._getDerivedColorComponent(color.getRed(), offsetRed), BlafImageUtils._getDerivedColorComponent(color.getGreen(), offsetGreen), BlafImageUtils._getDerivedColorComponent(color.getBlue(), offsetBlue));
    }

    static ImmInsets __getDialogPadding() {
        if (_sDialogPadding != null) {
            return _sDialogPadding;
        }
        int width = 40;
        int height = 40;
        BufferedImage image = new BufferedImage(40, 40, 2);
        Graphics g = image.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, width, height);
        g.setColor(Color.black);
        g.setFont(new Font("Dialog", 0, 12));
        FontMetrics metrics = g.getFontMetrics();
        int baseline = metrics.getAscent();
        g.drawString("X", 0, baseline);
        int top = 0;
        for (int y = 0; y < height; ++y) {
            if (BlafImageUtils._isWhiteScanline(image, y, width)) continue;
            top = y;
            break;
        }
        int bottom = metrics.getDescent();
        _sDialogPadding = new ImmInsets(top, 0, bottom, 0);
        g.dispose();
        image.flush();
        return _sDialogPadding;
    }

    private static boolean _isWhiteScanline(BufferedImage image, int y, int width) {
        for (int x = 0; x < width; ++x) {
            if ((image.getRGB(x, y) & 0xFFFFFF) == 0xFFFFFF) continue;
            return false;
        }
        return true;
    }

    private static int _getDarkerColorComponent(int component) {
        int darker = component - 51;
        if (darker < 0) {
            darker = 0;
        }
        return darker;
    }

    private static int _getLighterColorComponent(int component) {
        int lighter = component + 51;
        if (lighter > 255) {
            lighter = 255;
        }
        return lighter;
    }

    private static int _getDerivedColorComponent(int component, int offset) {
        int derivedComponent = component + offset;
        if (derivedComponent > 255) {
            derivedComponent = 255;
        } else if (derivedComponent < 0) {
            derivedComponent = 0;
        }
        return derivedComponent;
    }

    private static Color _getColor(ImageContext context, String styleID, ParsedPropertyKey key, boolean isNamed) {
        StyleMap map = context.getStyleContext().getStyleMap();
        if (map == null) {
            return null;
        }
        Style style = null;
        style = isNamed ? map.getStyleByName(context.getStyleContext(), styleID) : map.getStyleByClass(context.getStyleContext(), styleID);
        if (style == null) {
            if (_LOG.isFine()) {
                _LOG.fine(_STYLE_ERROR + styleID);
            }
            return null;
        }
        try {
            return (Color)style.getParsedProperty(key);
        }
        catch (PropertyParseException e) {
            _LOG.warning((Throwable)e);
            return null;
        }
    }

    static {
        _LOG = TrinidadLogger.createTrinidadLogger(BlafImageUtils.class);
    }
}

