/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.custom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jetspeed.layout.PageLayoutComponent;
import org.apache.jetspeed.om.common.SecurityConstraint;
import org.apache.jetspeed.om.common.SecurityConstraints;
import org.apache.jetspeed.om.page.ContentFragment;
import org.apache.jetspeed.om.page.ContentPage;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.portlets.custom.CustomConfigModePortlet;
import org.apache.jetspeed.request.RequestContext;
import org.apache.portals.bridges.velocity.GenericVelocityPortlet;

public class CustomConfigModePortlet
extends GenericVelocityPortlet {
    private static final PortletMode CONFIG_MODE = new PortletMode("config");
    private static final String DELIMITERS = "[],; \t\r\n";
    private PageManager pageManager;
    private PageLayoutComponent pageLayoutComponent;
    private String configPage;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.configPage = config.getInitParameter("ConfigPage");
        PortletContext context = this.getPortletContext();
        this.pageManager = (PageManager)context.getAttribute("cps:PageManager");
        if (this.pageManager == null) {
            throw new PortletException("Could not get instance of pageManager component");
        }
        this.pageLayoutComponent = (PageLayoutComponent)context.getAttribute("cps:PageLayoutComponent");
        if (this.pageLayoutComponent == null) {
            throw new PortletException("Could not get instance of pageLayoutComponent");
        }
    }

    protected void doDispatch(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (!request.getWindowState().equals((Object)WindowState.MINIMIZED)) {
            PortletMode curMode = request.getPortletMode();
            if (CONFIG_MODE.equals((Object)curMode)) {
                ContentFragment curFragment = (ContentFragment)request.getAttribute("org.apache.jetspeed.Fragment");
                if (curFragment == null) {
                    throw new PortletException("Cannot retrieve current fragment from the request.");
                }
                List securityContraintRefList = null;
                try {
                    securityContraintRefList = this.pageManager.getPageSecurity().getSecurityConstraintsDefs();
                }
                catch (Exception e) {
                    throw new PortletException("Cannot find page security constraint definitions.", (Throwable)e);
                }
                if (securityContraintRefList != null) {
                    request.setAttribute("securityContraintRefList", (Object)securityContraintRefList);
                }
                request.setAttribute("fragmentId", (Object)curFragment.getId());
                request.setAttribute("securityConstraints", (Object)new TransientSecurityConstraints(this, curFragment.getSecurityConstraints()));
                request.setAttribute("EditPage", (Object)this.configPage);
                this.doEdit(request, response);
            } else {
                super.doDispatch(request, response);
            }
        }
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String action = request.getParameter("action");
        if ("addConstraint".equals(action)) {
            this.addSecurityConstraint(request, response);
        } else if ("removeConstraint".equals(action)) {
            this.removeSecurityConstraint(request, response);
        } else if ("updateConstraintRefs".equals(action)) {
            this.updateSecurityConstraintRefs(request, response);
        }
    }

    protected String getTitle(RenderRequest request) {
        String title = null;
        try {
            ContentFragment curFragment = (ContentFragment)request.getAttribute("org.apache.jetspeed.Fragment");
            title = curFragment.getPortletContent().getTitle();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (title != null) {
            return title;
        }
        return super.getTitle(request);
    }

    private void addSecurityConstraint(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        try {
            ArrayList<TransientSecurityConstraint> constraintList;
            Object[] permissionArray;
            RequestContext requestContext = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
            ContentPage page = requestContext.getPage();
            String fragmentId = request.getParameter("fragment");
            ContentFragment fragment = page.getFragmentById(fragmentId);
            if (fragment == null) {
                throw new PortletException("Cannot find fragment: " + fragmentId);
            }
            TransientSecurityConstraints constraints = new TransientSecurityConstraints(this, fragment.getSecurityConstraints());
            TransientSecurityConstraint constraint = new TransientSecurityConstraint(this, fragment.newSecurityConstraint());
            Object[] rolesArray = StringUtils.split((String)request.getParameter("roles"), (String)DELIMITERS);
            Object[] groupsArray = StringUtils.split((String)request.getParameter("groups"), (String)DELIMITERS);
            Object[] usersArray = StringUtils.split((String)request.getParameter("users"), (String)DELIMITERS);
            if (!ArrayUtils.isEmpty((Object[])rolesArray)) {
                constraint.setRoles(Arrays.asList(rolesArray));
            }
            if (!ArrayUtils.isEmpty((Object[])groupsArray)) {
                constraint.setGroups(Arrays.asList(groupsArray));
            }
            if (!ArrayUtils.isEmpty((Object[])usersArray)) {
                constraint.setUsers(Arrays.asList(usersArray));
            }
            if (!ArrayUtils.isEmpty((Object[])(permissionArray = StringUtils.split((String)StringUtils.defaultString((String)request.getParameter("permissions")), (String)DELIMITERS)))) {
                constraint.setPermissions(Arrays.asList(permissionArray));
            }
            if ((constraintList = constraints.getSecurityConstraints()) == null) {
                constraintList = new ArrayList<TransientSecurityConstraint>();
            }
            constraintList.add(constraint);
            constraints.setSecurityConstraints(constraintList);
            this.pageLayoutComponent.updateSecurityConstraints(fragment, (SecurityConstraints)constraints);
        }
        catch (Exception e) {
            throw new PortletException("Failed to add security constraint.", (Throwable)e);
        }
    }

    private void removeSecurityConstraint(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        try {
            RequestContext requestContext = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
            ContentPage page = requestContext.getPage();
            String fragmentId = request.getParameter("fragment");
            ContentFragment fragment = page.getFragmentById(fragmentId);
            if (fragment == null) {
                throw new PortletException("Cannot find fragment: " + fragmentId);
            }
            String roles = request.getParameter("roles");
            String groups = request.getParameter("groups");
            String users = request.getParameter("users");
            String permissions = request.getParameter("permissions");
            TransientSecurityConstraints constraints = new TransientSecurityConstraints(this, fragment.getSecurityConstraints());
            List constraintList = null;
            if (constraints != null && (constraintList = constraints.getSecurityConstraints()) != null) {
                Iterator it = constraintList.iterator();
                while (it.hasNext()) {
                    SecurityConstraint constraint = (SecurityConstraint)it.next();
                    String[] removeRoleArray = StringUtils.split((String)roles, (String)DELIMITERS);
                    String[] removeGroupArray = StringUtils.split((String)groups, (String)DELIMITERS);
                    String[] removeUserArray = StringUtils.split((String)users, (String)DELIMITERS);
                    List roleList = constraint.getRoles();
                    List groupList = constraint.getGroups();
                    List userList = constraint.getUsers();
                    if (!this.hasEqualItems(removeRoleArray, roleList) || !this.hasEqualItems(removeGroupArray, groupList) || !this.hasEqualItems(removeUserArray, userList)) continue;
                    it.remove();
                    break;
                }
            }
            if (constraints != null && constraintList != null) {
                constraints.setSecurityConstraints(constraintList);
            }
            this.pageLayoutComponent.updateSecurityConstraints(fragment, (SecurityConstraints)constraints);
        }
        catch (Exception e) {
            throw new PortletException("Failed to remove security constraint.", (Throwable)e);
        }
    }

    private void updateSecurityConstraintRefs(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        try {
            RequestContext requestContext = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
            ContentPage page = requestContext.getPage();
            String fragmentId = request.getParameter("fragment");
            ContentFragment fragment = page.getFragmentById(fragmentId);
            if (fragment == null) {
                throw new PortletException("Cannot find fragment: " + fragmentId);
            }
            String[] securityConstraintRefs = request.getParameterValues("securityConstraintRef");
            TransientSecurityConstraints constraints = new TransientSecurityConstraints(this, fragment.getSecurityConstraints());
            HashSet<String> constraintRefSet = new HashSet<String>();
            if (securityConstraintRefs != null) {
                for (int i = 0; i < securityConstraintRefs.length; ++i) {
                    if ("".equals(securityConstraintRefs[i])) continue;
                    constraintRefSet.add(securityConstraintRefs[i]);
                }
            }
            constraints.setSecurityConstraintsRefs((List)(constraintRefSet.isEmpty() ? null : new ArrayList(constraintRefSet)));
            this.pageLayoutComponent.updateSecurityConstraints(fragment, (SecurityConstraints)constraints);
        }
        catch (Exception e) {
            throw new PortletException("Failed to remove security constraint.", (Throwable)e);
        }
    }

    private boolean hasEqualItems(String[] array, List<String> list) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            return list == null || list.isEmpty();
        }
        if (list == null) {
            return ArrayUtils.isEmpty((Object[])array);
        }
        if (ArrayUtils.getLength((Object)array) == list.size()) {
            for (String item : array) {
                if (list.contains(item)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

