/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.openid;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.jetspeed.JetspeedActions;
import org.apache.jetspeed.openid.OpenIDRegistrationConfiguration;
import org.apache.jetspeed.request.RequestContext;
import org.apache.portals.bridges.common.GenericServletPortlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenIDLoginPortlet
extends GenericServletPortlet {
    private static final Logger log = LoggerFactory.getLogger(OpenIDLoginPortlet.class);
    public static final String PROVIDER_LABELS_INIT_PARAM_NAME = "providerLabels";
    public static final String PROVIDER_DOMAINS_INIT_PARAM_NAME = "providerDomains";
    public static final String ENABLE_OPEN_ID_ENTRY_INIT_PARAM_NAME = "enableOpenIDEntry";
    public static final String PROVIDER_LABELS_PREF_NAME = "providerLabels";
    public static final String PROVIDER_DOMAINS_PREF_NAME = "providerDomains";
    public static final String ENABLE_OPEN_ID_ENTRY_PREF_NAME = "enableOpenIDEntry";
    public static final String ENABLE_REGISTRATION_CONFIG_PREF_NAME = "enableRegistrationConfig";
    public static final String ENABLE_REGISTRATION_PREF_NAME = "enableRegistration";
    public static final String REGISTRATION_USER_TEMPLATE_PREF_NAME = "newUserTemplateDirectory";
    public static final String REGISTRATION_SUBSITE_ROOT_PREF_NAME = "subsiteRootFolder";
    public static final String REGISTRATION_ROLES_PREF_NAME = "roles";
    public static final String REGISTRATION_GROUPS_PREF_NAME = "groups";
    public static final String REGISTRATION_PROFILER_RULE_NAMES_PREF_NAME = "rulesNames";
    public static final String REGISTRATION_PROFILER_RULE_VALUES_PREF_NAME = "rulesValues";
    public static final String SAVE_ACTION_PARAM_NAME = "save";
    public static final String PROVIDER_BUTTONS_ATTR_NAME = "providerButtons";
    public static final String ENABLE_OPEN_ID_ENTRY_ATTR_NAME = "enableOpenIDEntry";
    private static final List<String> PREF_NAMES = Arrays.asList("providerLabels", "providerDomains", "enableOpenIDEntry", "enableRegistrationConfig", "enableRegistration", "newUserTemplateDirectory", "subsiteRootFolder", "roles", "groups", "rulesNames", "rulesValues");
    private static final List<String> BOOLEAN_PREF_NAMES = Arrays.asList("enableOpenIDEntry", "enableRegistrationConfig", "enableRegistration");
    private static final String OPEN_ID_RELAYING_PARTY_SERVLET_MAPPING = "/openid";
    private List<String> initProviderLabels;
    private List<String> initProviderDomains;
    private boolean initEnableOpenIDEntry;
    private OpenIDRegistrationConfiguration initRegistrationConfiguration;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.initProviderLabels = OpenIDRegistrationConfiguration.parseParameterList((String)config.getInitParameter("providerLabels"));
        this.initProviderDomains = OpenIDRegistrationConfiguration.parseParameterList((String)config.getInitParameter("providerDomains"));
        this.initEnableOpenIDEntry = Boolean.parseBoolean(config.getInitParameter("enableOpenIDEntry"));
        if (Boolean.parseBoolean(config.getInitParameter(ENABLE_REGISTRATION_CONFIG_PREF_NAME))) {
            this.initRegistrationConfiguration = new OpenIDRegistrationConfiguration();
            this.initRegistrationConfiguration.setEnableRegistration(config.getInitParameter(ENABLE_REGISTRATION_PREF_NAME));
            this.initRegistrationConfiguration.setUserTemplateDirectory(config.getInitParameter(REGISTRATION_USER_TEMPLATE_PREF_NAME));
            this.initRegistrationConfiguration.setSubsiteRootFolder(config.getInitParameter(REGISTRATION_SUBSITE_ROOT_PREF_NAME));
            this.initRegistrationConfiguration.setRoles(config.getInitParameter(REGISTRATION_ROLES_PREF_NAME));
            this.initRegistrationConfiguration.setGroups(config.getInitParameter(REGISTRATION_GROUPS_PREF_NAME));
            this.initRegistrationConfiguration.setProfilerRules(config.getInitParameter(REGISTRATION_PROFILER_RULE_NAMES_PREF_NAME), config.getInitParameter(REGISTRATION_PROFILER_RULE_VALUES_PREF_NAME));
        }
    }

    public void destroy() {
        this.initRegistrationConfiguration = null;
        super.destroy();
    }

    protected void doDispatch(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (!request.getWindowState().equals((Object)WindowState.MINIMIZED)) {
            PortletMode curMode = request.getPortletMode();
            if (JetspeedActions.EDIT_DEFAULTS_MODE.equals((Object)curMode)) {
                this.doEdit(request, response);
            } else {
                super.doDispatch(request, response);
            }
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletPreferences prefs = request.getPreferences();
        List providerButtonLabels = OpenIDRegistrationConfiguration.parseParameterList((String)prefs.getValue("providerLabels", null));
        List providerButtonDomains = OpenIDRegistrationConfiguration.parseParameterList((String)prefs.getValue("providerDomains", null));
        if (providerButtonLabels == null || providerButtonLabels.isEmpty() || providerButtonDomains == null || providerButtonDomains.isEmpty()) {
            providerButtonLabels = this.initProviderLabels;
            providerButtonDomains = this.initProviderDomains;
        }
        if (providerButtonLabels != null && !providerButtonLabels.isEmpty() && providerButtonDomains != null && !providerButtonDomains.isEmpty()) {
            LinkedHashMap providerButtons = new LinkedHashMap();
            Iterator labelsIter = providerButtonLabels.iterator();
            Iterator domainsIter = providerButtonDomains.iterator();
            while (labelsIter.hasNext() && domainsIter.hasNext()) {
                providerButtons.put(domainsIter.next(), labelsIter.next());
            }
            request.setAttribute(PROVIDER_BUTTONS_ATTR_NAME, providerButtons);
        }
        boolean enableOpenIDEntry = this.initEnableOpenIDEntry;
        String enableOpenIDEntryPref = prefs.getValue("enableOpenIDEntry", null);
        if (enableOpenIDEntryPref != null) {
            enableOpenIDEntry = Boolean.parseBoolean(enableOpenIDEntryPref);
        }
        request.setAttribute("enableOpenIDEntry", (Object)Boolean.toString(enableOpenIDEntry));
        RequestContext requestContext = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
        String errorCode = (String)requestContext.getSessionAttribute("org.apache.jetspeed.openid.error");
        if (errorCode != null) {
            request.setAttribute("org.apache.jetspeed.openid.error", (Object)errorCode);
        }
        response.setContentType("text/html");
        super.doView(request, response);
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletPreferences prefs = request.getPreferences();
        for (String prefName : PREF_NAMES) {
            String prefValue = prefs.getValue(prefName, null);
            if (prefValue == null) continue;
            request.setAttribute(prefName, (Object)prefValue);
        }
        response.setContentType("text/html");
        super.doEdit(request, response);
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        PortletMode curMode = actionRequest.getPortletMode();
        if (curMode == PortletMode.VIEW) {
            String action = actionRequest.getParameter("org.apache.jetspeed.openid.request");
            if (action != null) {
                RequestContext requestContext = (RequestContext)actionRequest.getAttribute("org.apache.jetspeed.request.RequestContext");
                String servletRedirect = requestContext.getRequest().getContextPath() + OPEN_ID_RELAYING_PARTY_SERVLET_MAPPING + "/" + action + "?" + "org.apache.jetspeed.openid.return" + "=" + requestContext.getPortalURL().getBasePath();
                if (action.equals("login")) {
                    String logConfiguration = "none";
                    PortletPreferences prefs = actionRequest.getPreferences();
                    if (Boolean.parseBoolean(prefs.getValue(ENABLE_REGISTRATION_CONFIG_PREF_NAME, null))) {
                        OpenIDRegistrationConfiguration registrationConfiguration = new OpenIDRegistrationConfiguration();
                        registrationConfiguration.setEnableRegistration(prefs.getValue(ENABLE_REGISTRATION_PREF_NAME, null));
                        registrationConfiguration.setUserTemplateDirectory(prefs.getValue(REGISTRATION_USER_TEMPLATE_PREF_NAME, null));
                        registrationConfiguration.setSubsiteRootFolder(prefs.getValue(REGISTRATION_SUBSITE_ROOT_PREF_NAME, null));
                        registrationConfiguration.setRoles(prefs.getValue(REGISTRATION_ROLES_PREF_NAME, null));
                        registrationConfiguration.setGroups(prefs.getValue(REGISTRATION_GROUPS_PREF_NAME, null));
                        registrationConfiguration.setProfilerRules(prefs.getValue(REGISTRATION_PROFILER_RULE_NAMES_PREF_NAME, null), prefs.getValue(REGISTRATION_PROFILER_RULE_VALUES_PREF_NAME, null));
                        registrationConfiguration.merge(this.initRegistrationConfiguration);
                        requestContext.setSessionAttribute("org.apache.jetspeed.openid.registration.configuration", (Object)registrationConfiguration);
                        logConfiguration = "preferences";
                    } else if (this.initRegistrationConfiguration != null) {
                        requestContext.setSessionAttribute("org.apache.jetspeed.openid.registration.configuration", (Object)this.initRegistrationConfiguration);
                        logConfiguration = "init params";
                    }
                    String discoveryParam = actionRequest.getParameter("org.apache.jetspeed.openid.discovery");
                    servletRedirect = servletRedirect + (discoveryParam != null && discoveryParam.length() > 0 ? "&org.apache.jetspeed.openid.discovery=" + discoveryParam : "");
                    String providerParam = actionRequest.getParameter("org.apache.jetspeed.openid.provider");
                    servletRedirect = servletRedirect + (providerParam != null && providerParam.length() > 0 ? "&org.apache.jetspeed.openid.provider=" + providerParam : "");
                    actionResponse.sendRedirect(servletRedirect);
                    if (log.isDebugEnabled()) {
                        log.debug("OpenID login: discovery: " + discoveryParam + ", provider: " + providerParam + ", configuration: " + logConfiguration);
                    }
                } else if (action.equals("logout")) {
                    actionResponse.sendRedirect(servletRedirect);
                    if (log.isDebugEnabled()) {
                        log.debug("OpenID logout");
                    }
                }
            }
        } else if (curMode.equals((Object)JetspeedActions.EDIT_DEFAULTS_MODE)) {
            if (actionRequest.getParameter(SAVE_ACTION_PARAM_NAME) != null) {
                PortletPreferences prefs = actionRequest.getPreferences();
                boolean storePrefs = false;
                for (String prefName : PREF_NAMES) {
                    String prefValue = actionRequest.getParameter(prefName);
                    if (prefValue != null && prefValue.length() > 0) {
                        if (prefValue.equals(prefs.getValue(prefName, null))) continue;
                        prefs.setValue(prefName, prefValue);
                        storePrefs = true;
                        continue;
                    }
                    if (BOOLEAN_PREF_NAMES.indexOf(prefName) != -1) {
                        String booleanPrefValue = prefs.getValue(prefName, null);
                        if (booleanPrefValue != null && booleanPrefValue.equals("false")) continue;
                        prefs.setValue(prefName, "false");
                        storePrefs = true;
                        continue;
                    }
                    if (prefs.getValue(prefName, null) == null) continue;
                    prefs.setValue(prefName, null);
                    storePrefs = true;
                }
                if (storePrefs) {
                    prefs.store();
                }
                if (log.isDebugEnabled()) {
                    log.debug("OpenID preferences saved: stored: " + storePrefs);
                }
            }
            actionResponse.setPortletMode(PortletMode.VIEW);
        }
    }
}

