/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.prm.portlet;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.portlet.PortletMode;
import org.apache.jetspeed.components.portletregistry.PortletRegistry;
import org.apache.jetspeed.components.portletregistry.RegistryException;
import org.apache.jetspeed.om.portlet.PortletApplication;
import org.apache.jetspeed.om.portlet.PortletDefinition;
import org.apache.jetspeed.om.portlet.Supports;
import org.apache.jetspeed.portlets.JetspeedServiceLocator;
import org.apache.jetspeed.portlets.prm.PortletApplicationNodeBean;
import org.apache.jetspeed.portlets.prm.model.SupportsModel;
import org.apache.jetspeed.portlets.util.PortletApplicationUtils;
import org.apache.jetspeed.portlets.wicket.AbstractAdminWebApplication;
import org.apache.jetspeed.portlets.wicket.component.editor.EditorTemplate;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBoxMultipleChoice;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportsPanel
extends EditorTemplate<Supports> {
    private static final long serialVersionUID = 1L;
    static final Logger logger = LoggerFactory.getLogger(SupportsPanel.class);
    private PortletApplicationNodeBean paNodeBean;
    private String newMimeType;
    private List<String> newPortletModes;
    private List<String> availablePortletModes;

    public SupportsPanel(String id, PortletApplicationNodeBean paNodeBean) {
        super(id);
        this.paNodeBean = paNodeBean;
        this.newPortletModes = new ArrayList();
        this.availablePortletModes = new ArrayList();
        PortletRegistry registry = ((AbstractAdminWebApplication)this.getApplication()).getServiceLocator().getPortletRegistry();
        PortletApplication app = registry.getPortletApplication(paNodeBean.getApplicationName());
        for (PortletMode mode : app.getSupportedPortletModes()) {
            this.availablePortletModes.add(mode.toString());
        }
        this.initLayout();
    }

    protected Button saveButton(String componentId) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public void buildNew(Fragment fragment) {
        fragment.add(new Component[]{new TextField("newMimeType", (IModel)new PropertyModel((Object)this, "newMimeType"))});
        fragment.add(new Component[]{new CheckBoxMultipleChoice("newPortletModes", (IModel)new PropertyModel((Object)this, "newPortletModes"), this.availablePortletModes)});
    }

    public int getColumnCount() {
        return 4;
    }

    public void buildItems(Fragment fragment, Supports field) {
        JetspeedServiceLocator locator = ((AbstractAdminWebApplication)this.getApplication()).getServiceLocator();
        fragment.add(new Component[]{new TextField("mimeType", (IModel)new PropertyModel((Object)new SupportsModel(locator, this.paNodeBean, field), "mimeType"))});
        fragment.add(new Component[]{new CheckBoxMultipleChoice("portletModes", (IModel)new PropertyModel((Object)new SupportsModel(locator, this.paNodeBean, field), "portletModes"), this.availablePortletModes)});
    }

    public void delete(IModel<Supports>[] fieldBeans) {
        PortletRegistry registry = ((AbstractAdminWebApplication)this.getApplication()).getServiceLocator().getPortletRegistry();
        PortletApplication app = registry.getPortletApplication(this.paNodeBean.getApplicationName());
        PortletDefinition def = PortletApplicationUtils.getPortletOrClone((PortletApplication)app, (String)this.paNodeBean.getName());
        Iterator it = def.getSupports().iterator();
        block2: while (it.hasNext()) {
            Supports tempSupports = (Supports)it.next();
            for (IModel<Supports> fieldBean : fieldBeans) {
                if (!tempSupports.getMimeType().equals(((Supports)fieldBean.getObject()).getMimeType())) continue;
                it.remove();
                continue block2;
            }
        }
        FeedbackPanel feed = (FeedbackPanel)this.getPage().get("feedback");
        try {
            registry.savePortletDefinition(def);
            StringResourceModel resModel = new StringResourceModel("pam.details.action.status.portlet.saveOK", (Component)this, null, new Object[]{this.paNodeBean.getName()});
            feed.info(resModel.getString());
        }
        catch (RegistryException e) {
            logger.error("Exception occurred during updating portlet application or saving portlet definition.", (Throwable)e);
            StringResourceModel resModel = new StringResourceModel("pam.details.action.status.portlet.saveFailure", (Component)this, null, new Object[]{this.paNodeBean.getName(), e.getMessage()});
            feed.info(resModel.getString());
        }
    }

    public Iterator<IModel<Supports>> getItemModels() {
        JetspeedServiceLocator locator = ((AbstractAdminWebApplication)this.getApplication()).getServiceLocator();
        PortletApplication app = locator.getPortletRegistry().getPortletApplication(this.paNodeBean.getApplicationName());
        PortletDefinition def = PortletApplicationUtils.getPortletOrClone((PortletApplication)app, (String)this.paNodeBean.getName());
        LinkedList<SupportsModel> list = new LinkedList<SupportsModel>();
        for (Supports field : def.getSupports()) {
            list.add(new SupportsModel(locator, this.paNodeBean, field));
        }
        return list.iterator();
    }

    public IModel<Supports> getNewRowModel(Supports fieldBean) {
        JetspeedServiceLocator locator = ((AbstractAdminWebApplication)this.getApplication()).getServiceLocator();
        return new SupportsModel(locator, this.paNodeBean, fieldBean);
    }

    static /* synthetic */ PortletApplicationNodeBean access$000(SupportsPanel x0) {
        return x0.paNodeBean;
    }

    static /* synthetic */ String access$100(SupportsPanel x0) {
        return x0.newMimeType;
    }

    static /* synthetic */ List access$200(SupportsPanel x0) {
        return x0.newPortletModes;
    }

    static /* synthetic */ String access$102(SupportsPanel x0, String x1) {
        x0.newMimeType = x1;
        return x0.newMimeType;
    }
}

