/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.localeselector;

import java.io.IOException;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.security.SecurityAttributes;
import org.apache.jetspeed.security.SecurityException;
import org.apache.jetspeed.security.User;
import org.apache.jetspeed.security.UserManager;
import org.apache.jetspeed.util.JetspeedLocale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocaleSelectorPortlet
extends GenericPortlet {
    public static final String PREFERED_LOCALE_SESSION_KEY = "prefered_locale";
    static final Logger logger = LoggerFactory.getLogger(LocaleSelectorPortlet.class);
    private UserManager userManager;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.userManager = (UserManager)this.getPortletContext().getAttribute("cps:UserManager");
        if (null == this.userManager) {
            throw new PortletException("Failed to find the User Manager on portlet initialization");
        }
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletContext context = this.getPortletContext();
        Locale locale = request.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        request.setAttribute("currentLocale", (Object)locale.toString());
        PortletRequestDispatcher rd = context.getRequestDispatcher("/WEB-INF/view/locale-list.jsp");
        rd.include(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        PortletSession session = request.getPortletSession();
        String language = request.getParameter(PREFERED_LOCALE_SESSION_KEY);
        if (language != null) {
            String[] localeArray = language.split("[-|_]");
            String country = "";
            String variant = "";
            for (int i = 0; i < localeArray.length; ++i) {
                if (i == 0) {
                    language = localeArray[i];
                    continue;
                }
                if (i == 1) {
                    country = localeArray[i];
                    continue;
                }
                if (i != 2) continue;
                variant = localeArray[i];
            }
            Locale preferedLocale = new Locale(language, country, variant);
            if (request.getRemoteUser() != null) {
                try {
                    User user = this.userManager.getUser(request.getRemoteUser());
                    SecurityAttributes secAttrs = user.getSecurityAttributes();
                    secAttrs.getAttribute("org.apache.jetspeed.prefered.locale", true).setStringValue(JetspeedLocale.convertLocaleToString((Locale)preferedLocale));
                    this.userManager.updateUser(user);
                }
                catch (SecurityException e) {
                    logger.error("Failed to update security attributes with preferred locale.", (Throwable)e);
                }
            }
            session.setAttribute("org.apache.jetspeed.prefered.locale", (Object)preferedLocale, 1);
            RequestContext requestContext = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
            requestContext.setLocale(preferedLocale);
            requestContext.setSessionAttribute("org.apache.jetspeed.prefered.locale", (Object)preferedLocale);
        }
    }
}

