/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.openid;

import java.io.IOException;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.security.auth.Subject;
import org.apache.jetspeed.request.RequestContext;
import org.apache.portals.applications.webcontent2.portlet.IFrameGenericPortlet;

public class OpenIDIFramePortlet
extends IFrameGenericPortlet {
    public static final String SESSION_OPEN_ID_PROVIDER_ATTR_NAME = "sessionOpenIDProvider";
    public static final String REQUIRED_OPEN_ID_PROVIDER_ATTR_NAME = "requiredOpenIDProvider";
    public static final String REQUIRED_OPEN_ID_PROVIDER_LABEL_ATTR_NAME = "requiredOpenIDProviderLabel";
    private static final String REQUIRED_OPEN_ID_PROVIDER_LABEL_PREF_NAME = "REQUIREDOPENIDPROVIDERLABEL";
    private static final String REQUIRED_OPEN_ID_PROVIDER_PREF_NAME = "REQUIREDOPENIDPROVIDER";
    private static final String NOT_AVAILABLE_VIEW_PAGE_INIT_PARAM = "NotAvailableViewPage";
    private String notAvailableViewPage;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.notAvailableViewPage = config.getInitParameter(NOT_AVAILABLE_VIEW_PAGE_INIT_PARAM);
    }

    public void destroy() {
        this.notAvailableViewPage = null;
        super.destroy();
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        RequestContext requestContext = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
        Subject sessionSubject = (Subject)requestContext.getSessionAttribute("org.apache.jetspeed.security.subject");
        String sessionOpenIDProvider = (String)requestContext.getSessionAttribute("org.apache.jetspeed.security.openid.provider");
        PortletPreferences prefs = request.getPreferences();
        String requiredOpenIDProvider = prefs.getValue(REQUIRED_OPEN_ID_PROVIDER_PREF_NAME, null);
        String requiredOpenIDProviderLabel = prefs.getValue(REQUIRED_OPEN_ID_PROVIDER_LABEL_PREF_NAME, null);
        if (sessionSubject == null || requiredOpenIDProvider != null && !requiredOpenIDProvider.equals(sessionOpenIDProvider)) {
            if (this.notAvailableViewPage != null) {
                request.setAttribute("ViewPage", (Object)this.notAvailableViewPage);
                request.setAttribute(SESSION_OPEN_ID_PROVIDER_ATTR_NAME, (Object)sessionOpenIDProvider);
                request.setAttribute(REQUIRED_OPEN_ID_PROVIDER_ATTR_NAME, (Object)requiredOpenIDProvider);
                request.setAttribute(REQUIRED_OPEN_ID_PROVIDER_LABEL_ATTR_NAME, (Object)requiredOpenIDProviderLabel);
                super.doView(request, response);
            }
            return;
        }
        super.doView(request, response);
    }
}

