/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.rpad.simple;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.jetspeed.portlets.rpad.PortletApplication;
import org.apache.jetspeed.portlets.rpad.Repository;
import org.apache.jetspeed.portlets.rpad.simple.SimpleConfigHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class SimpleRepository
implements Repository {
    private static final Logger log = LoggerFactory.getLogger(SimpleRepository.class);
    private String name;
    private String configPath;
    private List<PortletApplication> portletApplications;
    private boolean available;

    public SimpleRepository(String name, String configPath) {
        this.name = name;
        this.configPath = configPath;
        this.available = false;
    }

    public void init() {
        if (log.isDebugEnabled()) {
            log.debug("Loading a repository: " + this.configPath);
        }
        if (this.configPath == null) {
            throw new IllegalStateException("The configuration path is null.");
        }
        try {
            InputSource inputSource = this.getInputSource(this.configPath);
            if (inputSource == null) {
                log.error("Failed to load: " + this.configPath);
                return;
            }
            SAXParserFactory spfactory = SAXParserFactory.newInstance();
            SAXParser parser = spfactory.newSAXParser();
            SimpleConfigHandler repoConfigHandler = new SimpleConfigHandler();
            parser.parse(inputSource, (DefaultHandler)repoConfigHandler);
            this.portletApplications = repoConfigHandler.getPortletApplications();
            if (this.portletApplications == null) {
                if (log.isDebugEnabled()) {
                    log.debug("No portlet application.");
                }
                this.portletApplications = new ArrayList();
            }
            this.available = true;
        }
        catch (Exception e) {
            log.error("Could not load a repository.", (Throwable)e);
            this.portletApplications = new ArrayList();
            this.available = false;
        }
    }

    protected InputSource getInputSource(String path) {
        if (path.startsWith("http:") || path.startsWith("https:")) {
            try {
                URL url = new URL(path);
                return new InputSource(url.openStream());
            }
            catch (MalformedURLException e) {
                log.error("Wrong url: " + path, (Throwable)e);
            }
            catch (IOException e) {
                log.error("Could not load " + path, (Throwable)e);
            }
        } else if (path.startsWith("file:")) {
            try {
                return new InputSource(new FileInputStream(new File(path.substring(5))));
            }
            catch (FileNotFoundException e) {
                log.error("Could not load " + path, (Throwable)e);
            }
        }
        return null;
    }

    public PortletApplication getPortletApplication(String groupId, String artifactId, String version, String packaging) {
        if (groupId != null && artifactId != null && version != null && packaging != null) {
            for (PortletApplication pApps : this.portletApplications) {
                if (!groupId.equals(pApps.getGroupId()) || !artifactId.equals(pApps.getArtifactId()) || !version.equals(pApps.getVersion()) || !packaging.equals(pApps.getPackaging())) continue;
                return pApps;
            }
        }
        return null;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public List<PortletApplication> getPortletApplications() {
        return this.portletApplications;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toXMLString() {
        return "  <repository>\n    <name>" + this.getName() + "</name>\n" + "    <class name=\"" + "org.apache.jetspeed.portlets.rpad.simple.SimpleRepository" + "\"/>\n" + "    <property name=\"configPath\">" + this.getConfigPath() + "</property>\n" + "  </repository>\n";
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }
}

