/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portlets.spaces;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Stack;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.jetspeed.administration.PortalAdministration;
import org.apache.jetspeed.page.PageManager;
import org.apache.jetspeed.page.document.Node;
import org.apache.jetspeed.portlets.spaces.BreadcrumbMenu;
import org.apache.jetspeed.request.RequestContext;
import org.apache.jetspeed.spaces.Spaces;
import org.apache.portals.bridges.common.GenericServletPortlet;

public class BreadcrumbMenu
extends GenericServletPortlet {
    private Spaces spacesService;
    private PortalAdministration admin;
    protected PageManager pageManager;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        PortletContext context = this.getPortletContext();
        this.spacesService = (Spaces)context.getAttribute("cps:SpacesService");
        if (this.spacesService == null) {
            throw new PortletException("Could not get instance of portal spaces service component");
        }
        this.admin = (PortalAdministration)this.getPortletContext().getAttribute("cps:PortalAdministration");
        if (null == this.admin) {
            throw new PortletException("Failed to find the Portal Administration on portlet initialization");
        }
        this.pageManager = (PageManager)context.getAttribute("cps:PageManager");
        if (null == this.pageManager) {
            throw new PortletException("Failed to find the Page Manager on portlet initialization");
        }
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        RequestContext rc = (RequestContext)request.getAttribute("org.apache.jetspeed.request.RequestContext");
        Stack<BreadcrumbMenuItem> stack = new Stack<BreadcrumbMenuItem>();
        for (Node node = rc.getPage().getPageOrTemplate().getParent(); node != null; node = node.getParent()) {
            stack.push(new BreadcrumbMenuItem(this, node.getTitle(), this.admin.getPortalURL((PortletRequest)request, (PortletResponse)response, node.getPath())));
        }
        LinkedList breadcrumbs = new LinkedList();
        while (!stack.empty()) {
            breadcrumbs.add(stack.pop());
        }
        breadcrumbs.add(new BreadcrumbMenuItem(this, rc.getPage().getTitle(), this.admin.getPortalURL((PortletRequest)request, (PortletResponse)response, rc.getPage().getPath())));
        request.setAttribute("breadcrumbs", breadcrumbs);
        try {
            super.doView(request, response);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

