/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mfa.impl;

import org.apache.commons.configuration.Configuration;

public final class TTSConfiguration {
    public final String DIRECTORY = "tts.directory";
    public final String IMAGE_FORMAT = "tts.image.format";
    public final String VOICE_NAME = "tts.voice.name";
    public final String DEBUG = "debug";
    public final String PITCH = "pitch";
    public final String RATE = "rate";
    private String directory = "/tts";
    private String imageFormat = ".wav";
    private String voiceName = "kevin16";
    private boolean debug = false;
    private int pitch = 150;
    private int rate = 110;
    private Configuration config;

    public TTSConfiguration(Configuration c) {
        this.config = c;
        this.setDebug(this.config.getBoolean("debug"));
        this.setDirectory(this.config.getString("tts.directory"));
        this.setVoiceName(this.config.getString("tts.voice.name"));
        this.setImageFormat(this.config.getString("tts.image.format"));
        this.setPitch(this.config.getInt("pitch"));
        this.setRate(this.config.getInt("rate"));
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String ttsDir) {
        this.directory = ttsDir;
    }

    public String getImageFormat() {
        return this.imageFormat;
    }

    public void setImageFormat(String ttsImageFormat) {
        this.imageFormat = ttsImageFormat;
    }

    public int getPitch() {
        return this.pitch;
    }

    public void setPitch(int ttsPitch) {
        this.pitch = ttsPitch;
    }

    public int getRate() {
        return this.rate;
    }

    public void setRate(int ttsRate) {
        this.rate = ttsRate;
    }

    public String getVoiceName() {
        return this.voiceName;
    }

    public void setVoiceName(String ttsVoiceName) {
        this.voiceName = ttsVoiceName;
    }

    public Configuration getConfiguration() {
        return this.config;
    }
}

