/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.security.mfa.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.jetspeed.security.mfa.SecurityQuestionBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuestionFactory {
    static final Logger logger = LoggerFactory.getLogger(QuestionFactory.class);
    private static Random rand;
    private List<String> questions;

    public QuestionFactory(String source) {
        rand = new Random();
        if (source.charAt(source.length() - 1) == '?') {
            source = source.substring(0, source.length() - 1);
        }
        try {
            String[] questionTokens = null;
            questionTokens = source.split("\\?");
            this.questions = new ArrayList();
            for (int i = 0; i < questionTokens.length; ++i) {
                this.questions.add(questionTokens[i].trim() + "?");
            }
        }
        catch (Throwable e) {
            logger.error("Unable to parse random questions: {}", (Object)e.toString());
        }
    }

    public String getRandomQuestion() {
        return (String)this.questions.get(rand.nextInt(this.questions.size()));
    }

    public List<String> getAllQuestions() {
        return this.questions;
    }

    public List<String> getAllQuestionsInRandomOrder() {
        int i;
        ArrayList<String> result = new ArrayList<String>(this.questions.size());
        for (i = 0; i < this.questions.size(); ++i) {
            result.add((String)this.questions.get(i));
        }
        for (i = 0; i < result.size(); ++i) {
            int j = rand.nextInt(result.size());
            String temp = (String)result.get(i);
            result.set(i, (String)result.get(j));
            result.set(j, temp);
        }
        return result;
    }

    public SecurityQuestionBean getSecurityQuestionBean() {
        SecurityQuestionBean result = new SecurityQuestionBean();
        List source = this.getAllQuestionsInRandomOrder();
        result.setQuestion1((String)source.get(1));
        result.setQuestion2((String)source.get(2));
        result.setQuestion3((String)source.get(3));
        return result;
    }
}

