<!DOCTYPE html>
<%--
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
--%>
<html>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <title>Jetspeed 2 - Want to Get Involved? (Basic SSO Example)</title>
    <style type="text/css" media="all">
      @import url("http://portals.apache.org/jetspeed-2/css/maven-base.css");
      @import url("http://portals.apache.org/jetspeed-2/css/maven-theme.css");
      @import url("http://portals.apache.org/jetspeed-2/css/site.css");
    </style>
    <link rel="stylesheet" href="http://portals.apache.org/jetspeed-2/css/print.css" type="text/css" media="print" />
  </head>
  <body class="composite">

      <div id="contentBox">
        <div class="section"><h2><a name="Want_to_Get_Involved"></a>Want to Get Involved? (Basic SSO Example)</h2>
<div class="section"><h3>Hello, <%=session.getAttribute("examples.basicauth.username")%>!</h3>
<p>You have been authorized by Basic authentication through Jetspeed-2 SSO.</p>
</div>
<div class="section"><h3><a name="Why_Should_I_Get_Involved"></a>Why Should I Get Involved?</h3>
<p>
        There are many reasons why you want to get involved, just a few strong points:
        <ul><li>If you help others solve their issues, they will most likely help you when you run into some problems.</li>
<li>By contributing patches, you can influence the prioritization of functionality and get your changes incorporated.</li>
<li>By reporting issues, you help Jetspeed-2 become a stronger project and improve its quality overall.</li>
<li>You will meet and get to know great people as well as share and learn best practices which will help you on
        your project.</li>
</ul>

        We are looking forward to have you part of our community!
        </p>
</div>
<div class="section"><h3><a name="How_do_I_Join_the_Project"></a>How do I Join the Project?</h3>
<p>
        Projects at Apache operate under a <a class="externalLink" href="http://www.apache.org/foundation/how-it-works.html#meritocracy">meritocracy</a>.
        To become a committer, you first need to demonstrate your committment.  The best way to do so is to start contributing patch,
        participate in the community and make your interest known.  It takes time and willingness to help and contribute!  This may
        seem a bit intimidating at first, but the community will always help people who show interest and committment.
        </p>
</div>
<div class="section"><h3><a name="Simple_Things_I_Can_Do_to_Help"></a>Simple Things I Can Do to Help</h3>
<p>
        There are many ways to help with Jetspeed-2 as with most open source projects:
        <ul><li>Subscribe to the <a class="externalLink" href="http://portals.apache.org/jetspeed-2/mail-lists.html">user mailing list</a> and help answer questions from the community.
        In open source a thriving community makes the project successful.  Don't be shy to ask basic questions, we have all
        been there.</li>
<li>Report bugs and issues that you encounter in <a class="externalLink" href="http://issues.apache.org/jira/secure/BrowseProject.jspa?id=10492">Jetspeed-2 bug tracking system</a>.
        Prior to reporting a bug, make sure to discuss the issue on the <a class="externalLink" href="http://portals.apache.org/jetspeed-2/mail-lists.html">user mailing list</a> or even the 
        <a class="externalLink" href="http://portals.apache.org/jetspeed-2/mail-lists.html">developer mailing list</a>.</li>
<li>When you encounter an issue, you may be compelled to fix it.  We encourage this as this makes for a vibrant
        community.  Once you have a fix, <a class="externalLink" href="http://portals.apache.org/jetspeed-2/devguide/patches.html">submit a patch</a> on the reporting issue.</li>
</ul>
</p>
</div>
<div class="section"><h3><a name="Other_Resources_for_Help"></a>Other Resources for Help</h3>
<p>
        Here are some useful links for other resources for help.
        <ul><li><a class="externalLink" href="http://portals.apache.org/development/code-standards.html">Portals project coding standards</a>.</li>
<li><a class="externalLink" href="http://portals.apache.org/development/documentation.html">Portals project documentation standards</a>.</li>
<li><a class="externalLink" href="http://www.apache.org/foundation/how-it-works.html">How does the Apache Software Foundation work</a>?</li>
<li><a class="externalLink" href="http://people.apache.org/~coar/mlists.html#portals.apache.org">Portals mailing lists statistics</a>.  This can be helpful
        to help you decide which mailing list to subscribe to.</li>
</ul>
</p>
</subection></div>

      </div>

  </body>
</html>
