/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.io.IOException;
import java.util.ArrayList;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.TCPNetworkModule;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class SSLNetworkModule
extends TCPNetworkModule {
    private static final String CLASS_NAME = SSLNetworkModule.class.getName();
    private Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    private String[] enabledCiphers;
    private int handshakeTimeoutSecs;
    private HostnameVerifier hostnameVerifier;
    private boolean httpsHostnameVerificationEnabled = false;
    private String host;
    private int port;

    public SSLNetworkModule(SSLSocketFactory factory, String host, int port, String resourceContext) {
        super(factory, host, port, resourceContext);
        this.host = host;
        this.port = port;
        this.log.setResourceName(resourceContext);
    }

    public String[] getEnabledCiphers() {
        return this.enabledCiphers;
    }

    public void setEnabledCiphers(String[] enabledCiphers) {
        String methodName = "setEnabledCiphers";
        if (enabledCiphers != null) {
            this.enabledCiphers = (String[])enabledCiphers.clone();
        }
        if (this.socket != null && this.enabledCiphers != null) {
            if (this.log.isLoggable(5)) {
                String ciphers = "";
                int i = 0;
                while (i < this.enabledCiphers.length) {
                    if (i > 0) {
                        ciphers = String.valueOf(ciphers) + ",";
                    }
                    ciphers = String.valueOf(ciphers) + this.enabledCiphers[i];
                    ++i;
                }
                this.log.fine(CLASS_NAME, "setEnabledCiphers", "260", new Object[]{ciphers});
            }
            ((SSLSocket)this.socket).setEnabledCipherSuites(this.enabledCiphers);
        }
    }

    public void setSSLhandshakeTimeout(int timeout) {
        super.setConnectTimeout(timeout);
        this.handshakeTimeoutSecs = timeout;
    }

    public HostnameVerifier getSSLHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setSSLHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public boolean isHttpsHostnameVerificationEnabled() {
        return this.httpsHostnameVerificationEnabled;
    }

    public void setHttpsHostnameVerificationEnabled(boolean httpsHostnameVerificationEnabled) {
        this.httpsHostnameVerificationEnabled = httpsHostnameVerificationEnabled;
    }

    @Override
    public void start() throws IOException, MqttException {
        SSLSession session;
        super.start();
        this.setEnabledCiphers(this.enabledCiphers);
        int soTimeout = this.socket.getSoTimeout();
        this.socket.setSoTimeout(this.handshakeTimeoutSecs * 1000);
        SSLParameters sslParameters = new SSLParameters();
        ArrayList<SNIServerName> sniHostNames = new ArrayList<SNIServerName>(1);
        sniHostNames.add(new SNIHostName(this.host));
        sslParameters.setServerNames(sniHostNames);
        ((SSLSocket)this.socket).setSSLParameters(sslParameters);
        if (this.httpsHostnameVerificationEnabled) {
            SSLParameters sslParams = new SSLParameters();
            sslParams.setEndpointIdentificationAlgorithm("HTTPS");
            ((SSLSocket)this.socket).setSSLParameters(sslParams);
        }
        ((SSLSocket)this.socket).startHandshake();
        if (this.hostnameVerifier != null && !this.httpsHostnameVerificationEnabled && !this.hostnameVerifier.verify(this.host, session = ((SSLSocket)this.socket).getSession())) {
            session.invalidate();
            this.socket.close();
            throw new SSLPeerUnverifiedException("Host: " + this.host + ", Peer Host: " + session.getPeerHost());
        }
        this.socket.setSoTimeout(soTimeout);
    }

    @Override
    public String getServerURI() {
        return "ssl://" + this.host + ":" + this.port;
    }
}

