/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.definition.path;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import org.apache.servicecomb.common.rest.codec.RestObjectMapperFactory;
import org.apache.servicecomb.common.rest.codec.param.QueryProcessorCreator;
import org.apache.servicecomb.common.rest.definition.RestParam;
import org.apache.servicecomb.common.rest.definition.path.AbstractUrlParamWriter;
import org.apache.servicecomb.common.rest.definition.path.URLPathBuilder;
import org.apache.servicecomb.swagger.converter.property.SwaggerParamCollectionFormat;

public class QueryVarParamWriter
extends AbstractUrlParamWriter {
    private SwaggerParamCollectionFormat collectionFormat;

    public QueryVarParamWriter(RestParam param) {
        this.param = param;
        this.collectionFormat = ((QueryProcessorCreator.QueryProcessor)param.getParamProcessor()).getCollectionFormat();
    }

    @Override
    public void write(URLPathBuilder.URLPathStringBuilder builder, Object[] args) throws Exception {
        Object value = this.getParamValue(args);
        if (value == null) {
            return;
        }
        if (value.getClass().isArray()) {
            this.writeArray(builder, value);
            return;
        }
        if (Collection.class.isInstance(value)) {
            this.writeCollection(builder, value);
            return;
        }
        builder.appendQuery(this.param.getParamName(), this.encodeNotNullValue(value));
    }

    private void writeCollection(URLPathBuilder.URLPathStringBuilder builder, Object value) throws Exception {
        if (this.shouldJoinParams()) {
            this.writeJoinedParams(builder, (Collection)value);
            return;
        }
        for (Object item : (Collection)value) {
            this.writeItem(builder, item);
        }
    }

    private void writeArray(URLPathBuilder.URLPathStringBuilder builder, Object value) throws Exception {
        if (this.shouldJoinParams()) {
            this.writeJoinedParams(builder, Arrays.asList((Object[])value));
            return;
        }
        for (Object item : (Object[])value) {
            this.writeItem(builder, item);
        }
    }

    private void writeJoinedParams(URLPathBuilder.URLPathStringBuilder builder, Collection<?> value) throws Exception {
        String joinedParam = this.collectionFormat.joinParam(value);
        if (null == joinedParam) {
            return;
        }
        builder.appendQuery(this.param.getParamName(), this.encodeNotNullValue(joinedParam));
    }

    private boolean shouldJoinParams() {
        return null != this.collectionFormat && SwaggerParamCollectionFormat.MULTI != this.collectionFormat;
    }

    private void writeItem(URLPathBuilder.URLPathStringBuilder builder, Object item) throws Exception {
        if (null == item) {
            return;
        }
        builder.appendQuery(this.param.getParamName(), this.encodeNotNullValue(item));
    }

    private String encodeNotNullValue(Object value) throws Exception {
        String strValue = RestObjectMapperFactory.getRestObjectMapper().convertToString(value);
        return URLEncoder.encode(strValue, StandardCharsets.UTF_8.name());
    }
}

