/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.bizkeeper.event;

import com.google.common.eventbus.EventBus;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifier;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.servicecomb.bizkeeper.event.CircutBreakerEvent;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.event.AlarmEvent;
import org.apache.servicecomb.foundation.common.event.EventManager;

public class CircutBreakerEventNotifier
extends HystrixEventNotifier {
    private ConcurrentHashMapEx<String, AtomicBoolean> circuitFlag = new ConcurrentHashMapEx();
    EventBus eventBus = EventManager.getEventBus();

    public void markEvent(HystrixEventType eventType, HystrixCommandKey key) {
        String keyName = key.name();
        AtomicBoolean flag = (AtomicBoolean)this.circuitFlag.computeIfAbsent((Object)keyName, k -> new AtomicBoolean());
        switch (eventType) {
            case SHORT_CIRCUITED: {
                if (!flag.compareAndSet(false, true)) break;
                this.eventBus.post((Object)new CircutBreakerEvent(key, AlarmEvent.Type.OPEN));
                break;
            }
            case SUCCESS: {
                if (!flag.compareAndSet(true, false)) break;
                this.eventBus.post((Object)new CircutBreakerEvent(key, AlarmEvent.Type.CLOSE));
                break;
            }
        }
    }
}

