/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.codec.protobuf.internal.converter;

import com.google.common.hash.Hashing;
import io.protostuff.compiler.model.Message;
import io.protostuff.compiler.model.Proto;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.Property;
import io.vertx.core.json.Json;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.codec.protobuf.internal.converter.ProtoMethod;
import org.apache.servicecomb.codec.protobuf.internal.converter.ProtoResponse;
import org.apache.servicecomb.codec.protobuf.internal.converter.SwaggerTypeAdapter;
import org.apache.servicecomb.foundation.common.utils.StringBuilderUtils;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoConst;
import org.apache.servicecomb.foundation.protobuf.internal.parser.ProtoParser;

public class SwaggerToProtoGenerator {
    private final String protoPackage;
    private final Swagger swagger;
    private final StringBuilder msgStringBuilder = new StringBuilder();
    private final StringBuilder serviceBuilder = new StringBuilder();
    private final Set<String> imports = new HashSet<String>();
    private final Set<String> messages = new HashSet<String>();
    private List<Runnable> pending = new ArrayList<Runnable>();

    public SwaggerToProtoGenerator(String protoPackage, Swagger swagger) {
        this.protoPackage = protoPackage;
        this.swagger = swagger;
    }

    public Proto convert() {
        this.convertDefinitions();
        this.convertOperations();
        do {
            List<Runnable> oldPending = this.pending;
            this.pending = new ArrayList<Runnable>();
            for (Runnable runnable : oldPending) {
                runnable.run();
            }
        } while (!this.pending.isEmpty());
        return this.createProto();
    }

    private void convertDefinitions() {
        if (this.swagger.getDefinitions() == null) {
            return;
        }
        for (Map.Entry entry : this.swagger.getDefinitions().entrySet()) {
            this.convertDefinition((String)entry.getKey(), (ModelImpl)entry.getValue());
        }
    }

    private void convertDefinition(String modelName, ModelImpl model) {
        Map<String, Object> properties = model.getProperties();
        if (properties == null) {
            properties = Collections.emptyMap();
        }
        this.createMessage(modelName, properties, new String[0]);
    }

    private void createMessage(String protoName, Map<String, Object> properties, String ... annotations) {
        if (!this.messages.add(protoName)) {
            return;
        }
        for (String annotation : annotations) {
            this.msgStringBuilder.append("//");
            StringBuilderUtils.appendLine((StringBuilder)this.msgStringBuilder, (String)annotation, (Object[])new Object[0]);
        }
        StringBuilderUtils.appendLine((StringBuilder)this.msgStringBuilder, (String)"message %s {", (Object[])new Object[]{protoName});
        int tag = 1;
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            Object property = entry.getValue();
            String propertyType = this.convertSwaggerType(property);
            StringBuilderUtils.appendLine((StringBuilder)this.msgStringBuilder, (String)"  %s %s = %d;", (Object[])new Object[]{propertyType, entry.getKey(), tag});
            ++tag;
        }
        StringBuilderUtils.appendLine((StringBuilder)this.msgStringBuilder, (String)"}", (Object[])new Object[0]);
    }

    private void addImports(Proto proto) {
        this.imports.add(proto.getFilename());
        for (Message message : proto.getMessages()) {
            this.messages.add(message.getCanonicalName());
        }
    }

    private String convertSwaggerType(Object swaggerType) {
        if (swaggerType == null) {
            this.addImports(ProtoConst.EMPTY_PROTO);
            return ProtoConst.EMPTY.getCanonicalName();
        }
        SwaggerTypeAdapter adapter = SwaggerTypeAdapter.create(swaggerType);
        String type = this.tryFindEnumType(adapter.getEnum());
        if (type != null) {
            return type;
        }
        type = this.findBaseType(adapter.getType(), adapter.getFormat());
        if (type != null) {
            return type;
        }
        type = adapter.getRefType();
        if (type != null) {
            return type;
        }
        Property itemProperty = adapter.getArrayItem();
        if (itemProperty != null) {
            return "repeated " + this.convertArrayOrMapItem(itemProperty);
        }
        itemProperty = adapter.getMapItem();
        if (itemProperty != null) {
            return String.format("map<string, %s>", this.convertArrayOrMapItem(itemProperty));
        }
        if (adapter.isJavaLangObject()) {
            this.addImports(ProtoConst.ANY_PROTO);
            return ProtoConst.ANY.getCanonicalName();
        }
        throw new IllegalStateException(String.format("not support swagger type, class=%s, content=%s.", swaggerType.getClass().getName(), Json.encode((Object)swaggerType)));
    }

    private String convertArrayOrMapItem(Property itemProperty) {
        SwaggerTypeAdapter itemAdapter = SwaggerTypeAdapter.create(itemProperty);
        if (itemAdapter.getArrayItem() != null) {
            String protoName = this.generateWrapPropertyName(List.class.getSimpleName(), itemAdapter.getArrayItem());
            this.pending.add(() -> this.wrapPropertyToMessage(protoName, itemProperty));
            return protoName;
        }
        if (itemAdapter.getMapItem() != null) {
            String protoName = this.generateWrapPropertyName(Map.class.getSimpleName(), itemAdapter.getMapItem());
            this.pending.add(() -> this.wrapPropertyToMessage(protoName, itemProperty));
            return protoName;
        }
        return this.convertSwaggerType(itemProperty);
    }

    private String generateWrapPropertyName(String prefix, Property property) {
        SwaggerTypeAdapter adapter = SwaggerTypeAdapter.create(property);
        if (adapter.getArrayItem() != null) {
            return this.generateWrapPropertyName(prefix + List.class.getSimpleName(), adapter.getArrayItem());
        }
        if (adapter.getMapItem() != null) {
            return this.generateWrapPropertyName(prefix + Map.class.getSimpleName(), adapter.getMapItem());
        }
        return prefix + StringUtils.capitalize((String)this.convertSwaggerType(adapter));
    }

    private void wrapPropertyToMessage(String protoName, Object property) {
        this.createMessage(protoName, Collections.singletonMap("value", property), ProtoConst.ANNOTATION_WRAP_PROPERTY);
    }

    private String tryFindEnumType(List<String> enums) {
        if (enums != null && !enums.isEmpty()) {
            String strEnums = enums.toString();
            String enumName = "Enum_" + Hashing.sha256().hashString((CharSequence)strEnums, StandardCharsets.UTF_8).toString();
            this.pending.add(() -> this.createEnum(enumName, enums));
            return enumName;
        }
        return null;
    }

    private void createEnum(String enumName, List<String> enums) {
        if (!this.messages.add(enumName)) {
            return;
        }
        StringBuilderUtils.appendLine((StringBuilder)this.msgStringBuilder, (String)"enum %s {", (Object[])new Object[]{enumName});
        for (int idx = 0; idx < enums.size(); ++idx) {
            StringBuilderUtils.appendLine((StringBuilder)this.msgStringBuilder, (String)"  %s =%d;", (Object[])new Object[]{enums.get(idx), idx});
        }
        StringBuilderUtils.appendLine((StringBuilder)this.msgStringBuilder, (String)"}", (Object[])new Object[0]);
    }

    private String findBaseType(String swaggerType, String swaggerFmt) {
        String key;
        switch (key = swaggerType + ":" + swaggerFmt) {
            case "boolean:null": {
                return "bool";
            }
            case "integer:null": {
                return "int64";
            }
            case "integer:int8": 
            case "integer:int16": 
            case "integer:int32": {
                return "int32";
            }
            case "integer:int64": {
                return "int64";
            }
            case "number:null": {
                return "double";
            }
            case "number:float": {
                return "float";
            }
            case "number:double": {
                return "double";
            }
            case "string:null": {
                return "string";
            }
            case "string:byte": {
                return "bytes";
            }
            case "string:date": 
            case "string:date-time": {
                return "int64";
            }
            case "file:null": {
                throw new IllegalStateException("not support swagger type: " + swaggerType);
            }
        }
        return null;
    }

    private void convertOperations() {
        Map paths = this.swagger.getPaths();
        if (paths == null || paths.isEmpty()) {
            return;
        }
        StringBuilderUtils.appendLine((StringBuilder)this.serviceBuilder, (String)"service MainService {", (Object[])new Object[0]);
        for (Path path : paths.values()) {
            for (Operation operation : path.getOperationMap().values()) {
                this.convertOperation(operation);
            }
        }
        this.serviceBuilder.setLength(this.serviceBuilder.length() - 1);
        StringBuilderUtils.appendLine((StringBuilder)this.serviceBuilder, (String)"}", (Object[])new Object[0]);
    }

    private void convertOperation(Operation operation) {
        ProtoMethod protoMethod = new ProtoMethod();
        this.fillRequestType(operation, protoMethod);
        this.fillResponseType(operation, protoMethod);
        StringBuilderUtils.appendLine((StringBuilder)this.serviceBuilder, (String)"  //%s%s", (Object[])new Object[]{ProtoConst.ANNOTATION_RPC, Json.encode((Object)protoMethod)});
        StringBuilderUtils.appendLine((StringBuilder)this.serviceBuilder, (String)"  rpc %s (%s) returns (%s);\n", (Object[])new Object[]{operation.getOperationId(), protoMethod.getArgTypeName(), protoMethod.findResponse(Response.Status.OK.getStatusCode()).getTypeName()});
    }

    private void fillRequestType(Operation operation, ProtoMethod protoMethod) {
        String type;
        List parameters = operation.getParameters();
        if (parameters.isEmpty()) {
            this.addImports(ProtoConst.EMPTY_PROTO);
            protoMethod.setArgTypeName(ProtoConst.EMPTY.getCanonicalName());
            return;
        }
        if (parameters.size() == 1 && this.messages.contains(type = this.convertSwaggerType(parameters.get(0)))) {
            protoMethod.setArgTypeName(type);
            return;
        }
        String wrapName = StringUtils.capitalize((String)operation.getOperationId()) + "RequestWrap";
        this.createWrapArgs(wrapName, parameters);
        protoMethod.setArgTypeName(wrapName);
    }

    private void fillResponseType(Operation operation, ProtoMethod protoMethod) {
        for (Map.Entry entry : operation.getResponses().entrySet()) {
            String type = this.convertSwaggerType(((Response)entry.getValue()).getResponseSchema());
            boolean wrapped = !this.messages.contains(type);
            ProtoResponse protoResponse = new ProtoResponse();
            protoResponse.setTypeName(type);
            if (wrapped) {
                String wrapName = StringUtils.capitalize((String)operation.getOperationId()) + "ResponseWrap" + (String)entry.getKey();
                this.wrapPropertyToMessage(wrapName, ((Response)entry.getValue()).getResponseSchema());
                protoResponse.setTypeName(wrapName);
            }
            protoMethod.addResponse((String)entry.getKey(), protoResponse);
        }
    }

    private void createWrapArgs(String wrapName, List<Parameter> parameters) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (Parameter parameter : parameters) {
            properties.put(parameter.getName(), parameter);
        }
        this.createMessage(wrapName, properties, ProtoConst.ANNOTATION_WRAP_ARGUMENTS);
    }

    protected Proto createProto() {
        StringBuilder sb = new StringBuilder();
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"syntax = \"proto3\";", (Object[])new Object[0]);
        for (String importMsg : this.imports) {
            StringBuilderUtils.appendLine((StringBuilder)sb, (String)"import \"%s\";", (Object[])new Object[]{importMsg});
        }
        if (StringUtils.isNotEmpty((CharSequence)this.protoPackage)) {
            sb.append("package ").append(this.protoPackage).append(";\n");
        }
        sb.append((CharSequence)this.msgStringBuilder);
        sb.append((CharSequence)this.serviceBuilder);
        ProtoParser protoParser = new ProtoParser();
        return protoParser.parseFromContent(sb.toString());
    }
}

