/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.javassist;

import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.scopedpool.ScopedClassPoolFactory;
import javassist.scopedpool.ScopedClassPoolRepositoryImpl;
import org.apache.servicecomb.common.javassist.ClassConfig;
import org.apache.servicecomb.common.javassist.FieldConfig;
import org.apache.servicecomb.common.javassist.MethodConfig;
import org.apache.servicecomb.common.javassist.MultiWrapper;
import org.apache.servicecomb.common.javassist.SingleWrapper;
import org.apache.servicecomb.common.javassist.StdScopedClassPoolFactory;
import org.apache.servicecomb.foundation.common.utils.JvmUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavassistUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavassistUtils.class);

    public static ClassPool getOrCreateClassPool(ClassLoader classLoader) {
        return ScopedClassPoolRepositoryImpl.getInstance().registerClassLoader(classLoader);
    }

    public static void clearByClassLoader(ClassLoader classLoader) {
        ScopedClassPoolRepositoryImpl.getInstance().unregisterClassLoader(classLoader);
    }

    private JavassistUtils() {
    }

    public static Class<? extends Enum> createEnum(String clsName, String ... values) {
        return JavassistUtils.createEnum(null, clsName, Arrays.asList(values));
    }

    public static Class<? extends Enum> createEnum(String clsName, List<String> values) {
        return JavassistUtils.createEnum(null, clsName, values);
    }

    public static Class<? extends Enum> getOrCreateEnumWithPackageName(ClassLoader classLoader, String packageName, List<String> enums) {
        String strEnums = enums.toString();
        String enumClsName = packageName + ".Enum_" + Hashing.sha256().hashString((CharSequence)strEnums, StandardCharsets.UTF_8).toString();
        return JavassistUtils.getOrCreateEnumWithClassName(classLoader, enumClsName, enums);
    }

    public static synchronized Class<? extends Enum> getOrCreateEnumWithClassName(ClassLoader classLoader, String clsName, List<String> values) {
        try {
            return classLoader.loadClass(clsName);
        }
        catch (ClassNotFoundException e) {
            return JavassistUtils.createEnum(classLoader, clsName, values);
        }
    }

    public static Class<? extends Enum> createEnum(ClassLoader classLoader, String clsName, List<String> values) {
        if (values == null || values.isEmpty()) {
            throw new Error("values is not allowed empty.");
        }
        classLoader = JvmUtils.correctClassLoader((ClassLoader)classLoader);
        ClassPool classPool = JavassistUtils.getOrCreateClassPool(classLoader);
        CtClass ctClass = classPool.makeClass(clsName);
        ctClass.setModifiers(ctClass.getModifiers() | 0x4000);
        try {
            ctClass.setSuperclass(classPool.get(Enum.class.getName()));
            JavassistUtils.addEnumConstructor(classPool, ctClass);
            JavassistUtils.addEnumValuesMethod(ctClass, values);
            return ctClass.toClass(classLoader, null);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
    }

    private static void addEnumConstructor(ClassPool classPool, CtClass ctClass) throws Exception {
        String src = "super($1, $2);";
        CtConstructor ctConstructor = new CtConstructor(classPool.get(new String[]{String.class.getName(), Integer.TYPE.getName()}), ctClass);
        ctConstructor.setBody(src);
        ctClass.addConstructor(ctConstructor);
    }

    private static void addEnumValuesMethod(CtClass ctClass, List<String> values) throws CannotCompileException {
        StringBuilder sb = new StringBuilder();
        sb.append("public static Enum[] values(){return new Enum[]{");
        for (int idx = 0; idx < values.size(); ++idx) {
            String value = values.get(idx);
            String line = String.format("new %s(\"%s\", %d),", ctClass.getName(), value, idx);
            sb.append(line);
        }
        sb.setLength(sb.length() - 1);
        sb.append("};}");
        CtMethod valuesMethod = CtMethod.make((String)sb.toString(), (CtClass)ctClass);
        ctClass.addMethod(valuesMethod);
    }

    public static Class<?> createClass(ClassConfig config) {
        return JavassistUtils.createClass(null, config);
    }

    public static CtClass createCtClass(ClassLoader classLoader, ClassConfig config) {
        ClassPool classPool = JavassistUtils.getOrCreateClassPool(classLoader = JvmUtils.correctClassLoader((ClassLoader)classLoader));
        CtClass ctClass = classPool.getOrNull(config.getClassName());
        if (ctClass == null) {
            ctClass = config.isIntf() ? classPool.makeInterface(config.getClassName()) : classPool.makeClass(config.getClassName());
        }
        try {
            for (String intfName : config.getIntfList()) {
                ctClass.addInterface(classPool.get(intfName));
            }
            for (FieldConfig fieldConfig : config.getFieldList()) {
                CtField field = JavassistUtils.createCtField(ctClass, fieldConfig);
                ctClass.addField(field);
                if (fieldConfig.isGenGetter()) {
                    JavassistUtils.addFieldGetter(config, fieldConfig);
                }
                if (!fieldConfig.isGenSetter()) continue;
                JavassistUtils.addFieldSetter(config, fieldConfig);
            }
            for (MethodConfig methodConfig : config.getMethodList()) {
                try {
                    CtMethod ctMethod = CtMethod.make((String)methodConfig.getSource(), (CtClass)ctClass);
                    if (methodConfig.getGenericSignature() != null) {
                        ctMethod.setGenericSignature(methodConfig.getGenericSignature());
                    }
                    ctClass.addMethod(ctMethod);
                }
                catch (CannotCompileException e) {
                    LOGGER.error("Failed to create method, source:\n{}.", (Object)methodConfig.getSource());
                    throw e;
                }
            }
            LOGGER.info("create CtClass {} in classLoader {}.", (Object)config.getClassName(), (Object)classLoader);
            return ctClass;
        }
        catch (Throwable e) {
            throw new IllegalStateException(String.format("Failed to create CtClass %s in classLoader %s.", config.getClassName(), classLoader), e);
        }
    }

    public static Class<?> createClass(ClassLoader classLoader, ClassConfig config) {
        classLoader = JvmUtils.correctClassLoader((ClassLoader)classLoader);
        CtClass ctClass = JavassistUtils.createCtClass(classLoader, config);
        return JavassistUtils.createClass(classLoader, ctClass);
    }

    public static Class<?> createClass(ClassLoader classLoader, CtClass ctClass) {
        classLoader = JvmUtils.correctClassLoader((ClassLoader)classLoader);
        String clsName = ctClass.getName();
        try {
            return classLoader.loadClass(clsName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class cls = ctClass.toClass(classLoader, null);
                LOGGER.info("create class {} in classLoader {}.", (Object)clsName, (Object)classLoader);
                return cls;
            }
            catch (Throwable e) {
                throw new IllegalStateException(String.format("Failed to create %s in classLoader %s.", clsName, classLoader), e);
            }
        }
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }

    private static void addFieldGetter(ClassConfig config, FieldConfig fieldConfig) {
        MethodConfig methodConfig = new MethodConfig();
        String prefix = "get";
        if (Boolean.TYPE.getName().equals(fieldConfig.getType().getCtClass().getName()) || Boolean.class.getName().equals(fieldConfig.getType().getCtClass().getName())) {
            prefix = "is";
        }
        methodConfig.setName(prefix + JavassistUtils.capitalize(fieldConfig.getName()));
        methodConfig.setResult(fieldConfig.getType());
        methodConfig.setBodySource("return " + fieldConfig.getName() + ";");
        config.addMethod(methodConfig);
    }

    private static void addFieldSetter(ClassConfig config, FieldConfig fieldConfig) {
        MethodConfig methodConfig = new MethodConfig();
        methodConfig.setName("set" + JavassistUtils.capitalize(fieldConfig.getName()));
        methodConfig.addParameter(fieldConfig.getName(), fieldConfig.getType());
        methodConfig.setBodySource(" this." + fieldConfig.getName() + " = " + fieldConfig.getName() + ";");
        config.addMethod(methodConfig);
    }

    public static void genMultiWrapperInterface(ClassConfig config) {
        try {
            config.addInterface(MultiWrapper.class);
            config.addMethod(JavassistUtils.genReadFieldsMethodSource(config.getFieldList()));
            config.addMethod(JavassistUtils.genWriteFieldsMethodSource(config.getFieldList()));
        }
        catch (Exception e) {
            String msg = String.format("failed to genMultiWrapperInterface, name=%s", config.getClassName());
            LOGGER.error(msg, (Throwable)e);
            throw new Error(msg, e);
        }
    }

    public static void genSingleWrapperInterface(ClassConfig config) {
        try {
            config.addInterface(SingleWrapper.class);
            config.addMethod(JavassistUtils.genReadFieldMethodSource(config.getFieldList()));
            config.addMethod(JavassistUtils.genWriteFieldMethodSource(config.getFieldList()));
        }
        catch (Exception e) {
            String msg = String.format("failed to genSingleWrapperMethod, name=%s", config.getClassName());
            LOGGER.error(msg, (Throwable)e);
            throw new Error(msg, e);
        }
    }

    private static String genReadFieldsMethodSource(List<FieldConfig> fieldList) {
        StringBuilder sb = new StringBuilder();
        sb.append("public Object[] readFields(){");
        sb.append(String.format("Object values[] = new Object[%d];", fieldList.size()));
        for (int idx = 0; idx < fieldList.size(); ++idx) {
            String fieldName = fieldList.get(idx).getName();
            String code = String.format("    values[%d] = %s;", idx, fieldName);
            sb.append(code);
        }
        sb.append("return values;");
        sb.append("}");
        return sb.toString();
    }

    private static String genWriteFieldsMethodSource(List<FieldConfig> fieldList) {
        StringBuilder sb = new StringBuilder();
        sb.append("public void writeFields(Object[] values){");
        for (int idx = 0; idx < fieldList.size(); ++idx) {
            FieldConfig fieldConfig = fieldList.get(idx);
            String fieldName = fieldConfig.getName();
            String code = String.format("    %s = (%s)values[%d];", fieldName, fieldConfig.getType().getCtClass().getName(), idx);
            sb.append(code);
        }
        sb.append("}");
        return sb.toString();
    }

    private static String genReadFieldMethodSource(List<FieldConfig> fieldList) {
        StringBuilder sb = new StringBuilder();
        sb.append("public Object readField(){");
        String fieldName = "null";
        if (!fieldList.isEmpty()) {
            fieldName = fieldList.get(0).getName();
        }
        sb.append(String.format("    return %s;", fieldName));
        sb.append("}");
        return sb.toString();
    }

    private static String genWriteFieldMethodSource(List<FieldConfig> fieldList) {
        StringBuilder sb = new StringBuilder();
        sb.append("public void writeField(Object value){");
        if (!fieldList.isEmpty()) {
            FieldConfig fieldConfig = fieldList.get(0);
            sb.append(String.format("    %s=(%s)value;", fieldConfig.getName(), fieldConfig.getType().getCtClass().getName()));
        }
        sb.append("}");
        return sb.toString();
    }

    private static CtField createCtField(CtClass ctClass, FieldConfig field) throws CannotCompileException {
        CtField ctField = new CtField(field.getType().getCtClass(), field.getName(), ctClass);
        if (field.getType().hasGenericTypes()) {
            ctField.setGenericSignature(field.getType().getGenericSignature());
        }
        ctField.setModifiers(1);
        return ctField;
    }

    static {
        ScopedClassPoolRepositoryImpl.getInstance().setClassPoolFactory((ScopedClassPoolFactory)new StdScopedClassPoolFactory());
    }
}

