/*
 * Decompiled with CFR 0.152.
 */
package org.synchronoss.cloud.nio.multipart;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.synchronoss.cloud.nio.multipart.DefaultPartBodyStreamStorageFactory;
import org.synchronoss.cloud.nio.multipart.MultipartContext;
import org.synchronoss.cloud.nio.multipart.MultipartUtils;
import org.synchronoss.cloud.nio.multipart.NioMultipartParserListener;
import org.synchronoss.cloud.nio.multipart.PartBodyStreamStorageFactory;
import org.synchronoss.cloud.nio.multipart.io.FixedSizeByteArrayOutputStream;
import org.synchronoss.cloud.nio.multipart.io.buffer.EndOfLineBuffer;
import org.synchronoss.cloud.nio.multipart.util.HeadersParser;
import org.synchronoss.cloud.nio.stream.storage.Disposable;
import org.synchronoss.cloud.nio.stream.storage.StreamStorage;

public class NioMultipartParser
extends OutputStream
implements Disposable {
    private static final Logger log = LoggerFactory.getLogger(NioMultipartParser.class);
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    public static final int DEFAULT_HEADERS_SECTION_SIZE = 16384;
    public static final int DEFAULT_MAX_LEVEL_OF_NESTED_MULTIPART = 1;
    final MultipartContext multipartContext;
    final NioMultipartParserListener nioMultipartParserListener;
    final PartBodyStreamStorageFactory partBodyStreamStorageFactory;
    final EndOfLineBuffer endOfLineBuffer;
    final ByteArrayOutputStream headersByteArrayOutputStream;
    final int maxLevelOfNestedMultipart;
    final DelimiterType delimiterType = new DelimiterType();
    final Stack<byte[]> delimiterPrefixes = new Stack();
    final List<String> fsmTransitions = new ArrayList<String>();
    final WriteContext wCtx = new WriteContext();
    volatile State currentState = State.SKIP_PREAMBLE;
    volatile StreamStorage partBodyStreamStorage = null;
    volatile Map<String, List<String>> headers = null;
    volatile int partIndex = 1;
    volatile AtomicBoolean closed = new AtomicBoolean(false);

    public NioMultipartParser(MultipartContext multipartContext, NioMultipartParserListener nioMultipartParserListener) {
        this(multipartContext, nioMultipartParserListener, null, 16384, 16384, 1);
    }

    public NioMultipartParser(MultipartContext multipartContext, NioMultipartParserListener nioMultipartParserListener, PartBodyStreamStorageFactory partBodyStreamStorageFactory) {
        this(multipartContext, nioMultipartParserListener, partBodyStreamStorageFactory, 16384, 16384, 1);
    }

    public NioMultipartParser(MultipartContext multipartContext, NioMultipartParserListener nioMultipartParserListener, int bufferSize) {
        this(multipartContext, nioMultipartParserListener, null, bufferSize, 16384, 1);
    }

    public NioMultipartParser(MultipartContext multipartContext, NioMultipartParserListener nioMultipartParserListener, PartBodyStreamStorageFactory partBodyStreamStorageFactory, int bufferSize, int maxHeadersSectionSize, int maxLevelOfNestedMultipart) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("The buffer size must be grater than 0. Size specified: " + bufferSize);
        }
        this.multipartContext = multipartContext;
        this.nioMultipartParserListener = nioMultipartParserListener;
        byte[] delimiterPrefix = NioMultipartParser.getDelimiterPrefix(multipartContext.getContentType());
        int actualBufferSize = delimiterPrefix.length + bufferSize;
        this.delimiterPrefixes.push(delimiterPrefix);
        this.maxLevelOfNestedMultipart = maxLevelOfNestedMultipart;
        this.headersByteArrayOutputStream = maxHeadersSectionSize == -1 ? new ByteArrayOutputStream() : new FixedSizeByteArrayOutputStream(maxHeadersSectionSize);
        this.partBodyStreamStorageFactory = partBodyStreamStorageFactory != null ? partBodyStreamStorageFactory : new DefaultPartBodyStreamStorageFactory();
        this.endOfLineBuffer = new EndOfLineBuffer(actualBufferSize, NioMultipartParser.getPreambleDelimiterPrefix(this.delimiterPrefixes.peek()), null);
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true) && this.partBodyStreamStorage != null) {
            this.partBodyStreamStorage.close();
        }
    }

    public boolean dispose() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.partBodyStreamStorage != null) {
            return this.partBodyStreamStorage.dispose();
        }
        return true;
    }

    @Override
    public void flush() throws IOException {
        if (this.partBodyStreamStorage != null) {
            this.partBodyStreamStorage.flush();
        }
    }

    @Override
    public void write(int data) throws IOException {
        this.write(new byte[]{(byte)data}, 0, 1);
    }

    @Override
    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    @Override
    public void write(byte[] data, int indexStart, int indexEnd) {
        if (this.closed.get()) {
            throw new IllegalStateException("Cannot write, the parser is closed.");
        }
        if (data == null) {
            this.goToState(State.ERROR);
            throw new IllegalArgumentException("Data cannot be null");
        }
        if (data.length == 0) {
            return;
        }
        if (indexEnd < indexStart) {
            this.goToState(State.ERROR);
            throw new IllegalArgumentException("End index cannot be lower that the start index. End index: " + indexEnd + ", Start index: " + indexStart);
        }
        if (indexStart > data.length) {
            this.goToState(State.ERROR);
            throw new IllegalArgumentException("The start index cannot be greater than the size of the data. Start index: " + indexStart + ", Data length: " + data.length);
        }
        if (indexEnd > data.length) {
            this.goToState(State.ERROR);
            throw new IllegalArgumentException("The end index cannot be greater than the size of the data. End index: " + indexEnd + ", Data length: " + data.length);
        }
        this.wCtx.init(indexStart, indexEnd, data, false);
        block15: while (!this.wCtx.finished) {
            switch (this.currentState) {
                case SKIP_PREAMBLE: {
                    this.skipPreamble(this.wCtx);
                    continue block15;
                }
                case IDENTIFY_PREAMBLE_DELIMITER: {
                    this.identifyPreambleDelimiter(this.wCtx);
                    continue block15;
                }
                case GET_READY_FOR_HEADERS: {
                    this.getReadyForHeaders(this.wCtx);
                    continue block15;
                }
                case READ_HEADERS: {
                    this.readHeaders(this.wCtx);
                    continue block15;
                }
                case GET_READY_FOR_BODY: {
                    this.getReadyForBody(this.wCtx);
                    continue block15;
                }
                case READ_BODY: {
                    this.readBody(this.wCtx);
                    continue block15;
                }
                case IDENTIFY_BODY_DELIMITER: {
                    this.identifyBodyDelimiter(this.wCtx);
                    continue block15;
                }
                case PART_COMPLETE: {
                    this.partComplete(this.wCtx);
                    continue block15;
                }
                case GET_READY_FOR_NESTED_MULTIPART: {
                    this.getReadyForNestedMultipart(this.wCtx);
                    continue block15;
                }
                case NESTED_PART_READ: {
                    this.nestedPartRead(this.wCtx);
                    continue block15;
                }
                case ALL_PARTS_READ: {
                    this.allPartsRead(this.wCtx);
                    continue block15;
                }
                case SKIP_EPILOGUE: {
                    this.skipEpilogue(this.wCtx);
                    continue block15;
                }
                case ERROR: {
                    throw new IllegalStateException("Parser is in an error state.");
                }
            }
            throw new IllegalStateException("Unknown state");
        }
    }

    void goToState(State nextState) {
        if (log.isDebugEnabled()) {
            this.fsmTransitions.add(String.format("%-30s --> %s", this.currentState.name(), nextState.name()));
        }
        this.currentState = nextState;
    }

    void skipPreamble(WriteContext wCtx) {
        int byteOfData;
        while ((byteOfData = wCtx.read()) != -1) {
            if (!this.endOfLineBuffer.write((byte)byteOfData)) continue;
            this.goToState(State.IDENTIFY_PREAMBLE_DELIMITER);
            wCtx.setFinishedIfNoMoreData();
            return;
        }
        wCtx.setFinishedIfNoMoreData();
    }

    void getReadyForHeaders(WriteContext wCtx) {
        this.headersByteArrayOutputStream.reset();
        this.endOfLineBuffer.recycle(MultipartUtils.HEADER_DELIMITER, this.headersByteArrayOutputStream);
        this.headers = new HashMap<String, List<String>>();
        this.goToState(State.READ_HEADERS);
        wCtx.setFinishedIfNoMoreData();
    }

    void readHeaders(WriteContext wCtx) {
        int byteOfData;
        while ((byteOfData = wCtx.read()) != -1) {
            if (!this.endOfLineBuffer.write((byte)byteOfData)) continue;
            this.parseHeaders();
            String contentType = MultipartUtils.getHeader("Content-type", this.headers);
            if (MultipartUtils.isMultipart(contentType)) {
                this.goToState(State.GET_READY_FOR_NESTED_MULTIPART);
            } else {
                this.goToState(State.GET_READY_FOR_BODY);
            }
            wCtx.setFinishedIfNoMoreData();
            return;
        }
        wCtx.setFinishedIfNoMoreData();
    }

    void parseHeaders() {
        try {
            this.headers = HeadersParser.parseHeaders(new ByteArrayInputStream(this.headersByteArrayOutputStream.toByteArray()), this.multipartContext.getCharEncoding());
            this.headersByteArrayOutputStream.reset();
        }
        catch (Exception e) {
            this.goToState(State.ERROR);
            this.nioMultipartParserListener.onError("Error parsing the part headers", e);
        }
    }

    void getReadyForBody(WriteContext wCtx) {
        this.partBodyStreamStorage = this.partBodyStreamStorageFactory.newStreamStorageForPartBody(this.headers, this.partIndex);
        this.endOfLineBuffer.recycle(this.delimiterPrefixes.peek(), (OutputStream)this.partBodyStreamStorage);
        this.delimiterType.reset();
        this.goToState(State.READ_BODY);
        wCtx.setFinishedIfNoMoreData();
    }

    void getReadyForNestedMultipart(WriteContext wCtx) {
        if (this.delimiterPrefixes.size() > this.maxLevelOfNestedMultipart + 1) {
            this.goToState(State.ERROR);
            this.nioMultipartParserListener.onError("Reached maximum number of nested multiparts: " + this.maxLevelOfNestedMultipart, null);
        } else {
            byte[] delimiter = NioMultipartParser.getDelimiterPrefix(MultipartUtils.getHeader("Content-type", this.headers));
            this.delimiterType.reset();
            this.delimiterPrefixes.push(delimiter);
            this.endOfLineBuffer.recycle(NioMultipartParser.getPreambleDelimiterPrefix(delimiter), null);
            this.goToState(State.SKIP_PREAMBLE);
            this.nioMultipartParserListener.onNestedPartStarted(this.headers);
        }
        wCtx.setFinishedIfNoMoreData();
    }

    void readBody(WriteContext wCtx) {
        int byteOfData;
        while ((byteOfData = wCtx.read()) != -1) {
            if (!this.endOfLineBuffer.write((byte)byteOfData)) continue;
            this.goToState(State.IDENTIFY_BODY_DELIMITER);
            wCtx.setFinishedIfNoMoreData();
            return;
        }
        wCtx.setFinishedIfNoMoreData();
    }

    void identifyPreambleDelimiter(WriteContext wCtx) {
        if (this.delimiterPrefixes.size() > 1) {
            this.identifyDelimiter(wCtx, State.GET_READY_FOR_HEADERS, State.NESTED_PART_READ);
        } else {
            this.identifyDelimiter(wCtx, State.GET_READY_FOR_HEADERS, State.ALL_PARTS_READ);
        }
    }

    void identifyBodyDelimiter(WriteContext ctx) {
        this.identifyDelimiter(ctx, State.PART_COMPLETE, State.PART_COMPLETE);
    }

    void identifyDelimiter(WriteContext wCtx, State onDelimiter, State onCloseDelimiter) {
        int byteOfData;
        while ((byteOfData = wCtx.read()) != -1) {
            this.delimiterType.addDelimiterByte((byte)byteOfData);
            if (this.delimiterType.index < 2) continue;
            DelimiterType.Type type = this.delimiterType.getDelimiterType();
            if (DelimiterType.Type.ENCAPSULATION == type) {
                this.goToState(onDelimiter);
                wCtx.setFinishedIfNoMoreData();
                return;
            }
            if (DelimiterType.Type.CLOSE == type) {
                this.goToState(onCloseDelimiter);
                wCtx.setNotFinished();
                return;
            }
            this.goToState(State.ERROR);
            this.nioMultipartParserListener.onError("Unexpected characters follow a boundary", null);
            wCtx.setFinished();
            return;
        }
        wCtx.setFinishedIfNoMoreData();
    }

    void allPartsRead(WriteContext wCtx) {
        this.goToState(State.SKIP_EPILOGUE);
        this.nioMultipartParserListener.onAllPartsFinished();
        wCtx.setFinishedIfNoMoreData();
    }

    void partComplete(WriteContext wCtx) {
        try {
            this.partBodyStreamStorage.flush();
            this.partBodyStreamStorage.close();
        }
        catch (Exception e) {
            this.goToState(State.ERROR);
            this.nioMultipartParserListener.onError("Unable to read/write the body data", e);
            return;
        }
        if (this.delimiterType.getDelimiterType() == DelimiterType.Type.CLOSE) {
            if (this.delimiterPrefixes.size() > 1) {
                this.goToState(State.NESTED_PART_READ);
            } else {
                this.goToState(State.ALL_PARTS_READ);
            }
        } else {
            this.goToState(State.GET_READY_FOR_HEADERS);
        }
        this.nioMultipartParserListener.onPartFinished(this.partBodyStreamStorage, this.headers);
        ++this.partIndex;
        wCtx.setFinishedIfNoMoreData();
    }

    void nestedPartRead(WriteContext wCtx) {
        this.delimiterPrefixes.pop();
        this.delimiterType.reset();
        this.endOfLineBuffer.recycle(NioMultipartParser.getPreambleDelimiterPrefix(this.delimiterPrefixes.peek()), null);
        this.goToState(State.SKIP_PREAMBLE);
        this.nioMultipartParserListener.onNestedPartFinished();
        wCtx.setFinishedIfNoMoreData();
    }

    void skipEpilogue(WriteContext wCtx) {
        wCtx.setFinished();
    }

    static byte[] getPreambleDelimiterPrefix(byte[] delimiterPrefix) {
        byte[] preambleDelimiterPrefix = new byte[delimiterPrefix.length - 2];
        System.arraycopy(delimiterPrefix, 2, preambleDelimiterPrefix, 0, delimiterPrefix.length - 2);
        return preambleDelimiterPrefix;
    }

    static byte[] getDelimiterPrefix(String contentType) {
        byte[] boundary = MultipartUtils.getBoundary(contentType);
        if (boundary == null || boundary.length == 0) {
            throw new IllegalStateException("Invalid boundary in the content type " + contentType);
        }
        byte[] delimiterPrefix = new byte[boundary.length + 4];
        delimiterPrefix[0] = 13;
        delimiterPrefix[1] = 10;
        delimiterPrefix[2] = 45;
        delimiterPrefix[3] = 45;
        System.arraycopy(boundary, 0, delimiterPrefix, 4, boundary.length);
        return delimiterPrefix;
    }

    public List<String> geFsmTransitions() {
        if (log.isDebugEnabled()) {
            return this.fsmTransitions;
        }
        return null;
    }

    private static enum State {
        SKIP_PREAMBLE,
        IDENTIFY_PREAMBLE_DELIMITER,
        GET_READY_FOR_HEADERS,
        READ_HEADERS,
        GET_READY_FOR_BODY,
        READ_BODY,
        IDENTIFY_BODY_DELIMITER,
        PART_COMPLETE,
        GET_READY_FOR_NESTED_MULTIPART,
        NESTED_PART_READ,
        ALL_PARTS_READ,
        SKIP_EPILOGUE,
        ERROR;

    }

    private static class WriteContext {
        private int currentIndex;
        private int indexEnd;
        private byte[] data;
        private boolean finished;

        private WriteContext() {
        }

        void init(int currentIndex, int indexEnd, byte[] data, boolean finished) {
            this.currentIndex = currentIndex;
            this.indexEnd = indexEnd;
            this.data = data;
            this.finished = finished;
        }

        int read() {
            if (this.currentIndex >= this.indexEnd) {
                return -1;
            }
            byte ret = this.data[this.currentIndex];
            ++this.currentIndex;
            return ret & 0xFF;
        }

        void setNotFinished() {
            this.finished = false;
        }

        void setFinishedIfNoMoreData() {
            this.finished = this.currentIndex >= this.indexEnd;
        }

        void setFinished() {
            this.finished = true;
        }
    }

    private static class DelimiterType {
        final byte[] delimiterSuffix = new byte[2];
        int index = 0;

        private DelimiterType() {
        }

        void addDelimiterByte(byte delimiterByte) {
            if (this.index >= this.delimiterSuffix.length) {
                throw new IllegalStateException("Cannot write the delimiter byte.");
            }
            this.delimiterSuffix[this.index] = delimiterByte;
            ++this.index;
        }

        Type getDelimiterType() {
            if (this.index == 2) {
                if (this.delimiterSuffix[0] == 13 && this.delimiterSuffix[1] == 10) {
                    return Type.ENCAPSULATION;
                }
                if (this.delimiterSuffix[0] == 45 && this.delimiterSuffix[1] == 45) {
                    return Type.CLOSE;
                }
            }
            return Type.UNKNOWN;
        }

        void reset() {
            this.index = 0;
        }

        static enum Type {
            CLOSE,
            ENCAPSULATION,
            UNKNOWN;

        }
    }
}

