/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.service.center.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.servicecomb.service.center.client.model.MicroserviceInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DiscoveryEvents {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static class PullInstanceEvent
    extends DiscoveryEvents {
        private static final Logger LOGGER = LoggerFactory.getLogger(PullInstanceEvent.class);
        private final String appId;
        private final String serviceName;

        public PullInstanceEvent(String message) {
            JsonNode messageNode = this.parseJsonString(message);
            this.appId = this.getContextFromNode(messageNode, "appId");
            this.serviceName = this.getContextFromNode(messageNode, "serviceName");
        }

        public String getAppId() {
            return this.appId;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        private JsonNode parseJsonString(String message) {
            try {
                return OBJECT_MAPPER.readTree(message);
            }
            catch (Exception e) {
                LOGGER.error("parse message [{}] failed!", (Object)message, (Object)e);
                return null;
            }
        }

        private String getContextFromNode(JsonNode messageNode, String itemKey) {
            if (messageNode == null) {
                return "";
            }
            try {
                return messageNode.get("key").get(itemKey).asText();
            }
            catch (Exception e) {
                LOGGER.error("get [{}] context from node [{}] failed!", (Object)itemKey, (Object)e);
                return "";
            }
        }
    }

    public static class InstanceChangedEvent
    extends DiscoveryEvents {
        private final String appName;
        private final String serviceName;
        private final List<MicroserviceInstance> instances;

        public InstanceChangedEvent(String appName, String serviceName, List<MicroserviceInstance> instances) {
            this.appName = appName;
            this.serviceName = serviceName;
            this.instances = instances;
        }

        public String getAppName() {
            return this.appName;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public List<MicroserviceInstance> getInstances() {
            return this.instances;
        }
    }
}

