/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.bizkeeper;

import com.netflix.config.DynamicPropertyFactory;

public final class Configuration {
    private static final String ISOLATION = "servicecomb.isolation.";
    private static final String ISOLATION_TIMEOUT_IN_MILLISECONDS = "timeoutInMilliseconds";
    private static final String ISOLATION_TIMEOUT_IN_MILLISECONDS_OLD = ".businessKeeper.command.execution.isolation.thread.timeoutInMilliseconds";
    private static final String ISOLATION_TIMEOUT_ENABLED = "timeout.enabled";
    private static final String ISOLATION_MAX_CONCURRENT_REQUESTS = "maxConcurrentRequests";
    private static final String CIRCUIT_BREAKER = "servicecomb.circuitBreaker.";
    private static final String CIRCUIT_BREAKER_ENABLED = "enabled";
    private static final String CIRCUIT_BREAKER_FORCEOPEN = "forceOpen";
    private static final String CIRCUIT_BREAKER_FORCECLOSED = "forceClosed";
    private static final String CIRCUIT_BREAKER_SLEEP_WINDOW_IN_MILLISECONDS = "sleepWindowInMilliseconds";
    private static final String CIRCUIT_BREAKER_REQUEST_VOLUME_THRESHOLD = "requestVolumeThreshold";
    private static final String CIRCUIT_BREAKER_ERROR_THRESHOLD_PERCENTAGE = "errorThresholdPercentage";
    private static final String FALLBACK = "servicecomb.fallback.";
    private static final String FALLBACK_FORCE = "force";
    private static final String FALLBACK_MAX_CONCURRENT_REQUESTS = "maxConcurrentRequests";
    private static final String FALLBACKPOLICY = "servicecomb.fallbackpolicy.";
    private static final String FALLBACKPOLICY_POLICY = "policy";
    public static final String FALLBACKPOLICY_POLICY_THROW = "throwexception";
    public static final String FALLBACKPOLICY_POLICY_RETURN = "returnnull";
    private static final int DEFAULT_ISOLATION_TIMEOUT = 30000;
    private static final int DEFAULT_MAX_CONCURRENT_REQUESTS = 1000;
    private static final int DEFAULT_SLEEP_WINDOW = 15000;
    private static final int DEFAULT_VOLUME_THRESHOLD = 20;
    private static final int DEFAULT_THRESHOLD_PERCENTAGE = 50;
    public static final Configuration INSTANCE = new Configuration();

    private Configuration() {
    }

    public int getIsolationTimeoutInMilliseconds(String type, String microserviceName, String qualifiedOperationName) {
        int timeout;
        String p = this.getProperty("30000", ISOLATION + type + "." + qualifiedOperationName + ".timeoutInMilliseconds", ISOLATION + type + "." + microserviceName + ".timeoutInMilliseconds", ISOLATION + type + ".timeoutInMilliseconds", type + "." + microserviceName + ISOLATION_TIMEOUT_IN_MILLISECONDS_OLD, type + ".default.businessKeeper.command.execution.isolation.thread.timeoutInMilliseconds");
        try {
            timeout = Integer.parseInt(p);
        }
        catch (NumberFormatException e) {
            return 30000;
        }
        if (timeout > 0) {
            return timeout;
        }
        return 30000;
    }

    public boolean getIsolationTimeoutEnabled(String type, String microserviceName, String qualifiedOperationName) {
        String p = this.getProperty("false", ISOLATION + type + "." + qualifiedOperationName + ".timeout.enabled", ISOLATION + type + "." + microserviceName + ".timeout.enabled", ISOLATION + type + ".timeout.enabled");
        return Boolean.parseBoolean(p);
    }

    public int getIsolationMaxConcurrentRequests(String type, String microserviceName, String qualifiedOperationName) {
        int concurrentRequests;
        String p = this.getProperty("1000", ISOLATION + type + "." + qualifiedOperationName + ".maxConcurrentRequests", ISOLATION + type + "." + microserviceName + ".maxConcurrentRequests", ISOLATION + type + ".maxConcurrentRequests");
        try {
            concurrentRequests = Integer.parseInt(p);
        }
        catch (NumberFormatException e) {
            return 1000;
        }
        if (concurrentRequests > 0) {
            return concurrentRequests;
        }
        return 1000;
    }

    public boolean isCircuitBreakerEnabled(String type, String microserviceName, String qualifiedOperationName) {
        String p = this.getProperty("true", CIRCUIT_BREAKER + type + "." + qualifiedOperationName + ".enabled", CIRCUIT_BREAKER + type + "." + microserviceName + ".enabled", CIRCUIT_BREAKER + type + ".enabled");
        return Boolean.parseBoolean(p);
    }

    public boolean isCircuitBreakerForceOpen(String type, String microserviceName, String qualifiedOperationName) {
        String p = this.getProperty("false", CIRCUIT_BREAKER + type + "." + qualifiedOperationName + ".forceOpen", CIRCUIT_BREAKER + type + "." + microserviceName + ".forceOpen", CIRCUIT_BREAKER + type + ".forceOpen");
        return Boolean.parseBoolean(p);
    }

    public boolean isCircuitBreakerForceClosed(String type, String microserviceName, String qualifiedOperationName) {
        String p = this.getProperty("false", CIRCUIT_BREAKER + type + "." + qualifiedOperationName + ".forceClosed", CIRCUIT_BREAKER + type + "." + microserviceName + ".forceClosed", CIRCUIT_BREAKER + type + ".forceClosed");
        return Boolean.parseBoolean(p);
    }

    public int getCircuitBreakerSleepWindowInMilliseconds(String type, String microserviceName, String qualifiedOperationName) {
        String p = this.getProperty("15000", CIRCUIT_BREAKER + type + "." + qualifiedOperationName + ".sleepWindowInMilliseconds", CIRCUIT_BREAKER + type + "." + microserviceName + ".sleepWindowInMilliseconds", CIRCUIT_BREAKER + type + ".sleepWindowInMilliseconds");
        try {
            return Integer.parseInt(p);
        }
        catch (NumberFormatException e) {
            return 15000;
        }
    }

    public int getCircuitBreakerRequestVolumeThreshold(String type, String microserviceName, String qualifiedOperationName) {
        String p = this.getProperty("20", CIRCUIT_BREAKER + type + "." + qualifiedOperationName + ".requestVolumeThreshold", CIRCUIT_BREAKER + type + "." + microserviceName + ".requestVolumeThreshold", CIRCUIT_BREAKER + type + ".requestVolumeThreshold");
        try {
            return Integer.parseInt(p);
        }
        catch (NumberFormatException e) {
            return 20;
        }
    }

    public int getCircuitBreakerErrorThresholdPercentage(String type, String microserviceName, String qualifiedOperationName) {
        String p = this.getProperty("50", CIRCUIT_BREAKER + type + "." + qualifiedOperationName + ".errorThresholdPercentage", CIRCUIT_BREAKER + type + "." + microserviceName + ".errorThresholdPercentage", CIRCUIT_BREAKER + type + ".errorThresholdPercentage");
        try {
            return Integer.parseInt(p);
        }
        catch (NumberFormatException e) {
            return 50;
        }
    }

    public boolean isFallbackForce(String type, String microserviceName, String qualifiedOperationName) {
        String p = this.getProperty("false", FALLBACK + type + "." + qualifiedOperationName + ".force", FALLBACK + type + "." + microserviceName + ".force", FALLBACK + type + ".force");
        return Boolean.parseBoolean(p);
    }

    public int getFallbackMaxConcurrentRequests(String type, String microserviceName, String qualifiedOperationName) {
        String p = this.getProperty("10", FALLBACK + type + "." + qualifiedOperationName + ".maxConcurrentRequests", FALLBACK + type + "." + microserviceName + ".maxConcurrentRequests", FALLBACK + type + ".maxConcurrentRequests");
        try {
            return Integer.parseInt(p);
        }
        catch (NumberFormatException e) {
            return 1000;
        }
    }

    public String getFallbackPolicyPolicy(String type, String microserviceName, String qualifiedOperationName) {
        return this.getProperty(null, FALLBACKPOLICY + type + "." + qualifiedOperationName + ".policy", FALLBACKPOLICY + type + "." + microserviceName + ".policy", FALLBACKPOLICY + type + ".policy");
    }

    private String getProperty(String defaultValue, String ... keys) {
        String property = null;
        for (String key : keys) {
            property = DynamicPropertyFactory.getInstance().getStringProperty(key, null).get();
            if (property != null) break;
        }
        if (property != null) {
            return property;
        }
        return defaultValue;
    }
}

