/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.oak;

import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.TopologyEvent;
import org.apache.sling.discovery.TopologyEventListener;
import org.apache.sling.discovery.TopologyView;
import org.apache.sling.discovery.oak.Config;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.util.converter.Converters;
import org.osgi.util.converter.Converting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Designate(ocd=Conf.class)
public class SlingIdCleanupTask
implements TopologyEventListener,
Runnable {
    static final String SLINGID_CLEANUP_ENABLED_SYSTEM_PROPERTY_NAME = "org.apache.sling.discovery.oak.slingidcleanup.enabled";
    static final long MIN_CLEANUP_DELAY_MILLIS = 46800000L;
    private static final long DEFAULT_MIN_CREATION_AGE_MILLIS = 604800000L;
    private static final int DEFAULT_CLEANUP_INITIAL_DELAY = 600000;
    private static final int DEFAULT_CLEANUP_INTERVAL = 600000;
    private static final int DEFAULT_CLEANUP_BATCH_SIZE = 50;
    private static final String SCHEDULE_NAME = "org.apache.sling.discovery.oak.SlingIdCleanupTask";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    protected Scheduler scheduler;
    @Reference
    protected ResourceResolverFactory resourceResolverFactory;
    @Reference
    private Config config;
    private volatile boolean hasTopology = false;
    private volatile TopologyView currentView;
    private int initialDelayMillis = 600000;
    private int intervalMillis = 600000;
    private int batchSize = 50;
    private long minCreationAgeMillis = 604800000L;
    private AtomicInteger runCount = new AtomicInteger(0);
    private AtomicInteger completionCount = new AtomicInteger(0);
    private AtomicInteger deleteCount = new AtomicInteger(0);
    private volatile boolean firstRun = true;
    private long lastSuccessfulRun = -1L;
    private long minCleanupDelayMillis = 46800000L;
    private Set<String> seenInstances = new CopyOnWriteArraySet<String>();

    static SlingIdCleanupTask create(Scheduler scheduler, ResourceResolverFactory factory, Config config, int initialDelayMillis, int intervalMillis, int batchSize, long minCreationAgeMillis, long minCleanupDelayMillis) {
        SlingIdCleanupTask s = new SlingIdCleanupTask();
        s.scheduler = scheduler;
        s.resourceResolverFactory = factory;
        s.config = config;
        s.minCleanupDelayMillis = minCleanupDelayMillis;
        s.config(initialDelayMillis, intervalMillis, batchSize, minCreationAgeMillis);
        return s;
    }

    @Activate
    protected void activate(BundleContext bc, Conf config) {
        this.modified(bc, config);
    }

    @Modified
    protected void modified(BundleContext bc, Conf config) {
        if (config == null) {
            return;
        }
        this.config(config.slingid_cleanup_initial_delay(), config.slingid_cleanup_interval(), config.slingid_cleanup_batchsize(), config.slingid_cleanup_min_creation_age());
    }

    @Deactivate
    protected void deactivate() {
        this.logger.info("deactivate : deactivated.");
        this.hasTopology = false;
    }

    private void config(int initialDelayMillis, int intervalMillis, int batchSize, long minCreationAgeMillis) {
        this.initialDelayMillis = initialDelayMillis;
        this.intervalMillis = intervalMillis;
        this.batchSize = batchSize;
        this.minCreationAgeMillis = minCreationAgeMillis;
        this.logger.info("config: enabled = {}, initial delay milliseconds = {}, interval milliseconds = {}, batch size = {}, min creation age milliseconds = {}", new Object[]{SlingIdCleanupTask.isEnabled(), initialDelayMillis, intervalMillis, batchSize, minCreationAgeMillis});
    }

    public void handleTopologyEvent(TopologyEvent event) {
        if (!SlingIdCleanupTask.isEnabled()) {
            this.hasTopology = false;
            this.currentView = null;
            this.stop();
            this.logger.debug("handleTopologyEvent: slingId cleanup is disabled");
            return;
        }
        TopologyView newView = event.getNewView();
        if (event.getType() != TopologyEvent.Type.PROPERTIES_CHANGED) {
            if (newView == null) {
                this.hasTopology = false;
                this.currentView = null;
                this.stop();
            } else {
                this.hasTopology = true;
                this.currentView = newView;
                this.seenInstances.addAll(this.getActiveSlingIds(newView));
                if (newView.getLocalInstance().isLeader()) {
                    this.recreateSchedule();
                } else {
                    this.stop();
                }
            }
        }
    }

    private void stop() {
        Scheduler localScheduler = this.scheduler;
        if (localScheduler == null) {
            this.logger.warn("stop: no scheduler set, giving up.");
            return;
        }
        boolean unscheduled = localScheduler.unschedule(SCHEDULE_NAME);
        if (unscheduled) {
            this.logger.info("stop: unscheduled");
        } else {
            this.logger.debug("stop: unschedule was not necessary");
        }
    }

    private static boolean isEnabled() {
        String systemPropertyValue = System.getProperty(SLINGID_CLEANUP_ENABLED_SYSTEM_PROPERTY_NAME);
        return (Boolean)((Converting)Converters.standardConverter().convert((Object)systemPropertyValue).defaultValue((Object)false)).to(Boolean.class);
    }

    private void recreateSchedule() {
        Scheduler localScheduler = this.scheduler;
        if (localScheduler == null) {
            this.logger.warn("recreateSchedule: no scheduler set, giving up.");
            return;
        }
        Calendar cal = Calendar.getInstance();
        int delayMillis = this.firstRun ? this.initialDelayMillis : this.intervalMillis;
        cal.add(14, delayMillis);
        Date scheduledDate = cal.getTime();
        this.logger.info("recreateSchedule: scheduling a cleanup in {} milliseconds from now, which is: {}", (Object)delayMillis, (Object)scheduledDate);
        ScheduleOptions options = localScheduler.AT(scheduledDate);
        options.name(SCHEDULE_NAME);
        options.canRunConcurrently(false);
        localScheduler.schedule((Object)this, options);
    }

    @Override
    public void run() {
        if (this.lastSuccessfulRun > 0L && System.currentTimeMillis() - this.lastSuccessfulRun < this.minCleanupDelayMillis) {
            this.logger.debug("run: last cleanup was {} millis ago, which is less than {} millis, therefore not cleaning up yet.", (Object)(System.currentTimeMillis() - this.lastSuccessfulRun), (Object)this.minCleanupDelayMillis);
            this.recreateSchedule();
            return;
        }
        this.runCount.incrementAndGet();
        if (!this.hasTopology) {
            return;
        }
        boolean mightHaveMore = true;
        try {
            mightHaveMore = this.cleanup();
        }
        catch (Exception e) {
            this.logger.error("run: got Exception while cleaning up slnigIds : " + e, (Throwable)e);
        }
        if (mightHaveMore) {
            this.recreateSchedule();
            return;
        }
        this.logger.info("run: slingId cleanup done, run counter = {}, delete counter = {}, completion counter = {}", new Object[]{this.getRunCount(), this.getDeleteCount(), this.getCompletionCount()});
        this.lastSuccessfulRun = System.currentTimeMillis();
    }

    /*
     * Exception decompiling
     */
    private boolean cleanup() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 21[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Set<String> getActiveSlingIds(TopologyView localCurrentView) {
        return localCurrentView.getLocalInstance().getClusterView().getInstances().stream().map(InstanceDescription::getSlingId).collect(Collectors.toSet());
    }

    private boolean topologyChanged(TopologyView localCurrentView) {
        if (!this.hasTopology || this.currentView != localCurrentView || !localCurrentView.isCurrent()) {
            this.logger.debug("topologyChanged : topology changing during cleanup - not committing this time - stopping for now.");
            return true;
        }
        return false;
    }

    static long millisOf(Object leaderElectionIdCreatedAt) {
        if (leaderElectionIdCreatedAt == null) {
            return -1L;
        }
        if (leaderElectionIdCreatedAt instanceof Date) {
            Date d = (Date)leaderElectionIdCreatedAt;
            return d.getTime();
        }
        if (leaderElectionIdCreatedAt instanceof Calendar) {
            Calendar c = (Calendar)leaderElectionIdCreatedAt;
            return c.getTimeInMillis();
        }
        return -1L;
    }

    private boolean deleteIfOldSlingId(Resource resourceOrNull, String slingId, ModifiableValueMap syncTokenMap, ValueMap idMapMap, Set<String> activeSlingIds, Calendar now, long localMinCreationAgeMillis) throws PersistenceException {
        this.logger.trace("deleteIfOldSlingId : handling slingId = {}", (Object)slingId);
        if (activeSlingIds.contains(slingId)) {
            this.logger.trace("deleteIfOldSlingId : slingId is currently active : {}", (Object)slingId);
            return false;
        }
        if (this.seenInstances.contains(slingId)) {
            this.logger.trace("deleteIfOldSlingId : slingId seen active previously : {}", (Object)slingId);
            return false;
        }
        if (resourceOrNull != null) {
            Object clusterNodeId = idMapMap.get((Object)slingId);
            if (clusterNodeId != null) {
                this.logger.trace("deleteIfOldSlingId : slingId {} WAS recently in use : {}", (Object)slingId, clusterNodeId);
                return false;
            }
            this.logger.trace("deleteIfOldSlingId : slingId {} not recently in use", (Object)slingId);
            Object o = resourceOrNull.getValueMap().get((Object)"leaderElectionIdCreatedAt");
            long leaderElectionIdCreatedAt = SlingIdCleanupTask.millisOf(o);
            if (leaderElectionIdCreatedAt <= 0L) {
                this.logger.trace("deleteIfOldSlingId: resource ({}) has no or wrongly typed leaderElectionIdCreatedAt : {}", (Object)resourceOrNull, o);
                return false;
            }
            long diffMillis = now.getTimeInMillis() - leaderElectionIdCreatedAt;
            if (diffMillis <= localMinCreationAgeMillis) {
                this.logger.trace("deleteIfOldSlingId: not old slingId : {}", (Object)resourceOrNull);
                return false;
            }
        }
        this.logger.trace("deleteIfOldSlingId: deleting old slingId : {}", (Object)resourceOrNull);
        syncTokenMap.remove((Object)slingId);
        if (resourceOrNull != null) {
            resourceOrNull.getResourceResolver().delete(resourceOrNull);
        }
        return true;
    }

    int getRunCount() {
        return this.runCount.get();
    }

    int getDeleteCount() {
        return this.deleteCount.get();
    }

    int getCompletionCount() {
        return this.completionCount.get();
    }

    @ObjectClassDefinition(name="Apache Sling Discovery Oak SlingId Cleanup Task", description="This task is in charge of cleaning up old SlingIds from the repository.")
    public static @interface Conf {
        @AttributeDefinition(name="Cleanup initial delay milliseconds", description="Number of milliseconds to initially wait for the first cleanup")
        public int slingid_cleanup_initial_delay() default 600000;

        @AttributeDefinition(name="Cleanup interval milliseconds", description="Number of milliseconds after which to do another batch of cleaning up (if necessary)")
        public int slingid_cleanup_interval() default 600000;

        @AttributeDefinition(name="Cleanup batch size", description="Maximum number of slingIds to cleanup in one batch.")
        public int slingid_cleanup_batchsize() default 50;

        @AttributeDefinition(name="Cleanup minimum creation age", description="Minimum number of milliseconds since the slingId was created.")
        public long slingid_cleanup_min_creation_age() default 604800000L;
    }
}

