/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.oak.cluster;

public class InstanceInfo {
    private final int clusterNodeId;
    private final String slingId;
    private final long syncToken;
    private final String leaderElectionId;

    public InstanceInfo(int clusterNodeId, String slingId, long syncToken, String leaderElectionId) {
        this.clusterNodeId = clusterNodeId;
        this.slingId = slingId;
        this.syncToken = syncToken;
        this.leaderElectionId = leaderElectionId;
    }

    public String getLeaderElectionId() {
        return this.leaderElectionId;
    }

    public int getClusterNodeId() {
        return this.clusterNodeId;
    }

    public String getSlingId() {
        return this.slingId;
    }

    public boolean isSyncTokenNewerOrEqual(long seqNum) {
        if (this.syncToken == -1L) {
            return false;
        }
        return this.syncToken >= seqNum;
    }

    public String toString() {
        return "an Instance[clusterNodeId = " + this.clusterNodeId + ", slingId = " + this.slingId + ", leaderElectionId = " + this.leaderElectionId + ", syncToken = " + this.syncToken + "]";
    }
}

