/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.jackrabbit.accessmanager;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.jcr.Value;
import javax.jcr.security.Privilege;
import org.apache.sling.jcr.jackrabbit.accessmanager.LocalRestriction;
import org.jetbrains.annotations.NotNull;

public class LocalPrivilege {
    private Privilege privilege;
    private boolean allow;
    private boolean deny;
    private Set<LocalRestriction> allowRestrictions = Collections.emptySet();
    private Set<LocalRestriction> denyRestrictions = Collections.emptySet();

    public LocalPrivilege(@NotNull Privilege privilege) {
        this.privilege = privilege;
    }

    public Privilege getPrivilege() {
        return this.privilege;
    }

    public String getName() {
        return this.privilege.getName();
    }

    public boolean isNone() {
        return !this.allow && !this.deny;
    }

    public boolean isAllow() {
        return this.allow;
    }

    public boolean isDeny() {
        return this.deny;
    }

    public void setAllow(boolean allow) {
        this.allow = allow;
    }

    public void setDeny(boolean deny) {
        this.deny = deny;
    }

    public Set<LocalRestriction> getAllowRestrictions() {
        return Collections.unmodifiableSet(this.allowRestrictions);
    }

    public Set<LocalRestriction> getDenyRestrictions() {
        return Collections.unmodifiableSet(this.denyRestrictions);
    }

    protected Set<LocalRestriction> mergeRestrictions(Set<LocalRestriction> currentRestrictions, Set<LocalRestriction> newRestrictions) {
        HashSet<LocalRestriction> mergedRestrictons;
        if (newRestrictions == null) {
            mergedRestrictons = null;
        } else {
            mergedRestrictons = new HashSet<LocalRestriction>(currentRestrictions);
            for (LocalRestriction lr : newRestrictions) {
                if (lr.isMultiValue()) {
                    String expectedName = lr.getName();
                    Optional<LocalRestriction> existing = currentRestrictions.stream().filter(r -> r.getName().equals(expectedName)).findFirst();
                    if (existing.isPresent()) {
                        mergedRestrictons.removeIf(k -> expectedName.equals(k.getName()));
                        LinkedHashSet mergedValues = new LinkedHashSet();
                        LocalRestriction existingLr = existing.get();
                        Stream.of(existingLr.getValues()).forEach(mergedValues::add);
                        Stream.of(lr.getValues()).forEach(mergedValues::add);
                        Value[] newValues = mergedValues.toArray(new Value[mergedValues.size()]);
                        lr = LocalRestriction.cloneWithNewValues(lr, newValues);
                    }
                }
                mergedRestrictons.add(lr);
            }
        }
        return mergedRestrictons;
    }

    public void setAllowRestrictions(Set<LocalRestriction> restrictions) {
        this.allowRestrictions = this.mergeRestrictions(this.allowRestrictions, restrictions);
    }

    public void setDenyRestrictions(Set<LocalRestriction> restrictions) {
        this.denyRestrictions = this.mergeRestrictions(this.denyRestrictions, restrictions);
    }

    public void unsetAllowRestrictions(Collection<String> restrictionNames) {
        this.allowRestrictions.removeIf(k -> restrictionNames.contains(k.getName()));
    }

    public void unsetDenyRestrictions(Collection<String> restrictionNames) {
        this.denyRestrictions.removeIf(k -> restrictionNames.contains(k.getName()));
    }

    public void clearAllowRestrictions() {
        this.allowRestrictions.clear();
    }

    public void clearDenyRestrictions() {
        this.denyRestrictions.clear();
    }

    public boolean sameAllowRestrictions(Set<LocalRestriction> otherAllowRestrictions) {
        boolean same = false;
        if (this.allowRestrictions.size() == otherAllowRestrictions.size() && this.allowRestrictions.containsAll(otherAllowRestrictions)) {
            same = true;
        }
        return same;
    }

    public boolean sameDenyRestrictions(Set<LocalRestriction> otherDenyRestrictions) {
        boolean same = false;
        if (this.denyRestrictions.size() == otherDenyRestrictions.size() && this.denyRestrictions.containsAll(otherDenyRestrictions)) {
            same = true;
        }
        return same;
    }

    public boolean sameAllowAndDenyRestrictions() {
        boolean same = false;
        if (this.allowRestrictions.size() == this.denyRestrictions.size() && this.allowRestrictions.containsAll(this.denyRestrictions)) {
            same = true;
        }
        return same;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LocalPrivilege [name=");
        builder.append(this.getName());
        builder.append(", allow=");
        builder.append(this.allow);
        builder.append(", deny=");
        builder.append(this.deny);
        builder.append(", allowRestrictions=");
        builder.append(this.allowRestrictions);
        builder.append(", denyRestrictions=");
        builder.append(this.denyRestrictions);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allow ? 1231 : 1237);
        result = 31 * result + (this.allowRestrictions == null ? 0 : this.allowRestrictions.hashCode());
        result = 31 * result + (this.deny ? 1231 : 1237);
        result = 31 * result + (this.denyRestrictions == null ? 0 : this.denyRestrictions.hashCode());
        result = 31 * result + (this.privilege == null ? 0 : this.privilege.getName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalPrivilege other = (LocalPrivilege)obj;
        if (this.allow != other.allow) {
            return false;
        }
        if (this.allowRestrictions == null ? other.allowRestrictions != null : !this.allowRestrictions.equals(other.allowRestrictions)) {
            return false;
        }
        if (this.deny != other.deny) {
            return false;
        }
        if (this.denyRestrictions == null ? other.denyRestrictions != null : !this.denyRestrictions.equals(other.denyRestrictions)) {
            return false;
        }
        if (this.privilege == null) {
            if (other.privilege != null) {
                return false;
            }
        } else {
            if (other.privilege == null) {
                return false;
            }
            if (!this.privilege.getName().equals(other.privilege.getName())) {
                return false;
            }
        }
        return true;
    }
}

