/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.rest.handler;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import com.thoughtworks.xstream.security.ArrayTypePermission;
import com.thoughtworks.xstream.security.ExplicitTypePermission;
import com.thoughtworks.xstream.security.NullPermission;
import com.thoughtworks.xstream.security.PrimitiveTypePermission;
import com.thoughtworks.xstream.security.TypePermission;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ActionInvocation;
import org.apache.struts2.ModelDriven;
import org.apache.struts2.rest.handler.ContentTypeHandler;
import org.apache.struts2.rest.handler.xstream.XStreamAllowedClassNames;
import org.apache.struts2.rest.handler.xstream.XStreamAllowedClasses;
import org.apache.struts2.rest.handler.xstream.XStreamPermissionProvider;
import org.apache.struts2.rest.handler.xstream.XStreamProvider;

public class XStreamHandler
implements ContentTypeHandler {
    private static final Logger LOG = LogManager.getLogger(XStreamHandler.class);

    @Override
    public String fromObject(ActionInvocation invocation, Object obj, String resultCode, Writer out) throws IOException {
        if (obj != null) {
            XStream xstream = this.createXStream(invocation);
            xstream.toXML(obj, out);
        }
        return null;
    }

    @Override
    public void toObject(ActionInvocation invocation, Reader in, Object target) {
        XStream xstream = this.createXStream(invocation);
        xstream.fromXML(in, target);
    }

    protected XStream createXStream(ActionInvocation invocation) {
        XStream stream;
        if (invocation.getAction() instanceof XStreamProvider) {
            LOG.debug("Using provider {} to create instance of XStream", (Object)invocation.getAction().getClass().getSimpleName());
            stream = ((XStreamProvider)invocation.getAction()).createXStream();
        } else {
            LOG.debug("Creating default XStream instance using Stax driver: {}", (Object)StaxDriver.class.getSimpleName());
            stream = new XStream((HierarchicalStreamDriver)new StaxDriver());
        }
        LOG.debug("Adds per action permissions");
        this.addPerActionPermission(invocation, stream);
        LOG.debug("Adds default permissions");
        this.addDefaultPermissions(invocation, stream);
        return stream;
    }

    private void addPerActionPermission(ActionInvocation invocation, XStream stream) {
        Object action = invocation.getAction();
        if (action instanceof XStreamAllowedClasses) {
            Set<Class<?>> allowedClasses = ((XStreamAllowedClasses)action).allowedClasses();
            stream.addPermission((TypePermission)new ExplicitTypePermission(allowedClasses.toArray(new Class[0])));
        }
        if (action instanceof XStreamAllowedClassNames) {
            Set<String> allowedClassNames = ((XStreamAllowedClassNames)action).allowedClassNames();
            stream.addPermission((TypePermission)new ExplicitTypePermission(allowedClassNames.toArray(new String[0])));
        }
        if (action instanceof XStreamPermissionProvider) {
            Collection<TypePermission> permissions = ((XStreamPermissionProvider)action).getTypePermissions();
            for (TypePermission permission : permissions) {
                stream.addPermission(permission);
            }
        }
    }

    protected void addDefaultPermissions(ActionInvocation invocation, XStream stream) {
        stream.addPermission((TypePermission)new ExplicitTypePermission(new Class[]{invocation.getAction().getClass()}));
        if (invocation.getAction() instanceof ModelDriven) {
            stream.addPermission((TypePermission)new ExplicitTypePermission(new Class[]{((ModelDriven)invocation.getAction()).getModel().getClass()}));
        }
        stream.addPermission(NullPermission.NULL);
        stream.addPermission((TypePermission)new ExplicitTypePermission(new Class[]{String.class}));
        stream.addPermission(PrimitiveTypePermission.PRIMITIVES);
        stream.addPermission(ArrayTypePermission.ARRAYS);
        stream.addPermission(CollectionTypePermission.COLLECTIONS);
    }

    @Override
    public String getContentType() {
        return "application/xml";
    }

    @Override
    public String getExtension() {
        return "xml";
    }

    private static class CollectionTypePermission
    implements TypePermission {
        private static final TypePermission COLLECTIONS = new CollectionTypePermission();

        private CollectionTypePermission() {
        }

        public boolean allows(Class type) {
            return type != null && (Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type));
        }
    }
}

