/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.jasperreports.engine.ExpressionReturnValue;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.base.BaseExpressionReturnValue;
import net.sf.jasperreports.engine.base.JRBaseElementGroup;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.SplitTypeEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRBaseBand
extends JRBaseElementGroup
implements JRBand,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_splitType = "splitType";
    protected int height;
    protected SplitTypeEnum splitType;
    protected JRExpression printWhenExpression;
    private JRPropertiesMap propertiesMap;
    protected List<ExpressionReturnValue> returnValues;
    private transient JRPropertyChangeSupport eventSupport;

    protected JRBaseBand(JRBand band, JRBaseObjectFactory factory) {
        super(band, factory);
        this.height = band.getHeight();
        this.splitType = band.getSplitType();
        this.printWhenExpression = factory.getExpression(band.getPrintWhenExpression());
        this.propertiesMap = JRPropertiesMap.getPropertiesClone(band);
        List<ExpressionReturnValue> bandReturnValues = band.getReturnValues();
        if (bandReturnValues != null && !bandReturnValues.isEmpty()) {
            this.returnValues = new ArrayList<ExpressionReturnValue>(bandReturnValues.size());
            for (ExpressionReturnValue bandReturnValue : bandReturnValues) {
                BaseExpressionReturnValue returnValue = factory.getReturnValue(bandReturnValue);
                this.returnValues.add(returnValue);
            }
        }
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public SplitTypeEnum getSplitType() {
        return this.splitType;
    }

    @Override
    public void setSplitType(SplitTypeEnum splitType) {
        SplitTypeEnum old = this.splitType;
        this.splitType = splitType;
        this.getEventSupport().firePropertyChange(PROPERTY_splitType, old, this.splitType);
    }

    @Override
    public JRExpression getPrintWhenExpression() {
        return this.printWhenExpression;
    }

    @Override
    public List<ExpressionReturnValue> getReturnValues() {
        return this.returnValues == null ? null : Collections.unmodifiableList(this.returnValues);
    }

    @Override
    public Object clone() {
        JRBaseBand clone = (JRBaseBand)super.clone();
        clone.printWhenExpression = JRCloneUtils.nullSafeClone(this.printWhenExpression);
        clone.propertiesMap = JRPropertiesMap.getPropertiesClone(this);
        clone.returnValues = JRCloneUtils.cloneList(this.returnValues);
        clone.eventSupport = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseBand jRBaseBand = this;
        synchronized (jRBaseBand) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    @Override
    public boolean hasProperties() {
        return this.propertiesMap != null && this.propertiesMap.hasProperties();
    }

    @Override
    public JRPropertiesMap getPropertiesMap() {
        if (this.propertiesMap == null) {
            this.propertiesMap = new JRPropertiesMap();
        }
        return this.propertiesMap;
    }

    @Override
    public JRPropertiesHolder getParentProperties() {
        return null;
    }
}

