/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import com.fasterxml.jackson.annotation.JsonMerge;
import java.io.Serializable;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.type.FooterPositionEnum;
import net.sf.jasperreports.engine.util.CloneStore;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import net.sf.jasperreports.engine.util.StoreCloneable;

public class JRBaseGroup
implements JRGroup,
Serializable,
JRChangeEventsSupport,
StoreCloneable<JRBaseGroup> {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_MIN_HEIGHT_TO_START_NEW_PAGE = "minHeightToStartNewPage";
    public static final String PROPERTY_MIN_DETAILS_TO_START_FROM_TOP = "minDetailsToStartFromTop";
    public static final String PROPERTY_FOOTER_POSITION = "footerPosition";
    public static final String PROPERTY_KEEP_TOGETHER = "keepTogether";
    public static final String PROPERTY_PREVENT_ORPHAN_FOOTER = "preventOrphanFooter";
    public static final String PROPERTY_RESET_PAGE_NUMBER = "isResetPageNumber";
    public static final String PROPERTY_REPRINT_HEADER_ON_EACH_PAGE = "isReprintHeaderOnEachPage";
    public static final String PROPERTY_REPRINT_HEADER_ON_EACH_COLUMN = "isReprintHeaderOnEachColumn";
    public static final String PROPERTY_START_NEW_COLUMN = "isStartNewColumn";
    public static final String PROPERTY_START_NEW_PAGE = "isStartNewPage";
    protected String name;
    protected boolean isStartNewColumn;
    protected boolean isStartNewPage;
    protected boolean isResetPageNumber;
    protected boolean isReprintHeaderOnEachPage;
    protected boolean isReprintHeaderOnEachColumn;
    protected int minHeightToStartNewPage;
    protected int minDetailsToStartFromTop;
    protected FooterPositionEnum footerPosition;
    protected boolean keepTogether;
    protected boolean preventOrphanFooter;
    protected JRExpression expression;
    protected JRSection groupHeaderSection;
    protected JRSection groupFooterSection;
    protected JRVariable countVariable;
    private transient JRPropertyChangeSupport eventSupport;

    protected JRBaseGroup() {
    }

    protected JRBaseGroup(JRGroup group, JRBaseObjectFactory factory) {
        factory.put(group, this);
        this.name = group.getName();
        this.isStartNewColumn = group.isStartNewColumn();
        this.isStartNewPage = group.isStartNewPage();
        this.isResetPageNumber = group.isResetPageNumber();
        this.isReprintHeaderOnEachPage = group.isReprintHeaderOnEachPage();
        this.isReprintHeaderOnEachColumn = group.isReprintHeaderOnEachColumn();
        this.minHeightToStartNewPage = group.getMinHeightToStartNewPage();
        this.minDetailsToStartFromTop = group.getMinDetailsToStartFromTop();
        this.footerPosition = group.getFooterPosition();
        this.keepTogether = group.isKeepTogether();
        this.preventOrphanFooter = group.isPreventOrphanFooter();
        this.expression = factory.getExpression(group.getExpression());
        this.groupHeaderSection = factory.getSection(group.getGroupHeaderSection());
        this.groupFooterSection = factory.getSection(group.getGroupFooterSection());
        this.countVariable = factory.getVariable(group.getCountVariable());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isStartNewColumn() {
        return this.isStartNewColumn;
    }

    @Override
    public void setStartNewColumn(boolean isStart) {
        boolean old = this.isStartNewColumn;
        this.isStartNewColumn = isStart;
        this.getEventSupport().firePropertyChange(PROPERTY_START_NEW_COLUMN, old, this.isStartNewColumn);
    }

    @Override
    public boolean isStartNewPage() {
        return this.isStartNewPage;
    }

    @Override
    public void setStartNewPage(boolean isStart) {
        boolean old = this.isStartNewPage;
        this.isStartNewPage = isStart;
        this.getEventSupport().firePropertyChange(PROPERTY_START_NEW_PAGE, old, this.isStartNewPage);
    }

    @Override
    public boolean isResetPageNumber() {
        return this.isResetPageNumber;
    }

    @Override
    public void setResetPageNumber(boolean isReset) {
        boolean old = this.isResetPageNumber;
        this.isResetPageNumber = isReset;
        this.getEventSupport().firePropertyChange(PROPERTY_RESET_PAGE_NUMBER, old, this.isResetPageNumber);
    }

    @Override
    public boolean isReprintHeaderOnEachPage() {
        return this.isReprintHeaderOnEachPage;
    }

    @Override
    public void setReprintHeaderOnEachPage(boolean isReprint) {
        boolean old = this.isReprintHeaderOnEachPage;
        this.isReprintHeaderOnEachPage = isReprint;
        this.getEventSupport().firePropertyChange(PROPERTY_REPRINT_HEADER_ON_EACH_PAGE, old, this.isReprintHeaderOnEachPage);
    }

    @Override
    public boolean isReprintHeaderOnEachColumn() {
        return this.isReprintHeaderOnEachColumn;
    }

    @Override
    public void setReprintHeaderOnEachColumn(boolean isReprint) {
        boolean old = this.isReprintHeaderOnEachColumn;
        this.isReprintHeaderOnEachColumn = isReprint;
        this.getEventSupport().firePropertyChange(PROPERTY_REPRINT_HEADER_ON_EACH_COLUMN, old, this.isReprintHeaderOnEachColumn);
    }

    @Override
    public int getMinHeightToStartNewPage() {
        return this.minHeightToStartNewPage;
    }

    @Override
    public void setMinHeightToStartNewPage(int minHeight) {
        int old = this.minHeightToStartNewPage;
        this.minHeightToStartNewPage = minHeight;
        this.getEventSupport().firePropertyChange(PROPERTY_MIN_HEIGHT_TO_START_NEW_PAGE, old, this.minHeightToStartNewPage);
    }

    @Override
    public int getMinDetailsToStartFromTop() {
        return this.minDetailsToStartFromTop;
    }

    @Override
    public void setMinDetailsToStartFromTop(int minDetails) {
        int old = this.minDetailsToStartFromTop;
        this.minDetailsToStartFromTop = minDetails;
        this.getEventSupport().firePropertyChange(PROPERTY_MIN_DETAILS_TO_START_FROM_TOP, old, this.minDetailsToStartFromTop);
    }

    @Override
    public FooterPositionEnum getFooterPosition() {
        return this.footerPosition;
    }

    @Override
    public void setFooterPosition(FooterPositionEnum footerPosition) {
        FooterPositionEnum old = this.footerPosition;
        this.footerPosition = footerPosition;
        this.getEventSupport().firePropertyChange(PROPERTY_FOOTER_POSITION, old, this.footerPosition);
    }

    @Override
    public boolean isKeepTogether() {
        return this.keepTogether;
    }

    @Override
    public void setKeepTogether(boolean keepTogether) {
        boolean old = this.keepTogether;
        this.keepTogether = keepTogether;
        this.getEventSupport().firePropertyChange(PROPERTY_KEEP_TOGETHER, old, this.keepTogether);
    }

    @Override
    public boolean isPreventOrphanFooter() {
        return this.preventOrphanFooter;
    }

    @Override
    public void setPreventOrphanFooter(boolean preventOrphanFooter) {
        boolean old = this.preventOrphanFooter;
        this.preventOrphanFooter = preventOrphanFooter;
        this.getEventSupport().firePropertyChange(PROPERTY_PREVENT_ORPHAN_FOOTER, old, this.preventOrphanFooter);
    }

    @Override
    public JRExpression getExpression() {
        return this.expression;
    }

    @Override
    @JsonMerge
    public JRSection getGroupHeaderSection() {
        return this.groupHeaderSection;
    }

    @Override
    @JsonMerge
    public JRSection getGroupFooterSection() {
        return this.groupFooterSection;
    }

    @Override
    public JRVariable getCountVariable() {
        return this.countVariable;
    }

    @Override
    public Object clone() {
        return this.clone(null);
    }

    @Override
    public JRBaseGroup clone(CloneStore cloneStore) {
        JRBaseGroup clone = null;
        try {
            clone = (JRBaseGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        if (cloneStore != null) {
            cloneStore.store(this, clone);
        }
        clone.expression = JRCloneUtils.nullSafeClone(this.expression);
        clone.groupHeaderSection = JRCloneUtils.nullSafeClone(this.groupHeaderSection);
        clone.groupFooterSection = JRCloneUtils.nullSafeClone(this.groupFooterSection);
        clone.countVariable = cloneStore == null ? JRCloneUtils.nullSafeClone(this.countVariable) : cloneStore.clone(this.countVariable);
        clone.eventSupport = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        JRBaseGroup jRBaseGroup = this;
        synchronized (jRBaseGroup) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }
}

