/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.design.JRDesignGraphicElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRDesignImage
extends JRDesignGraphicElement
implements JRImage {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_ANCHOR_NAME_EXPRESSION = "anchorNameExpression";
    public static final String PROPERTY_BOOKMARK_LEVEL = "bookmarkLevel";
    public static final String PROPERTY_BOOKMARK_LEVEL_EXPRESSION = "bookmarkLevelExpression";
    public static final String PROPERTY_EVALUATION_GROUP = "evaluationGroup";
    public static final String PROPERTY_EVALUATION_TIME = "evaluationTime";
    public static final String PROPERTY_EXPRESSION = "expression";
    protected ScaleImageEnum scaleImage;
    protected RotationEnum rotation;
    protected HorizontalImageAlignEnum horizontalImageAlign;
    protected VerticalImageAlignEnum verticalImageAlign;
    protected Boolean isUsingCache;
    protected boolean isLazy;
    protected OnErrorTypeEnum onErrorType = OnErrorTypeEnum.ERROR;
    protected EvaluationTimeEnum evaluationTime;
    protected String linkType;
    protected String linkTarget;
    private List<JRHyperlinkParameter> hyperlinkParameters = new ArrayList<JRHyperlinkParameter>();
    protected JRLineBox lineBox = new JRBaseLineBox(this);
    protected String evaluationGroup;
    protected JRExpression expression;
    protected JRExpression anchorNameExpression;
    protected JRExpression bookmarkLevelExpression;
    protected JRExpression hyperlinkReferenceExpression;
    protected JRExpression hyperlinkWhenExpression;
    protected JRExpression hyperlinkAnchorExpression;
    protected JRExpression hyperlinkPageExpression;
    private JRExpression hyperlinkTooltipExpression;
    protected int bookmarkLevel = 0;

    @JsonCreator
    private JRDesignImage() {
        this(JasperDesign.getThreadInstance());
    }

    public JRDesignImage(JRDefaultStyleProvider defaultStyleProvider) {
        super(defaultStyleProvider);
    }

    @Override
    public ModeEnum getMode() {
        return this.getStyleResolver().getMode(this, ModeEnum.TRANSPARENT);
    }

    @Override
    public ScaleImageEnum getScaleImage() {
        return this.getStyleResolver().getScaleImage(this);
    }

    @Override
    public ScaleImageEnum getOwnScaleImage() {
        return this.scaleImage;
    }

    @Override
    public void setScaleImage(ScaleImageEnum scaleImage) {
        ScaleImageEnum old = this.scaleImage;
        this.scaleImage = scaleImage;
        this.getEventSupport().firePropertyChange("scaleImage", old, this.scaleImage);
    }

    @Override
    public RotationEnum getRotation() {
        return this.getStyleResolver().getRotation(this);
    }

    @Override
    public RotationEnum getOwnRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(RotationEnum rotation) {
        RotationEnum old = this.rotation;
        this.rotation = rotation;
        this.getEventSupport().firePropertyChange("rotation", old, this.rotation);
    }

    @Override
    public HorizontalImageAlignEnum getHorizontalImageAlign() {
        return this.getStyleResolver().getHorizontalImageAlign(this);
    }

    @Override
    public HorizontalImageAlignEnum getOwnHorizontalImageAlign() {
        return this.horizontalImageAlign;
    }

    @Override
    public void setHorizontalImageAlign(HorizontalImageAlignEnum horizontalImageAlign) {
        HorizontalImageAlignEnum old = this.horizontalImageAlign;
        this.horizontalImageAlign = horizontalImageAlign;
        this.getEventSupport().firePropertyChange("horizontalImageAlignment", old, this.horizontalImageAlign);
    }

    @Override
    public VerticalImageAlignEnum getVerticalImageAlign() {
        return this.getStyleResolver().getVerticalImageAlign(this);
    }

    @Override
    public VerticalImageAlignEnum getOwnVerticalImageAlign() {
        return this.verticalImageAlign;
    }

    @Override
    public void setVerticalImageAlign(VerticalImageAlignEnum verticalImageAlign) {
        VerticalImageAlignEnum old = this.verticalImageAlign;
        this.verticalImageAlign = verticalImageAlign;
        this.getEventSupport().firePropertyChange("verticalImageAlignment", old, this.verticalImageAlign);
    }

    @Override
    public Boolean getUsingCache() {
        return this.isUsingCache;
    }

    @Override
    public EvaluationTimeEnum getEvaluationTime() {
        return this.evaluationTime;
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    @JsonSetter(value="box")
    private void setLineBox(JRLineBox lineBox) {
        this.lineBox = lineBox == null ? null : lineBox.clone(this);
    }

    @Override
    public HyperlinkTypeEnum getHyperlinkType() {
        return JRHyperlinkHelper.getHyperlinkType(this);
    }

    @Override
    public HyperlinkTargetEnum getHyperlinkTarget() {
        return JRHyperlinkHelper.getHyperlinkTarget(this);
    }

    @Override
    public String getEvaluationGroup() {
        return this.evaluationGroup;
    }

    @Override
    public JRExpression getExpression() {
        return this.expression;
    }

    @Override
    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    @Override
    public JRExpression getBookmarkLevelExpression() {
        return this.bookmarkLevelExpression;
    }

    @Override
    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    @Override
    public JRExpression getHyperlinkWhenExpression() {
        return this.hyperlinkWhenExpression;
    }

    @Override
    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    @Override
    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    @Override
    public void setUsingCache(Boolean isUsingCache) {
        Boolean old = this.isUsingCache;
        this.isUsingCache = isUsingCache;
        this.getEventSupport().firePropertyChange("isUsingCache", old, this.isUsingCache);
    }

    @Override
    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public void setLazy(boolean isLazy) {
        boolean old = this.isLazy;
        this.isLazy = isLazy;
        this.getEventSupport().firePropertyChange("isLazy", old, this.isLazy);
    }

    @Override
    public OnErrorTypeEnum getOnErrorType() {
        return this.onErrorType;
    }

    @Override
    public void setOnErrorType(OnErrorTypeEnum onErrorType) {
        OnErrorTypeEnum old = this.onErrorType;
        this.onErrorType = onErrorType;
        this.getEventSupport().firePropertyChange("onErrorType", old, this.onErrorType);
    }

    public void setEvaluationTime(EvaluationTimeEnum evaluationTime) {
        EvaluationTimeEnum old = this.evaluationTime;
        this.evaluationTime = evaluationTime;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_TIME, old, this.evaluationTime);
    }

    public void setHyperlinkType(HyperlinkTypeEnum hyperlinkType) {
        this.setLinkType(JRHyperlinkHelper.getLinkType(hyperlinkType));
    }

    public void setHyperlinkTarget(HyperlinkTargetEnum hyperlinkTarget) {
        this.setLinkTarget(JRHyperlinkHelper.getLinkTarget(hyperlinkTarget));
    }

    public void setEvaluationGroup(String evaluationGroup) {
        String old = this.evaluationGroup;
        this.evaluationGroup = evaluationGroup;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_GROUP, old, this.evaluationGroup);
    }

    public void setExpression(JRExpression expression) {
        JRExpression old = this.expression;
        this.expression = expression;
        this.getEventSupport().firePropertyChange(PROPERTY_EXPRESSION, old, this.expression);
    }

    public void setAnchorNameExpression(JRExpression anchorNameExpression) {
        JRExpression old = this.anchorNameExpression;
        this.anchorNameExpression = anchorNameExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_ANCHOR_NAME_EXPRESSION, old, this.anchorNameExpression);
    }

    public void setBookmarkLevelExpression(JRExpression bookmarkLevelExpression) {
        JRExpression old = this.bookmarkLevelExpression;
        this.bookmarkLevelExpression = bookmarkLevelExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_BOOKMARK_LEVEL_EXPRESSION, old, this.bookmarkLevelExpression);
    }

    public void setHyperlinkReferenceExpression(JRExpression hyperlinkReferenceExpression) {
        JRExpression old = this.hyperlinkReferenceExpression;
        this.hyperlinkReferenceExpression = hyperlinkReferenceExpression;
        this.getEventSupport().firePropertyChange("hyperlinkReferenceExpression", old, this.hyperlinkReferenceExpression);
    }

    public void setHyperlinkWhenExpression(JRExpression hyperlinkWhenExpression) {
        JRExpression old = this.hyperlinkWhenExpression;
        this.hyperlinkWhenExpression = hyperlinkWhenExpression;
        this.getEventSupport().firePropertyChange("hyperlinkWhenExpression", old, this.hyperlinkWhenExpression);
    }

    public void setHyperlinkAnchorExpression(JRExpression hyperlinkAnchorExpression) {
        JRExpression old = this.hyperlinkAnchorExpression;
        this.hyperlinkAnchorExpression = hyperlinkAnchorExpression;
        this.getEventSupport().firePropertyChange("hyperlinkAnchorExpression", old, this.hyperlinkAnchorExpression);
    }

    public void setHyperlinkPageExpression(JRExpression hyperlinkPageExpression) {
        JRExpression old = this.hyperlinkPageExpression;
        this.hyperlinkPageExpression = hyperlinkPageExpression;
        this.getEventSupport().firePropertyChange("hyperlinkPageExpression", old, this.hyperlinkPageExpression);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitImage(this);
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public void setBookmarkLevel(int bookmarkLevel) {
        int old = this.bookmarkLevel;
        this.bookmarkLevel = bookmarkLevel;
        this.getEventSupport().firePropertyChange(PROPERTY_BOOKMARK_LEVEL, old, this.bookmarkLevel);
    }

    @Override
    public Float getDefaultLineWidth() {
        return JRPen.LINE_WIDTH_0;
    }

    @Override
    public String getLinkType() {
        return this.linkType;
    }

    @Override
    public String getLinkTarget() {
        return this.linkTarget;
    }

    public void setLinkType(String type) {
        String old = this.linkType;
        this.linkType = type;
        this.getEventSupport().firePropertyChange("hyperlinkType", old, this.linkType);
    }

    public void setLinkTarget(String target) {
        String old = this.linkTarget;
        this.linkTarget = target;
        this.getEventSupport().firePropertyChange("linkTarget", old, this.linkTarget);
    }

    @Override
    public JRHyperlinkParameter[] getHyperlinkParameters() {
        JRHyperlinkParameter[] parameters;
        if (this.hyperlinkParameters.isEmpty()) {
            parameters = null;
        } else {
            parameters = new JRHyperlinkParameter[this.hyperlinkParameters.size()];
            this.hyperlinkParameters.toArray(parameters);
        }
        return parameters;
    }

    @JsonSetter
    private void setHyperlinkParameters(List<JRHyperlinkParameter> parameters) {
        if (parameters != null) {
            for (JRHyperlinkParameter parameter : parameters) {
                this.addHyperlinkParameter(parameter);
            }
        }
    }

    @JsonIgnore
    public List<JRHyperlinkParameter> getHyperlinkParametersList() {
        return this.hyperlinkParameters;
    }

    public void addHyperlinkParameter(JRHyperlinkParameter parameter) {
        this.hyperlinkParameters.add(parameter);
        this.getEventSupport().fireCollectionElementAddedEvent("hyperlinkParameters", parameter, this.hyperlinkParameters.size() - 1);
    }

    public void removeHyperlinkParameter(JRHyperlinkParameter parameter) {
        int idx = this.hyperlinkParameters.indexOf(parameter);
        if (idx >= 0) {
            this.hyperlinkParameters.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent("hyperlinkParameters", parameter, idx);
        }
    }

    public void removeHyperlinkParameter(String parameterName) {
        ListIterator<JRHyperlinkParameter> it = this.hyperlinkParameters.listIterator();
        while (it.hasNext()) {
            JRHyperlinkParameter parameter = it.next();
            if (parameter.getName() == null || !parameter.getName().equals(parameterName)) continue;
            it.remove();
            this.getEventSupport().fireCollectionElementRemovedEvent("hyperlinkParameters", parameter, it.nextIndex());
        }
    }

    @Override
    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    public void setHyperlinkTooltipExpression(JRExpression hyperlinkTooltipExpression) {
        JRExpression old = this.hyperlinkTooltipExpression;
        this.hyperlinkTooltipExpression = hyperlinkTooltipExpression;
        this.getEventSupport().firePropertyChange("hyperlinkTooltipExpression", old, this.hyperlinkTooltipExpression);
    }

    @Override
    public Object clone() {
        JRDesignImage clone = (JRDesignImage)super.clone();
        clone.lineBox = this.lineBox.clone(clone);
        clone.hyperlinkParameters = JRCloneUtils.cloneList(this.hyperlinkParameters);
        clone.expression = JRCloneUtils.nullSafeClone(this.expression);
        clone.anchorNameExpression = JRCloneUtils.nullSafeClone(this.anchorNameExpression);
        clone.bookmarkLevelExpression = JRCloneUtils.nullSafeClone(this.bookmarkLevelExpression);
        clone.hyperlinkReferenceExpression = JRCloneUtils.nullSafeClone(this.hyperlinkReferenceExpression);
        clone.hyperlinkWhenExpression = JRCloneUtils.nullSafeClone(this.hyperlinkWhenExpression);
        clone.hyperlinkAnchorExpression = JRCloneUtils.nullSafeClone(this.hyperlinkAnchorExpression);
        clone.hyperlinkPageExpression = JRCloneUtils.nullSafeClone(this.hyperlinkPageExpression);
        clone.hyperlinkTooltipExpression = JRCloneUtils.nullSafeClone(this.hyperlinkTooltipExpression);
        return clone;
    }
}

