/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRComparableIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRDefaultIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRShortAverageIncrementer;
import net.sf.jasperreports.engine.fill.JRShortCountIncrementer;
import net.sf.jasperreports.engine.fill.JRShortDistinctCountIncrementer;
import net.sf.jasperreports.engine.fill.JRShortStandardDeviationIncrementer;
import net.sf.jasperreports.engine.fill.JRShortSumIncrementer;
import net.sf.jasperreports.engine.fill.JRShortVarianceIncrementer;
import net.sf.jasperreports.engine.type.CalculationEnum;

public final class JRShortIncrementerFactory
extends JRAbstractExtendedIncrementerFactory {
    protected static final Short ZERO = 0;
    private static JRShortIncrementerFactory mainInstance = new JRShortIncrementerFactory();

    private JRShortIncrementerFactory() {
    }

    public static JRShortIncrementerFactory getInstance() {
        return mainInstance;
    }

    @Override
    public JRExtendedIncrementer getExtendedIncrementer(CalculationEnum calculation) {
        JRExtendedIncrementer incrementer = null;
        switch (calculation) {
            case COUNT: {
                incrementer = JRShortCountIncrementer.getInstance();
                break;
            }
            case SUM: {
                incrementer = JRShortSumIncrementer.getInstance();
                break;
            }
            case AVERAGE: {
                incrementer = JRShortAverageIncrementer.getInstance();
                break;
            }
            case LOWEST: 
            case HIGHEST: {
                incrementer = JRComparableIncrementerFactory.getInstance().getExtendedIncrementer(calculation);
                break;
            }
            case STANDARD_DEVIATION: {
                incrementer = JRShortStandardDeviationIncrementer.getInstance();
                break;
            }
            case VARIANCE: {
                incrementer = JRShortVarianceIncrementer.getInstance();
                break;
            }
            case DISTINCT_COUNT: {
                incrementer = JRShortDistinctCountIncrementer.getInstance();
                break;
            }
            default: {
                incrementer = JRDefaultIncrementerFactory.getInstance().getExtendedIncrementer(calculation);
            }
        }
        return incrementer;
    }
}

