/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.virtualization;

import java.io.IOException;
import java.sql.Timestamp;
import net.sf.jasperreports.engine.virtualization.ObjectSerializer;
import net.sf.jasperreports.engine.virtualization.ReferenceType;
import net.sf.jasperreports.engine.virtualization.VirtualizationInput;
import net.sf.jasperreports.engine.virtualization.VirtualizationOutput;

public class TimestampSerializer
implements ObjectSerializer<Timestamp> {
    @Override
    public int typeValue() {
        return 29;
    }

    @Override
    public ReferenceType defaultReferenceType() {
        return ReferenceType.OBJECT;
    }

    @Override
    public boolean defaultStoreReference() {
        return true;
    }

    @Override
    public void write(Timestamp value, VirtualizationOutput out) throws IOException {
        out.writeLong(value.getTime());
        out.writeIntCompressed(value.getNanos());
    }

    @Override
    public Timestamp read(VirtualizationInput in) throws IOException {
        long time = in.readLong();
        int nanos = in.readIntCompressed();
        Timestamp timestamp = new Timestamp(time);
        timestamp.setNanos(nanos);
        return timestamp;
    }
}

