/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.impl.resource.domain;

import com.okta.commons.http.HttpHeaders;
import com.okta.commons.lang.Assert;
import com.okta.sdk.impl.ds.InternalDataStore;
import com.okta.sdk.impl.resource.AbstractInstanceResource;
import com.okta.sdk.impl.resource.EnumProperty;
import com.okta.sdk.impl.resource.Property;
import com.okta.sdk.impl.resource.StringProperty;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.domain.DomainCertificate;
import com.okta.sdk.resource.domain.DomainCertificateType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultDomainCertificate
extends AbstractInstanceResource<DomainCertificate>
implements DomainCertificate {
    private static final StringProperty certificateProperty = new StringProperty("certificate");
    private static final StringProperty certificateChainProperty = new StringProperty("certificateChain");
    private static final StringProperty privateKeyProperty = new StringProperty("privateKey");
    private static final EnumProperty<DomainCertificateType> typeProperty = new EnumProperty<DomainCertificateType>("type", DomainCertificateType.class);
    private static final Map<String, Property> PROPERTY_DESCRIPTORS = DefaultDomainCertificate.createPropertyDescriptorMap(certificateProperty, certificateChainProperty, privateKeyProperty, typeProperty);

    public DefaultDomainCertificate(InternalDataStore dataStore) {
        super(dataStore);
    }

    public DefaultDomainCertificate(InternalDataStore dataStore, Map<String, Object> properties) {
        super(dataStore, properties);
    }

    @Override
    public Map<String, Property> getPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Class<? extends Resource> getResourceClass() {
        return DomainCertificate.class;
    }

    public String getCertificate() {
        return this.getString(certificateProperty);
    }

    public DomainCertificate setCertificate(String certificate) {
        this.setProperty(certificateProperty, (Object)certificate);
        return this;
    }

    public String getCertificateChain() {
        return this.getString(certificateChainProperty);
    }

    public DomainCertificate setCertificateChain(String certificateChain) {
        this.setProperty(certificateChainProperty, (Object)certificateChain);
        return this;
    }

    public String getPrivateKey() {
        return this.getString(privateKeyProperty);
    }

    public DomainCertificate setPrivateKey(String privateKey) {
        this.setProperty(privateKeyProperty, (Object)privateKey);
        return this;
    }

    public DomainCertificateType getType() {
        return this.getEnumProperty(typeProperty);
    }

    public DomainCertificate setType(DomainCertificateType type) {
        this.setProperty(typeProperty, (Object)type);
        return this;
    }

    public void createCertificate(String domainId) {
        Assert.hasText((String)domainId, (String)"'domainId' is required and cannot be null or empty.");
        HashMap<String, Object> queryArgs = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        String href = "/api/v1/domains/" + domainId + "/certificate";
        this.getDataStore().save(href, this, null, queryArgs, (Map<String, List<String>>)headers);
    }
}

