/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Optional;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.CRC32;
import org.identityconnectors.common.StringUtil;

public final class IOUtil {
    private IOUtil() {
        throw new AssertionError();
    }

    public static void quietClose(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void quietClose(InputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void quietClose(Writer writer) {
        try {
            if (writer != null) {
                writer.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void quietClose(OutputStream stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void quietClose(Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void quietClose(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void quietClose(ResultSet resultset) {
        try {
            if (resultset != null) {
                resultset.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static String getResourcePath(Class<?> c, String res) {
        Object result;
        assert (c != null && StringUtil.isNotBlank(res));
        String classname = c.getName();
        int dot = classname.lastIndexOf(46);
        if (dot >= 0) {
            String pkg = classname.substring(0, dot);
            result = pkg.replace('.', '/') + "/" + res;
        } else {
            result = res;
        }
        return result;
    }

    public static InputStream getResourceAsStream(Class<?> clazz, String res) {
        assert (clazz != null && StringUtil.isNotBlank(res));
        InputStream ret = null;
        ClassLoader classLoader = clazz.getClassLoader();
        String[] name = new String[]{res, IOUtil.getResourcePath(clazz, res), "/" + IOUtil.getResourcePath(clazz, res)};
        for (int i = 0; ret == null && i < name.length; ++i) {
            ret = classLoader.getResourceAsStream(name[i]);
        }
        return ret;
    }

    public static byte[] getResourceAsBytes(Class<?> clazz, String res) {
        assert (clazz != null && StringUtil.isNotBlank(res));
        InputStream ins = IOUtil.getResourceAsStream(clazz, res);
        if (ins == null) {
            throw new IllegalStateException("Resource not found: " + res);
        }
        byte[] ret = IOUtil.inputStreamToBytes(ins);
        IOUtil.quietClose(ins);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResourceAsString(Class<?> clazz, String res, Charset charset) {
        assert (clazz != null && StringUtil.isNotBlank(res));
        String ret = null;
        InputStream ins = IOUtil.getResourceAsStream(clazz, res);
        if (ins != null) {
            try {
                InputStreamReader rdr = new InputStreamReader(ins, charset);
                ret = IOUtil.readerToString(rdr);
            }
            finally {
                IOUtil.quietClose(ins);
            }
        }
        return ret;
    }

    public static String getResourceAsString(Class<?> clazz, String res) {
        assert (clazz != null && StringUtil.isNotBlank(res));
        return IOUtil.getResourceAsString(clazz, res, Charset.forName("UTF-8"));
    }

    public static byte[] inputStreamToBytes(InputStream ins) {
        byte[] ret = null;
        try {
            int len;
            byte[] buf = new byte[2048];
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((len = ins.read(buf)) != -1) {
                out.write(buf, 0, len);
            }
            ret = out.toByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    public static String readerToString(Reader rdr) {
        String ret = null;
        try {
            int len;
            char[] buf = new char[2048];
            StringWriter wrt = new StringWriter();
            while ((len = rdr.read(buf)) != -1) {
                wrt.write(buf, 0, len);
            }
            ret = wrt.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    public static boolean copyFile(File src, File dest) throws IOException {
        boolean ret;
        if (src == null || dest == null || !src.isFile()) {
            throw new FileNotFoundException();
        }
        Path dst = dest.toPath();
        if (dest.isDirectory()) {
            dst = dst.resolve(src.getName());
        }
        try (InputStream fis = Files.newInputStream(src.toPath(), new OpenOption[0]);
             OutputStream fout = Files.newOutputStream(dst, new OpenOption[0]);){
            ret = IOUtil.copyFile(fis, fout) > 0L;
        }
        return ret;
    }

    public static long copyFile(InputStream fis, OutputStream fos) throws IOException {
        long ret = 0L;
        byte[] bytes = new byte[8192];
        int rd = fis.read(bytes);
        while (rd != -1) {
            fos.write(bytes, 0, rd);
            ret += (long)rd;
            rd = fis.read(bytes);
        }
        return ret;
    }

    public static long checksum(String fileName) throws IOException, FileNotFoundException {
        return IOUtil.checksum(Path.of(fileName, new String[0]));
    }

    public static long checksum(Path file) throws IOException, FileNotFoundException {
        byte[] bytes = new byte[16384];
        try (InputStream fis = Files.newInputStream(file, new OpenOption[0]);){
            CRC32 chkSum = new CRC32();
            int len = fis.read(bytes);
            while (len != -1) {
                chkSum.update(bytes, 0, len);
                len = fis.read(bytes);
            }
            long l = chkSum.getValue();
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readInputStreamBytes(InputStream is, boolean close) throws IOException {
        byte[] bytes = null;
        if (is != null) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
            try {
                int bytesRead = 0;
                byte[] buf = new byte[1024];
                while ((bytesRead = is.read(buf)) != -1) {
                    bout.write(buf, 0, bytesRead);
                }
                bytes = bout.toByteArray();
            }
            finally {
                if (close) {
                    IOUtil.quietClose(is);
                }
            }
        }
        return bytes;
    }

    public static void delete(File file) throws IOException {
        if (file.exists()) {
            String msg = "Failed to delete: " + file;
            if (file.isDirectory()) {
                File[] fs = file.listFiles();
                for (int x = 0; x < fs.length; ++x) {
                    IOUtil.delete(fs[x]);
                }
                if (!file.delete()) {
                    throw new IOException(msg);
                }
            } else if (file.isFile() && !file.delete()) {
                throw new IOException(msg);
            }
        }
    }

    public static Properties loadPropertiesFile(Path file) throws IOException {
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            Properties rv = new Properties();
            rv.load(in);
            Properties properties = rv;
            return properties;
        }
    }

    public static void storePropertiesFile(Path file, Properties properties) throws IOException {
        try (OutputStream out = Files.newOutputStream(file, new OpenOption[0]);){
            properties.store(out, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getResourceAsProperties(ClassLoader loader, String path) throws IOException {
        InputStream in = loader.getResourceAsStream(path);
        if (in == null) {
            return null;
        }
        try {
            Properties rv = new Properties();
            rv.load(in);
            Properties properties = rv;
            return properties;
        }
        finally {
            in.close();
        }
    }

    public static void extractResourceToFile(Class<?> clazz, String path, Path file) throws IOException {
        try (InputStream in = Optional.ofNullable(IOUtil.getResourceAsStream(clazz, path)).orElseThrow(() -> new IOException("Missing resource: " + path));
             OutputStream out = Files.newOutputStream(file, new OpenOption[0]);){
            IOUtil.copyFile(in, out);
        }
    }

    public static void unjar(JarFile jarFile, Path toDir) throws IOException {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            Path outFile = toDir.resolve(entry.getName());
            InputStream in = jarFile.getInputStream(entry);
            try {
                OutputStream fos = Files.newOutputStream(outFile, new OpenOption[0]);
                try {
                    IOUtil.copyFile(in, fos);
                }
                finally {
                    if (fos == null) continue;
                    fos.close();
                }
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
    }

    public static String readFileUTF8(Path file) throws IOException {
        byte[] bytes = IOUtil.readFileBytes(file);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static byte[] readFileBytes(Path file) throws IOException {
        return IOUtil.readInputStreamBytes(Files.newInputStream(file, new OpenOption[0]), true);
    }

    public static void writeFileUTF8(Path file, String contents) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(contents);
        }
    }

    public static URL makeURL(Path dir, String path) throws IOException {
        File file = dir.resolve(path).toFile();
        if (!file.isFile()) {
            throw new IOException(file.getPath() + " does not exist");
        }
        return file.toURI().toURL();
    }

    public static Properties loadPropertiesFile(String string) throws IOException {
        return IOUtil.loadPropertiesFile(Path.of(string, new String[0]));
    }
}

