/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.url;

import org.ldaptive.LdapUtils;
import org.ldaptive.SearchScope;
import org.ldaptive.dn.Dn;
import org.ldaptive.filter.Filter;
import org.ldaptive.url.Url;
import org.ldaptive.url.UrlFormatter;

public abstract class AbstractUrlFormatter
implements UrlFormatter {
    @Override
    public String format(Url url) {
        StringBuilder sb = new StringBuilder(this.formatScheme(url.getScheme())).append("://");
        String hostname = this.formatHostname(url.getHostname());
        if (hostname != null) {
            if (hostname.contains(":")) {
                sb.append('[').append(hostname).append(']');
            } else {
                sb.append(hostname);
            }
        }
        if (!"ldapi".equals(url.getScheme())) {
            sb.append(':').append(url.getPort());
        }
        sb.append('/').append(LdapUtils.percentEncode(this.formatBaseDn(url.getBaseDn(), url.getParsedBaseDn()))).append('?');
        String[] attrs = url.getAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            sb.append(this.formatAttribute(attrs[i]));
            if (i + 1 >= attrs.length) continue;
            sb.append(',');
        }
        sb.append('?');
        SearchScope scope = url.getScope();
        if (SearchScope.OBJECT == scope) {
            sb.append("base");
        } else if (SearchScope.ONELEVEL == scope) {
            sb.append("one");
        } else if (SearchScope.SUBTREE == scope) {
            sb.append("sub");
        } else if (SearchScope.SUBORDINATE == scope) {
            sb.append("subordinates");
        }
        sb.append('?').append(LdapUtils.percentEncode(this.formatFilter(url.getFilter(), url.getParsedFilter())));
        return sb.toString();
    }

    protected abstract String formatScheme(String var1);

    protected abstract String formatHostname(String var1);

    protected abstract String formatBaseDn(String var1, Dn var2);

    protected abstract String formatAttribute(String var1);

    protected abstract String formatFilter(String var1, Filter var2);
}

