/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.api.ConnectorFacade;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeDelta;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.FilterBuilder;
import org.identityconnectors.framework.spi.SearchResultsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;

public class AsyncConnectorFacade {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncConnectorFacade.class);

    @Async
    public Future<Uid> authenticate(ConnectorFacade connector, String username, GuardedString password, OperationOptions options) {
        return CompletableFuture.completedFuture(connector.authenticate(ObjectClass.ACCOUNT, username, password, options));
    }

    @Async
    public Future<Uid> create(ConnectorFacade connector, ObjectClass objectClass, Set<Attribute> attrs, OperationOptions options) {
        return CompletableFuture.completedFuture(connector.create(objectClass, attrs, options));
    }

    @Async
    public Future<Uid> update(ConnectorFacade connector, ObjectClass objectClass, Uid uid, Set<Attribute> attrs, OperationOptions options) {
        return CompletableFuture.completedFuture(connector.update(objectClass, uid, attrs, options));
    }

    @Async
    public Future<Set<AttributeDelta>> updateDelta(ConnectorFacade connector, ObjectClass objectClass, Uid uid, Set<AttributeDelta> modifications, OperationOptions options) {
        return CompletableFuture.completedFuture(connector.updateDelta(objectClass, uid, modifications, options));
    }

    @Async
    public Future<Uid> delete(ConnectorFacade connector, ObjectClass objectClass, Uid uid, OperationOptions options) {
        connector.delete(objectClass, uid, options);
        return CompletableFuture.completedFuture(uid);
    }

    @Async
    public Future<SyncToken> getLatestSyncToken(ConnectorFacade connector, ObjectClass objectClass) {
        return CompletableFuture.completedFuture(connector.getLatestSyncToken(objectClass));
    }

    @Async
    public Future<ConnectorObject> getObject(ConnectorFacade connector, ObjectClass objectClass, Attribute connObjectKey, boolean ignoreCaseMatch, OperationOptions options) {
        final ConnectorObject[] objects = new ConnectorObject[1];
        connector.search(objectClass, ignoreCaseMatch ? FilterBuilder.equalsIgnoreCase((Attribute)connObjectKey) : FilterBuilder.equalTo((Attribute)connObjectKey), (ResultsHandler)new SearchResultsHandler(){

            public boolean handle(ConnectorObject connectorObject) {
                objects[0] = connectorObject;
                return false;
            }

            public void handleResult(SearchResult sr) {
            }
        }, options);
        return CompletableFuture.completedFuture(objects[0]);
    }

    @Async
    public Future<Set<ObjectClassInfo>> getObjectClassInfo(ConnectorFacade connector) {
        Set result = Set.of();
        try {
            result = connector.schema().getObjectClassInfo();
        }
        catch (Exception e) {
            LOG.debug("While reading schema on connector {}", (Object)connector, (Object)e);
        }
        return CompletableFuture.completedFuture(result);
    }

    @Async
    public Future<String> validate(ConnectorFacade connector) {
        connector.validate();
        return CompletableFuture.completedFuture("OK");
    }

    @Async
    public Future<String> test(ConnectorFacade connector) {
        connector.test();
        return CompletableFuture.completedFuture("OK");
    }
}

