/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyObjectCR;
import org.apache.syncope.common.lib.request.AnyObjectUR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.AttrPatch;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.ConnObject;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.RelationshipTypeDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Groupable;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.anyobject.AMembership;
import org.apache.syncope.core.persistence.api.entity.anyobject.ARelationship;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.data.AnyObjectDataBinder;
import org.apache.syncope.core.provisioning.java.data.AnyDataBinder;
import org.apache.syncope.core.provisioning.java.pushpull.OutboundMatcher;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public class AnyObjectDataBinderImpl
extends AnyDataBinder
implements AnyObjectDataBinder {
    public AnyObjectDataBinderImpl(AnyTypeDAO anyTypeDAO, RealmSearchDAO realmSearchDAO, AnyTypeClassDAO anyTypeClassDAO, AnyObjectDAO anyObjectDAO, UserDAO userDAO, GroupDAO groupDAO, PlainSchemaDAO plainSchemaDAO, ExternalResourceDAO resourceDAO, RelationshipTypeDAO relationshipTypeDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, DerAttrHandler derAttrHandler, MappingManager mappingManager, IntAttrNameParser intAttrNameParser, OutboundMatcher outboundMatcher, PlainAttrValidationManager validator) {
        super(anyTypeDAO, realmSearchDAO, anyTypeClassDAO, anyObjectDAO, userDAO, groupDAO, plainSchemaDAO, resourceDAO, relationshipTypeDAO, entityFactory, anyUtilsFactory, derAttrHandler, mappingManager, intAttrNameParser, outboundMatcher, validator);
    }

    @Transactional(readOnly=true)
    public AnyObjectTO getAnyObjectTO(String key) {
        return this.getAnyObjectTO((AnyObject)this.anyObjectDAO.authFind(key), true);
    }

    @Transactional(readOnly=true)
    public AnyObjectTO getAnyObjectTO(AnyObject anyObject, boolean details) {
        AnyObjectTO anyObjectTO = new AnyObjectTO();
        anyObjectTO.setType(anyObject.getType().getKey());
        anyObjectTO.setKey(anyObject.getKey());
        anyObjectTO.setName(anyObject.getName());
        anyObjectTO.setStatus(anyObject.getStatus());
        anyObjectTO.setCreator(anyObject.getCreator());
        anyObjectTO.setCreationDate(anyObject.getCreationDate());
        anyObjectTO.setCreationContext(anyObject.getCreationContext());
        anyObjectTO.setLastModifier(anyObject.getLastModifier());
        anyObjectTO.setLastChangeDate(anyObject.getLastChangeDate());
        anyObjectTO.setLastChangeContext(anyObject.getLastChangeContext());
        AnyObjectDataBinderImpl.fillTO((AnyTO)anyObjectTO, anyObject.getRealm().getFullPath(), anyObject.getAuxClasses(), anyObject.getPlainAttrs(), this.derAttrHandler.getValues((Any)anyObject), this.anyObjectDAO.findAllResources(anyObject));
        anyObjectTO.getDynRealms().addAll(this.anyObjectDAO.findDynRealms(anyObject.getKey()));
        if (details) {
            anyObjectTO.getRelationships().addAll(this.anyObjectDAO.findAllRelationships(anyObject).stream().map(r -> AnyObjectDataBinderImpl.getRelationshipTO(r.getType().getKey(), r.getLeftEnd().getKey().equals(anyObject.getKey()) ? RelationshipTO.End.LEFT : RelationshipTO.End.RIGHT, r.getLeftEnd().getKey().equals(anyObject.getKey()) ? r.getRightEnd() : r.getLeftEnd())).toList());
            anyObjectTO.getMemberships().addAll(anyObject.getMemberships().stream().map(membership -> AnyObjectDataBinderImpl.getMembershipTO(anyObject.getPlainAttrs((Membership)membership), this.derAttrHandler.getValues((Groupable)anyObject, (Membership)membership), (Membership<? extends Any>)membership)).toList());
            anyObjectTO.getDynMemberships().addAll(this.anyObjectDAO.findDynGroups(anyObject.getKey()).stream().map(group -> new MembershipTO.Builder(group.getKey()).groupName(group.getName()).build()).toList());
        }
        return anyObjectTO;
    }

    public void create(AnyObject anyObject, AnyObjectCR anyObjectCR) {
        AnyType type = (AnyType)this.anyTypeDAO.findById(anyObjectCR.getType()).orElseThrow(() -> {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAnyType);
            sce.getElements().add(anyObjectCR.getType());
            return sce;
        });
        anyObject.setType(type);
        AnyObjectTO anyTO = new AnyObjectTO();
        EntityTOUtils.toAnyTO((AnyCR)anyObjectCR, (AnyTO)anyTO);
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        SyncopeClientException invalidGroups = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidGroup);
        if (anyObjectCR.getName() == null) {
            LOG.error("No name specified for this anyObject");
            invalidGroups.getElements().add("No name specified for this anyObject");
        } else {
            anyObject.setName(anyObjectCR.getName());
        }
        Realm realm = this.realmSearchDAO.findByFullPath(anyObjectCR.getRealm()).orElse(null);
        if (realm == null) {
            SyncopeClientException noRealm = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
            noRealm.getElements().add("Invalid or null realm specified: " + anyObjectCR.getRealm());
            scce.addException(noRealm);
        }
        anyObject.setRealm(realm);
        HashSet relationships = new HashSet();
        anyObjectCR.getRelationships().forEach(relationshipTO -> {
            if (StringUtils.isBlank((CharSequence)relationshipTO.getOtherEndType()) || AnyTypeKind.USER.name().equals(relationshipTO.getOtherEndType()) || AnyTypeKind.GROUP.name().equals(relationshipTO.getOtherEndType())) {
                SyncopeClientException invalidAnyType = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAnyType);
                invalidAnyType.getElements().add(AnyType.class.getSimpleName() + " not allowed for relationship: " + relationshipTO.getOtherEndType());
                scce.addException(invalidAnyType);
            } else {
                AnyObject otherEnd = this.anyObjectDAO.findById(relationshipTO.getOtherEndKey()).orElse(null);
                if (otherEnd == null) {
                    LOG.debug("Ignoring invalid anyObject {}", (Object)relationshipTO.getOtherEndKey());
                } else if (relationshipTO.getEnd() == RelationshipTO.End.RIGHT) {
                    SyncopeClientException noRight = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                    noRight.getElements().add("Relationships shall be created or updated only from their left end");
                    scce.addException(noRight);
                } else if (relationships.contains(Pair.of((Object)otherEnd.getKey(), (Object)relationshipTO.getType()))) {
                    SyncopeClientException assigned = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                    assigned.getElements().add("AnyObject was already in relationship " + relationshipTO.getType() + " with " + otherEnd.getType().getKey() + " " + otherEnd.getName());
                    scce.addException(assigned);
                } else {
                    relationships.add(Pair.of((Object)otherEnd.getKey(), (Object)relationshipTO.getType()));
                    this.relationshipTypeDAO.findById(relationshipTO.getType()).ifPresentOrElse(relationshipType -> {
                        ARelationship relationship = (ARelationship)this.entityFactory.newEntity(ARelationship.class);
                        relationship.setType(relationshipType);
                        relationship.setRightEnd((Any)otherEnd);
                        relationship.setLeftEnd((Any)anyObject);
                        anyObject.add((Relationship)relationship);
                    }, () -> LOG.debug("Ignoring invalid relationship type {}", (Object)relationshipTO.getType()));
                }
            }
        });
        HashSet groups = new HashSet();
        anyObjectCR.getMemberships().forEach(membershipTO -> {
            Group group;
            Group group2 = group = membershipTO.getGroupKey() == null ? (Group)this.groupDAO.findByName(membershipTO.getGroupName()).orElse(null) : (Group)this.groupDAO.findById(membershipTO.getGroupKey()).orElse(null);
            if (group == null) {
                LOG.debug("Ignoring invalid group {} / {}", (Object)membershipTO.getGroupKey(), (Object)membershipTO.getGroupName());
            } else if (groups.contains(group.getKey())) {
                LOG.error("{} was already assigned to {}", (Object)group, (Object)anyObject);
                SyncopeClientException assigned = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMembership);
                assigned.getElements().add("Group " + group.getName() + " was already assigned");
                scce.addException(assigned);
            } else {
                groups.add(group.getKey());
                AMembership membership = (AMembership)this.entityFactory.newEntity(AMembership.class);
                membership.setRightEnd((Any)group);
                membership.setLeftEnd((Any)anyObject);
                anyObject.add((Membership)membership);
                this.fill((AnyTO)anyTO, (Any)anyObject, (Membership<?>)membership, (MembershipTO)membershipTO, scce);
            }
        });
        this.fill((AnyTO)anyTO, (Any)anyObject, (AnyCR)anyObjectCR, this.anyUtilsFactory.getInstance(AnyTypeKind.ANY_OBJECT), scce);
        if (scce.hasExceptions()) {
            throw scce;
        }
    }

    public PropagationByResource<String> update(AnyObject toBeUpdated, AnyObjectUR anyObjectUR) {
        AnyObject anyObject = (AnyObject)this.anyObjectDAO.save((Entity)toBeUpdated);
        AnyObjectTO anyTO = AnyOperations.patch((AnyObjectTO)this.getAnyObjectTO(anyObject, true), (AnyObjectUR)anyObjectUR);
        PropagationByResource propByRes = new PropagationByResource();
        Map<String, ConnObject> beforeOnResources = this.onResources((Any)anyObject, this.anyObjectDAO.findAllResourceKeys(anyObject.getKey()), null, Set.of());
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(AnyTypeKind.ANY_OBJECT);
        this.setRealm((Any)anyObject, (AnyUR)anyObjectUR);
        if (anyObjectUR.getName() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)anyObjectUR.getName().getValue()))) {
            anyObject.setName((String)anyObjectUR.getName().getValue());
        }
        this.fill((AnyTO)anyTO, (Any)anyObject, (AnyUR)anyObjectUR, anyUtils, scce);
        HashSet relationships = new HashSet();
        anyObjectUR.getRelationships().stream().filter(patch -> patch.getRelationshipTO() != null).forEach(patch -> {
            RelationshipType relationshipType = this.relationshipTypeDAO.findById(patch.getRelationshipTO().getType()).orElse(null);
            if (relationshipType == null) {
                LOG.debug("Ignoring invalid relationship type {}", (Object)patch.getRelationshipTO().getType());
            } else {
                anyObject.getRelationship(relationshipType, patch.getRelationshipTO().getOtherEndKey()).ifPresent(relationship -> {
                    anyObject.getRelationships().remove(relationship);
                    relationship.setLeftEnd(null);
                });
                if (patch.getOperation() == PatchOperation.ADD_REPLACE) {
                    if (StringUtils.isBlank((CharSequence)patch.getRelationshipTO().getOtherEndType()) || AnyTypeKind.USER.name().equals(patch.getRelationshipTO().getOtherEndType()) || AnyTypeKind.GROUP.name().equals(patch.getRelationshipTO().getOtherEndType())) {
                        SyncopeClientException invalidAnyType = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAnyType);
                        invalidAnyType.getElements().add(AnyType.class.getSimpleName() + " not allowed for relationship: " + patch.getRelationshipTO().getOtherEndType());
                        scce.addException(invalidAnyType);
                    } else {
                        AnyObject otherEnd = this.anyObjectDAO.findById(patch.getRelationshipTO().getOtherEndKey()).orElse(null);
                        if (otherEnd == null) {
                            LOG.debug("Ignoring invalid any object {}", (Object)patch.getRelationshipTO().getOtherEndKey());
                        } else if (patch.getRelationshipTO().getEnd() == RelationshipTO.End.RIGHT) {
                            SyncopeClientException noRight = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                            noRight.getElements().add("Relationships shall be created or updated only from their left end");
                            scce.addException(noRight);
                        } else if (relationships.contains(Pair.of((Object)otherEnd.getKey(), (Object)patch.getRelationshipTO().getType()))) {
                            SyncopeClientException assigned = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                            assigned.getElements().add("AnyObject was already in relationship " + patch.getRelationshipTO().getType() + " with " + otherEnd.getType().getKey() + " " + otherEnd.getName());
                            scce.addException(assigned);
                        } else {
                            relationships.add(Pair.of((Object)otherEnd.getKey(), (Object)patch.getRelationshipTO().getType()));
                            ARelationship newRelationship = (ARelationship)this.entityFactory.newEntity(ARelationship.class);
                            newRelationship.setType(relationshipType);
                            newRelationship.setRightEnd((Any)otherEnd);
                            newRelationship.setLeftEnd((Any)anyObject);
                            anyObject.add((Relationship)newRelationship);
                        }
                    }
                }
            }
        });
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        HashSet groups = new HashSet();
        anyObjectUR.getMemberships().stream().filter(patch -> patch.getGroup() != null).forEach(patch -> {
            anyObject.getMembership(patch.getGroup()).ifPresent(membership -> {
                anyObject.remove((Membership)membership);
                membership.setLeftEnd(null);
                anyObject.getPlainAttrs((Membership)membership).forEach(arg_0 -> ((AnyObject)anyObject).remove(arg_0));
                this.anyObjectDAO.deleteMembership(membership);
                if (patch.getOperation() == PatchOperation.DELETE) {
                    propByRes.addAll(ResourceOperation.UPDATE, this.groupDAO.findAllResourceKeys(((Group)membership.getRightEnd()).getKey()));
                }
            });
            if (patch.getOperation() == PatchOperation.ADD_REPLACE) {
                Group group = this.groupDAO.findById(patch.getGroup()).orElse(null);
                if (group == null) {
                    LOG.debug("Ignoring invalid group {}", (Object)patch.getGroup());
                } else if (groups.contains(group.getKey())) {
                    LOG.error("Multiple patches for group {} of {} were found", (Object)group, (Object)anyObject);
                    SyncopeClientException assigned = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMembership);
                    assigned.getElements().add("Multiple patches for group " + group.getName() + " were found");
                    scce.addException(assigned);
                } else {
                    groups.add(group.getKey());
                    AMembership newMembership = (AMembership)this.entityFactory.newEntity(AMembership.class);
                    newMembership.setRightEnd((Any)group);
                    newMembership.setLeftEnd((Any)anyObject);
                    anyObject.add((Membership)newMembership);
                    patch.getPlainAttrs().forEach(attrTO -> this.getPlainSchema(attrTO.getSchema()).ifPresentOrElse(schema -> anyObject.getPlainAttr(schema.getKey(), (Membership)newMembership).ifPresentOrElse(attr -> LOG.debug("Plain attribute found for {} and membership of {}, nothing to do", schema, (Object)newMembership.getRightEnd()), () -> {
                        LOG.debug("No plain attribute found for {} and membership of {}", schema, (Object)newMembership.getRightEnd());
                        PlainAttr newAttr = new PlainAttr();
                        newAttr.setMembership(newMembership.getKey());
                        newAttr.setPlainSchema(schema);
                        anyObject.add(newAttr);
                        this.processAttrPatch((AnyTO)anyTO, (Any)anyObject, (AttrPatch)new AttrPatch.Builder(attrTO).build(), (PlainSchema)schema, newAttr, invalidValues);
                    }), () -> LOG.debug("Invalid {}{}, ignoring...", (Object)PlainSchema.class.getSimpleName(), (Object)attrTO.getSchema())));
                    if (!invalidValues.isEmpty()) {
                        scce.addException(invalidValues);
                    }
                    propByRes.addAll(ResourceOperation.UPDATE, this.groupDAO.findAllResourceKeys(group.getKey()));
                }
            }
        });
        if (scce.hasExceptions()) {
            throw scce;
        }
        AnyObject saved = (AnyObject)this.anyObjectDAO.save((Entity)anyObject);
        propByRes.merge(this.propByRes(beforeOnResources, this.onResources((Any)saved, this.anyObjectDAO.findAllResourceKeys(anyObject.getKey()), null, Set.of())));
        return propByRes;
    }
}

